/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JTypeVar;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.homunculus.android.component.module.storage.Persistent;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.Strings;
import org.homunculusframework.factory.container.ModelAndView;
import org.homunculusframework.factory.flavor.hcf.Bind;
import org.homunculusframework.factory.scope.LifecycleOwner;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Panic;
import org.homunculusframework.lang.Ref;

public class GenerateBindables
implements Generator {
    private static final FullQualifiedName HCF_ANDROID_RES = new FullQualifiedName("org.homunculus.android.flavor.Resource");
    private static final FullQualifiedName ANDROID_VIEW = new FullQualifiedName(View.class);
    private static final FullQualifiedName STRING = new FullQualifiedName(String.class);
    private static final FullQualifiedName INT = new FullQualifiedName(Integer.TYPE);
    private static final FullQualifiedName FLOAT = new FullQualifiedName(Float.TYPE);
    private static final FullQualifiedName DOUBLE = new FullQualifiedName(Double.TYPE);
    private static final FullQualifiedName BOOL = new FullQualifiedName(Boolean.TYPE);
    private static final FullQualifiedName CHAR = new FullQualifiedName(Character.TYPE);
    private static final FullQualifiedName LONG = new FullQualifiedName(Long.TYPE);
    private static final FullQualifiedName BYTE = new FullQualifiedName(Byte.TYPE);
    private static final FullQualifiedName PERSISTENT = new FullQualifiedName(Persistent.class);
    private static final FullQualifiedName ANDROID_DRAWABLE = new FullQualifiedName(Drawable.class);
    private static final FullQualifiedName ANDROID_BITMAP = new FullQualifiedName(Bitmap.class);

    @Override
    public void generate(GenProject project) throws Exception {
        JCodeModel code = project.getCodeModel();
        for (FullQualifiedName bean : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.BIND)) {
            JDefinedClass binder = code._class(1, bean.getPackageName() + ".Bind" + bean.getSimpleName());
            Constructor shortestConstructor = null;
            for (Constructor constructor : project.getResolver().getConstructors(bean)) {
                if (constructor.isPrivate() || shortestConstructor != null && constructor.getParameters().size() >= shortestConstructor.getParameters().size()) continue;
                shortestConstructor = constructor;
            }
            PreSolved preSolved = new PreSolved();
            preSolved.constructor = shortestConstructor;
            preSolved.allFields = project.getResolver().getFields(bean);
            preSolved.injectParams = new ArrayList<Field>();
            for (Field field : preSolved.allFields) {
                if (field.getAnnotation(Bind.class) != null) {
                    preSolved.bindParams.add(field);
                    continue;
                }
                Annotation androidResource = field.getAnnotation(HCF_ANDROID_RES);
                if (androidResource != null) {
                    FullQualifiedName fqn = androidResource.getFullQualifiedName();
                    if (fqn == null) {
                        throw androidResource.newLintException("unsupported constant declaration");
                    }
                    preSolved.androidResource.add(field);
                    continue;
                }
                if (field.getAnnotation(Inject.class) == null) continue;
                preSolved.injectParams.add(field);
            }
            try {
                this.createBindBean(project.getResolver(), code, bean, binder, preSolved);
            }
            catch (Throwable throwable) {
                throw new Panic("failed to process " + bean, throwable);
            }
            binder._extends(code.ref(ModelAndView.class).narrow(preSolved.extendClassNarrows));
        }
    }

    static Map<FullQualifiedName, Object> createLiterals(Parameter p) {
        return GenerateBindables.createLiterals(p.getType(), p.getName());
    }

    static Map<FullQualifiedName, Object> createLiterals(Field p) {
        return GenerateBindables.createLiterals(p.getType().getFullQualifiedName(), p.getName());
    }

    static Map<FullQualifiedName, Object> createLiterals(FullQualifiedName f, String name) {
        if (f.equals(PERSISTENT)) {
            TreeMap<FullQualifiedName, Object> res = new TreeMap<FullQualifiedName, Object>();
            res.put(STRING, name);
            return res;
        }
        return null;
    }

    private void createBindBean(Resolver resolver, JCodeModel code, FullQualifiedName bindable, JDefinedClass binder, PreSolved preSolved) throws Exception {
        JFieldVar field;
        JVar cParam;
        JMethod creator = binder.constructor(1);
        if (preSolved.constructor != null) {
            for (Parameter p : preSolved.constructor.getParameters()) {
                if (p.getAnnotation(Bind.class) == null) continue;
                cParam = creator.param((AbstractJType)code.ref(p.getType().toString()), p.getName());
                field = binder.field(12, cParam.type(), cParam.name());
                creator.body().add((IJStatement)JExpr._this().ref((JVar)field).assign((IJExpression)cParam));
            }
        }
        for (Field bindParam : preSolved.bindParams) {
            cParam = creator.param((AbstractJType)code.ref(bindParam.getType().getFullQualifiedName().toString()), bindParam.getName());
            field = binder.field(4, cParam.type(), cParam.name());
            creator.body().add((IJStatement)JExpr._this().ref((JVar)field).assign((IJExpression)cParam));
        }
        JDefinedClass bindableScope = code._getClass(bindable + "Scope");
        if (bindableScope == null) {
            throw new Panic("GenerateScopes must run before");
        }
        AbstractJClass bindableScopeParent = code.ref(((JMethod)bindableScope.constructors().next()).listParams()[0].type().fullName());
        JDefinedClass parentScope = code._getClass(bindableScopeParent.fullName());
        AbstractJClass bindableType = code.ref(bindable.toString());
        JMethod createBindable = binder.method(1, (AbstractJType)bindableScope, "create");
        createBindable._throws(Exception.class);
        createBindable.annotate(Override.class);
        preSolved.extendClassNarrows.add((AbstractJClass)bindableScope);
        preSolved.extendClassNarrows.add(bindableScopeParent.narrowAny());
        JVar varParentScope = createBindable.param((AbstractJType)bindableScopeParent, "scope");
        JInvocation invocCtr = JExpr._new((AbstractJType)bindableType);
        JVar bean = createBindable.body().decl((AbstractJType)bindableType, "bindable", (IJExpression)invocCtr);
        JInvocation beanScopeCtr = JExpr._new((AbstractJClass)bindableScope).arg((IJExpression)varParentScope).arg((IJExpression)bean);
        JVar beanScope = createBindable.body().decl((AbstractJType)bindableScope, "bindableScope", (IJExpression)beanScopeCtr);
        Ref hasOwnership = new Ref((Object)false);
        if (preSolved.constructor != null) {
            for (Parameter p : preSolved.constructor.getParameters()) {
                if (p.getAnnotation(Bind.class) != null) {
                    invocCtr.arg((IJExpression)binder.fields().get(p.getName()));
                    continue;
                }
                invocCtr.arg(GenerateBindables.resolveDependencyFromScope(GenerateBindables.createLiterals(p), resolver, code, beanScope, parentScope, varParentScope, (AbstractJType)code.ref(p.getType().toString()), (Ref<Boolean>)hasOwnership));
            }
        }
        for (Field bindParam : preSolved.bindParams) {
            JFieldVar field2 = (JFieldVar)binder.fields().get(bindParam.getName());
            createBindable.body().add((IJStatement)bean.ref(bindParam.getName()).assign((IJExpression)field2));
        }
        for (Field injectParam : preSolved.injectParams) {
            try {
                IJExpression invoc = GenerateBindables.resolveDependencyFromScope(GenerateBindables.createLiterals(injectParam), resolver, code, beanScope, parentScope, varParentScope, (AbstractJType)code.ref(injectParam.getType().getFullQualifiedName().toString()), (Ref<Boolean>)hasOwnership);
                createBindable.body().add((IJStatement)bean.ref(injectParam.getName()).assign(invoc));
            }
            catch (Throwable e) {
                e.printStackTrace();
                String what = bean.type().fullName() + "." + injectParam.getType().getFullQualifiedName() + " " + injectParam.getName();
                throw injectParam.newLintException("failed to get injection source. This is caused by using an abstract or interface type without providing an instance of @ScopeElement: " + what);
            }
        }
        for (Field androidResource : preSolved.androidResource) {
            FullQualifiedName fqn = androidResource.getAnnotation(HCF_ANDROID_RES).getConstant("");
            IJExpression getContext = GenerateBindables.resolveDependencyFromScope(null, resolver, code, beanScope, parentScope, varParentScope, (AbstractJType)code.ref(Context.class), (Ref<Boolean>)hasOwnership);
            IJExpression staticRef = JExpr.direct((String)fqn.toString());
            FullQualifiedName fieldFqn = androidResource.getType().getFullQualifiedName();
            if (fieldFqn.equals(STRING)) {
                createBindable.body().add((IJStatement)bean.ref(androidResource.getName()).assign((IJExpression)getContext.invoke("getString").arg(staticRef)));
                continue;
            }
            if (fieldFqn.equals(ANDROID_VIEW)) {
                AbstractJClass layoutInflater = code.ref(LayoutInflater.class);
                createBindable.body().add((IJStatement)bean.ref(androidResource.getName()).assign((IJExpression)layoutInflater.staticInvoke("from").arg(getContext).invoke("inflate").arg(staticRef).arg((IJExpression)JExpr._null())));
                continue;
            }
            if (fieldFqn.equals(ANDROID_DRAWABLE)) {
                createBindable.body().add((IJStatement)bean.ref(androidResource.getName()).assign((IJExpression)getContext.invoke("getResources").invoke("getDrawable").arg(staticRef)));
                continue;
            }
            if (fieldFqn.equals(ANDROID_BITMAP)) {
                AbstractJClass bitmapFactory = code.ref(BitmapFactory.class);
                createBindable.body().add((IJStatement)bean.ref(androidResource.getName()).assign((IJExpression)bitmapFactory.staticInvoke("decodeResource").arg((IJExpression)getContext.invoke("getResources")).arg(staticRef)));
                continue;
            }
            throw androidResource.getAnnotation(HCF_ANDROID_RES).newLintException("cannot provide android resource into " + androidResource.getType().getFullQualifiedName());
        }
        createBindable.body()._return((IJExpression)beanScope);
        for (Field bindParam : preSolved.bindParams) {
            JMethod getter = binder.method(1, (AbstractJType)code.ref(bindParam.getType().getFullQualifiedName().toString()), "get" + Strings.startUpperCase(bindParam.getName()));
            getter.body()._return((IJExpression)binder.fields().get(bindParam.getName()));
            JMethod setter = binder.method(1, Void.TYPE, "set" + Strings.startUpperCase(bindParam.getName()));
            JVar var = setter.param((AbstractJType)code.ref(bindParam.getType().getFullQualifiedName().toString()), bindParam.getName());
            setter.body().assign((IJAssignmentTarget)JExpr._this().ref(bindParam.getName()), (IJExpression)var);
        }
    }

    private static IJExpression resolveDependencyFromScope(@Nullable Map<FullQualifiedName, Object> literals, Resolver resolver, JCodeModel code, JVar beanScope, JDefinedClass parentScope, JVar varParentScope, AbstractJType type, Ref<Boolean> hasOwnership) throws Exception {
        IJExpression specialCreate;
        if (resolver.isInstanceOf(new FullQualifiedName(type.fullName()), new FullQualifiedName(Scope.class))) {
            return beanScope;
        }
        if (resolver.isInstanceOf(new FullQualifiedName(type.fullName()), new FullQualifiedName(LifecycleOwner.class))) {
            return beanScope;
        }
        hasOwnership.set((Object)false);
        JMethod matchingMethod = GenerateBindables.resolveMatchingMethod(resolver, parentScope, type);
        if (matchingMethod != null) {
            hasOwnership.set((Object)true);
            return varParentScope.invoke(matchingMethod);
        }
        for (JMethod method : parentScope.methods()) {
            if (!method.name().equals("getParent")) continue;
            hasOwnership.set((Object)false);
            JDefinedClass parentParentScope = code._getClass(method.type().fullName());
            JMethod parentMatchingMethod = GenerateBindables.resolveMatchingMethod(resolver, parentParentScope, type);
            if (parentMatchingMethod == null) break;
            return varParentScope.invoke(method).invoke(parentMatchingMethod);
        }
        if ((specialCreate = GenerateBindables.specialConstructorRules(literals, resolver, code, beanScope, parentScope, varParentScope, type, hasOwnership)) != null) {
            return specialCreate;
        }
        IJExpression constructorCall = GenerateBindables.createConstructorCall(literals, resolver, code, beanScope, parentScope, varParentScope, type, hasOwnership);
        hasOwnership.set((Object)true);
        return constructorCall;
    }

    @Nullable
    private static IJExpression specialConstructorRules(@Nullable Map<FullQualifiedName, Object> literals, Resolver resolver, JCodeModel code, JVar beanScope, JDefinedClass parentScope, JVar varParentScope, AbstractJType type, Ref<Boolean> hasOwnership) {
        Object obj;
        if (resolver.isInstanceOf(new FullQualifiedName(type.fullName()), new FullQualifiedName(Handler.class))) {
            return JExpr._new((AbstractJClass)code.ref(Handler.class)).arg((IJExpression)code.ref(Looper.class).staticInvoke("getMainLooper"));
        }
        if (resolver.isInstanceOf(new FullQualifiedName(type.fullName()), new FullQualifiedName(LayoutInflater.class))) {
            return code.ref(LayoutInflater.class).staticInvoke("from").arg((IJExpression)varParentScope.invoke("getContext"));
        }
        if (resolver.isInstanceOf(new FullQualifiedName(type.fullName()), new FullQualifiedName(List.class))) {
            return JExpr._new((AbstractJClass)code.ref(ArrayList.class).narrowEmpty());
        }
        if (literals != null && (obj = literals.get(new FullQualifiedName(type.fullName()))) instanceof String) {
            return JExpr.lit((String)((String)obj));
        }
        return null;
    }

    private static JMethod resolveMatchingMethod(Resolver resolver, JDefinedClass parentScope, AbstractJType type) {
        if (parentScope == null) {
            return null;
        }
        FullQualifiedName targetType = new FullQualifiedName(type.fullName());
        for (JMethod method : parentScope.methods()) {
            FullQualifiedName methodType;
            if (!method.name().startsWith("get") || !resolver.isInstanceOf(methodType = GenerateBindables.resolveTypeParam(parentScope, method), targetType)) continue;
            return method;
        }
        return null;
    }

    private static FullQualifiedName resolveTypeParam(JDefinedClass cl, JMethod method) {
        for (JTypeVar typeVar : cl.typeParams()) {
            if (!method.type().fullName().equals(typeVar.fullName())) continue;
            return new FullQualifiedName(((AbstractJClass)typeVar.bounds().iterator().next()).fullName());
        }
        return new FullQualifiedName(method.type().fullName());
    }

    static IJExpression createConstructorCall(@Nullable Map<FullQualifiedName, Object> literals, Resolver resolver, JCodeModel code, JVar beanScope, JDefinedClass parentScope, JVar varParentScope, AbstractJType type, Ref<Boolean> hasOwnership) throws Exception {
        FullQualifiedName fqnType = new FullQualifiedName(type.fullName());
        FullQualifiedName binder = new FullQualifiedName(fqnType.getPackageName() + ".Bind" + fqnType.getSimpleName());
        if (code._getClass(binder.toString()) != null) {
            return GenerateBindables.resolveDependencyFromScope(literals, resolver, code, beanScope, parentScope, varParentScope, (AbstractJType)code.ref(binder.toString()), hasOwnership).invoke("create").arg((IJExpression)varParentScope).invoke("get" + Strings.startUpperCase(fqnType.getSimpleName()));
        }
        if (resolver.has(fqnType)) {
            Constructor shortestConstructor = null;
            for (Constructor constructor : resolver.getConstructors(new FullQualifiedName(type.fullName()))) {
                if (constructor.isPrivate() || shortestConstructor != null && constructor.getParameters().size() >= shortestConstructor.getParameters().size()) continue;
                shortestConstructor = constructor;
            }
            if (shortestConstructor == null || shortestConstructor.getParameters().isEmpty()) {
                return JExpr._new((AbstractJType)type);
            }
            JInvocation newCall = JExpr._new((AbstractJType)type);
            for (Parameter p : shortestConstructor.getParameters()) {
                newCall.arg(GenerateBindables.resolveDependencyFromScope(literals, resolver, code, beanScope, parentScope, varParentScope, (AbstractJType)code.ref(p.getType().toString()), hasOwnership));
            }
            return newCall;
        }
        IJExpression primitiveCreator = GenerateBindables.createDefaultPrimitive(fqnType);
        if (primitiveCreator != null) {
            return primitiveCreator;
        }
        JDefinedClass definedClass = code._getClass(type.fullName());
        if (definedClass == null) {
            throw new Panic("no such generated class: " + type.fullName());
        }
        if (!definedClass.constructors().hasNext()) {
            throw new RuntimeException("cannot find any constructor for " + definedClass);
        }
        JMethod jMethod = (JMethod)definedClass.constructors().next();
        JInvocation newCall = JExpr._new((AbstractJType)type);
        for (JVar p : jMethod.params()) {
            newCall.arg(GenerateBindables.resolveDependencyFromScope(literals, resolver, code, beanScope, parentScope, varParentScope, p.type(), hasOwnership));
        }
        return newCall;
    }

    @Nullable
    private static IJExpression createDefaultPrimitive(FullQualifiedName fqn) {
        if (fqn.equals(INT)) {
            return JExpr.lit((int)0);
        }
        if (fqn.equals(FLOAT)) {
            return JExpr.lit((float)0.0f);
        }
        if (fqn.equals(LONG)) {
            return JExpr.lit((long)0L);
        }
        if (fqn.equals(DOUBLE)) {
            return JExpr.lit((double)0.0);
        }
        if (fqn.equals(BOOL)) {
            return JExpr.lit((boolean)false);
        }
        if (fqn.equals(CHAR)) {
            return JExpr.lit((char)'\u0000');
        }
        if (fqn.equals(BYTE)) {
            return JExpr.lit((int)0);
        }
        if (fqn.equals(STRING)) {
            return JExpr._null();
        }
        return null;
    }

    private static class PreSolved {
        @Nullable
        Constructor constructor;
        List<Field> allFields = new ArrayList<Field>();
        List<Field> bindParams = new ArrayList<Field>();
        List<Field> injectParams = new ArrayList<Field>();
        List<Field> androidResource = new ArrayList<Field>();
        List<Field> ownedDestroyableElements = new ArrayList<Field>();
        List<AbstractJClass> extendClassNarrows = new ArrayList<AbstractJClass>();

        private PreSolved() {
        }
    }
}

