/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.Strings;
import org.homunculusframework.factory.container.DefaultRequestContext;
import org.homunculusframework.factory.container.MethodBinding;
import org.homunculusframework.factory.container.ModelAndView;
import org.homunculusframework.factory.container.ObjectBinding;
import org.homunculusframework.factory.container.RequestContext;
import org.homunculusframework.lang.Panic;

public class GenerateMethodBindings
implements Generator {
    private static final FullQualifiedName REQUEST_CONTEXT = new FullQualifiedName(RequestContext.class);

    @Override
    public void generate(GenProject project) throws Exception {
        JCodeModel code = project.getCodeModel();
        FullQualifiedName application = project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.APPLICATION).iterator().next();
        FullQualifiedName commonActivityContract = new FullQualifiedName(application.getPackageName() + ".ActivityScope");
        for (FullQualifiedName bean : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.SINGLETON)) {
            String ctrName = "Async" + bean.getSimpleName();
            JDefinedClass cl = project.getCodeModel()._getClass(bean.getPackageName() + "." + ctrName);
            if (cl == null) {
                throw new RuntimeException(ctrName + " not found in codemodel");
            }
            for (Method method : project.getResolver().getMethods(bean)) {
                if (method.isPrivate() || method.isProtected() || method.isStatic()) continue;
                String[] allowedReturnValues = new String[]{ObjectBinding.class.getName(), ModelAndView.class.getName()};
                boolean allowed = false;
                for (String c : allowedReturnValues) {
                    if (!project.getResolver().isInstanceOf(method.getType().getFullQualifiedName(), new FullQualifiedName(c))) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) continue;
                JDefinedClass binding = (JDefinedClass)cl._class(17, "Invoke" + bean.getSimpleName() + Strings.startUpperCase(method.getName()));
                binding.javadoc().add((Object)("A decoupled binding to {@link " + method.asJavadocAnchor() + "} which is serializable."));
                AbstractJClass activityScope = code.ref(commonActivityContract.toString()).narrowAny();
                binding._extends((AbstractJClass)project.getCodeModel().ref(MethodBinding.class).narrow(activityScope));
                ArrayList<InferenceParameter> fieldsOrInferencedParameters = new ArrayList<InferenceParameter>();
                JMethod con = binding.constructor(1);
                for (Parameter p : method.getParameters()) {
                    if (this.isInferenceParameter(p.getType())) {
                        fieldsOrInferencedParameters.add(new InferenceParameter(p.getType()));
                        continue;
                    }
                    AbstractJClass pType = project.getCodeModel().ref(p.getType().toString());
                    JFieldVar thisVar = binding.field(4, (AbstractJType)pType, p.getName());
                    fieldsOrInferencedParameters.add((InferenceParameter)thisVar);
                    JVar jVar = con.param((AbstractJType)pType, p.getName());
                    con.body().assign((IJAssignmentTarget)JExpr._this().ref((JVar)thisVar), (IJExpression)jVar);
                }
                JMethod onExecute = binding.method(1, (AbstractJType)project.getCodeModel().ref(ObjectBinding.class).narrowAny().narrowAny(), "create")._throws(Exception.class);
                onExecute.annotate(project.getCodeModel().ref(Override.class));
                JVar scopeVar = onExecute.param((AbstractJType)activityScope, "scope");
                JInvocation getCtr = scopeVar.invoke("getParent").invoke("get" + bean.getSimpleName()).invoke(method.getName());
                for (Object e : fieldsOrInferencedParameters) {
                    if (e instanceof InferenceParameter) {
                        FullQualifiedName fqn = ((InferenceParameter)e).type;
                        if (fqn.equals(REQUEST_CONTEXT)) {
                            getCtr.arg((IJExpression)JExpr._new((AbstractJClass)code.ref(DefaultRequestContext.class)).arg((IJExpression)scopeVar.invoke("getNavigation")));
                            continue;
                        }
                        throw new Panic("implicit inferencing not supported " + fqn);
                    }
                    getCtr.arg((IJExpression)((JFieldVar)e));
                }
                onExecute.body()._return((IJExpression)getCtr);
                binding.method(1, String.class, "toString").body()._return((IJExpression)JExpr.lit((String)(bean.getSimpleName() + "." + method.getName())));
            }
        }
    }

    private boolean isInferenceParameter(FullQualifiedName fqn) {
        return fqn.equals(REQUEST_CONTEXT);
    }

    static class InferenceParameter {
        final FullQualifiedName type;

        public InferenceParameter(FullQualifiedName type) {
            this.type = type;
        }
    }
}

