/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse;

import java.util.List;
import javax.annotation.Nullable;
import org.homunculus.codegen.generator.LintException;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.Type;

public interface Method {
    public boolean isPrivate();

    public boolean isPublic();

    public boolean isAbstract();

    public boolean isProtected();

    public boolean isNative();

    public boolean isStatic();

    default public boolean isDefault() {
        return !this.isNative() && !this.isProtected() && !this.isPublic() && !this.isPrivate();
    }

    public boolean isDeclared();

    public String getName();

    public List<Annotation> getAnnotations();

    @Nullable
    default public Annotation getAnnotation(FullQualifiedName name) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.getFullQualifiedName().equals(name)) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    default public Annotation getAnnotation(Class cl) {
        return this.getAnnotation(new FullQualifiedName(cl));
    }

    public LintException newLintException(String var1);

    public List<Parameter> getParameters();

    public Type getType();

    public FullQualifiedName getDeclaringType();

    default public String asJavadocAnchor() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDeclaringType()).append("#");
        sb.append(this.getName());
        sb.append("(");
        for (Parameter p : this.getParameters()) {
            sb.append(p.getType());
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }
}

