/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.reflection;

import java.util.ArrayList;
import java.util.List;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.reflection.ReflectionConstructor;
import org.homunculus.codegen.parse.reflection.ReflectionField;
import org.homunculus.codegen.parse.reflection.ReflectionMethod;
import org.homunculusframework.lang.Reflection;

public class ReflectionResolver
implements Resolver {
    @Override
    public boolean has(FullQualifiedName name) {
        try {
            Class.forName(name.toString());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void listTypes(FullQualifiedName src, List<FullQualifiedName> found, List<FullQualifiedName> notFound) {
        try {
            Class<?> t = Class.forName(src.toString());
            found.add(src);
            if (t.getSuperclass() != null) {
                this.listTypes(new FullQualifiedName(t.getSuperclass()), found, notFound);
            }
            for (Class<?> i : t.getInterfaces()) {
                this.listTypes(new FullQualifiedName(i), found, notFound);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            notFound.add(src);
        }
    }

    @Override
    public void getSuperTypes(FullQualifiedName name, List<FullQualifiedName> dst) throws ClassNotFoundException {
        Class<?> t = Class.forName(name.toString());
        dst.add(new FullQualifiedName(t));
        if (t.getSuperclass() != null) {
            this.getSuperTypes(new FullQualifiedName(t), dst);
        }
        for (Class<?> i : t.getInterfaces()) {
            this.getSuperTypes(new FullQualifiedName(i.getName()), dst);
        }
    }

    @Override
    public List<Constructor> getConstructors(FullQualifiedName name) throws ClassNotFoundException {
        ArrayList<Constructor> res = new ArrayList<Constructor>();
        for (java.lang.reflect.Constructor<?> c : Class.forName(name.toString()).getConstructors()) {
            res.add(new ReflectionConstructor(c, name));
        }
        return res;
    }

    @Override
    public List<Method> getMethods(FullQualifiedName name) throws ClassNotFoundException {
        Class<?> c = null;
        try {
            c = Class.forName(name.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ArrayList<Method> res = new ArrayList<Method>();
        for (java.lang.reflect.Method m : Reflection.getMethods(c)) {
            res.add(new ReflectionMethod(m));
        }
        return res;
    }

    @Override
    public List<Field> getFields(FullQualifiedName name) throws ClassNotFoundException {
        Class<?> c = null;
        c = Class.forName(name.toString());
        ArrayList<Field> res = new ArrayList<Field>();
        for (java.lang.reflect.Field m : Reflection.getFields(c)) {
            res.add(new ReflectionField(m));
        }
        return res;
    }

    @Override
    public List<FullQualifiedName> getTypes() {
        return new ArrayList<FullQualifiedName>();
    }

    @Override
    public boolean isAbstract(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isPublic(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isPrivate(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isStatic(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isNested(FullQualifiedName name) {
        return false;
    }

    @Override
    public boolean isTopLevelType(FullQualifiedName name) {
        return true;
    }

    @Override
    public List<Annotation> getAnnotations(FullQualifiedName name) {
        return new ArrayList<Annotation>();
    }

    @Override
    public boolean isInstanceOf(FullQualifiedName which, FullQualifiedName what) {
        return false;
    }
}

