/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.core.app.SharedElementCallback;
import androidx.core.os.CancellationSignal;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.FragmentTransitionCompat21;
import androidx.fragment.app.FragmentTransitionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class FragmentTransition {
    private static final int[] INVERSE_OPS = new int[]{0, 3, 0, 1, 5, 4, 7, 6, 9, 8, 10};
    static final FragmentTransitionImpl PLATFORM_IMPL = Build.VERSION.SDK_INT >= 21 ? new FragmentTransitionCompat21() : null;
    static final FragmentTransitionImpl SUPPORT_IMPL = FragmentTransition.resolveSupportImpl();

    private static FragmentTransitionImpl resolveSupportImpl() {
        try {
            Class<?> impl = Class.forName("androidx.transition.FragmentTransitionSupport");
            return (FragmentTransitionImpl)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void startTransitions(@NonNull Context context, @NonNull FragmentContainer fragmentContainer, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex, boolean isReordered, Callback callback) {
        SparseArray transitioningFragments = new SparseArray();
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                FragmentTransition.calculatePopFragments(record, (SparseArray<FragmentContainerTransition>)transitioningFragments, isReordered);
                continue;
            }
            FragmentTransition.calculateFragments(record, (SparseArray<FragmentContainerTransition>)transitioningFragments, isReordered);
        }
        if (transitioningFragments.size() != 0) {
            View nonExistentView = new View(context);
            int numContainers = transitioningFragments.size();
            for (int i = 0; i < numContainers; ++i) {
                ViewGroup container;
                int containerId = transitioningFragments.keyAt(i);
                ArrayMap<String, String> nameOverrides = FragmentTransition.calculateNameOverrides(containerId, records, isRecordPop, startIndex, endIndex);
                FragmentContainerTransition containerTransition = (FragmentContainerTransition)transitioningFragments.valueAt(i);
                if (!fragmentContainer.onHasView() || (container = (ViewGroup)fragmentContainer.onFindViewById(containerId)) == null) continue;
                if (isReordered) {
                    FragmentTransition.configureTransitionsReordered(container, containerTransition, nonExistentView, nameOverrides, callback);
                    continue;
                }
                FragmentTransition.configureTransitionsOrdered(container, containerTransition, nonExistentView, nameOverrides, callback);
            }
        }
    }

    private static ArrayMap<String, String> calculateNameOverrides(int containerId, ArrayList<BackStackRecord> records, ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        ArrayMap nameOverrides = new ArrayMap();
        for (int recordNum = endIndex - 1; recordNum >= startIndex; --recordNum) {
            ArrayList sources;
            ArrayList targets;
            BackStackRecord record = records.get(recordNum);
            if (!record.interactsWith(containerId)) continue;
            boolean isPop = isRecordPop.get(recordNum);
            if (record.mSharedElementSourceNames == null) continue;
            int numSharedElements = record.mSharedElementSourceNames.size();
            if (isPop) {
                targets = record.mSharedElementSourceNames;
                sources = record.mSharedElementTargetNames;
            } else {
                sources = record.mSharedElementSourceNames;
                targets = record.mSharedElementTargetNames;
            }
            for (int i = 0; i < numSharedElements; ++i) {
                String sourceName = (String)sources.get(i);
                String targetName = (String)targets.get(i);
                String previousTarget = (String)nameOverrides.remove((Object)targetName);
                if (previousTarget != null) {
                    nameOverrides.put((Object)sourceName, (Object)previousTarget);
                    continue;
                }
                nameOverrides.put((Object)sourceName, (Object)targetName);
            }
        }
        return nameOverrides;
    }

    private static void configureTransitionsReordered(@NonNull ViewGroup container, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides, final Callback callback) {
        final Fragment outFragment = fragments.firstOut;
        Fragment inFragment = fragments.lastIn;
        FragmentTransitionImpl impl = FragmentTransition.chooseImpl(outFragment, inFragment);
        if (impl == null) {
            return;
        }
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        Object enterTransition = FragmentTransition.getEnterTransition(impl, inFragment, inIsPop);
        Object exitTransition = FragmentTransition.getExitTransition(impl, outFragment, outIsPop);
        Object sharedElementTransition = FragmentTransition.configureSharedElementsReordered(impl, container, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(impl, exitTransition, outFragment, sharedElementsOut, nonExistentView);
        ArrayList<View> enteringViews = FragmentTransition.configureEnteringExitingViews(impl, enterTransition, inFragment, sharedElementsIn, nonExistentView);
        FragmentTransition.setViewVisibility(enteringViews, 4);
        Object transition = FragmentTransition.mergeTransitions(impl, enterTransition, exitTransition, sharedElementTransition, inFragment, inIsPop);
        if (outFragment != null && exitingViews != null && (exitingViews.size() > 0 || sharedElementsOut.size() > 0)) {
            final CancellationSignal signal = new CancellationSignal();
            callback.onStart(outFragment, signal);
            impl.setListenerForTransitionEnd(outFragment, transition, signal, new Runnable(){

                @Override
                public void run() {
                    callback.onComplete(outFragment, signal);
                }
            });
        }
        if (transition != null) {
            FragmentTransition.replaceHide(impl, exitTransition, outFragment, exitingViews);
            ArrayList<String> inNames = impl.prepareSetNameOverridesReordered(sharedElementsIn);
            impl.scheduleRemoveTargets(transition, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            impl.beginDelayedTransition(container, transition);
            impl.setNameOverridesReordered((View)container, sharedElementsOut, sharedElementsIn, inNames, (Map<String, String>)nameOverrides);
            FragmentTransition.setViewVisibility(enteringViews, 0);
            impl.swapSharedElementTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    private static void replaceHide(FragmentTransitionImpl impl, Object exitTransition, Fragment exitingFragment, final ArrayList<View> exitingViews) {
        if (exitingFragment != null && exitTransition != null && exitingFragment.mAdded && exitingFragment.mHidden && exitingFragment.mHiddenChanged) {
            exitingFragment.setHideReplaced(true);
            impl.scheduleHideFragmentView(exitTransition, exitingFragment.getView(), exitingViews);
            ViewGroup container = exitingFragment.mContainer;
            OneShotPreDrawListener.add((View)container, new Runnable(){

                @Override
                public void run() {
                    FragmentTransition.setViewVisibility(exitingViews, 4);
                }
            });
        }
    }

    private static void configureTransitionsOrdered(@NonNull ViewGroup container, FragmentContainerTransition fragments, View nonExistentView, ArrayMap<String, String> nameOverrides, final Callback callback) {
        final Fragment outFragment = fragments.firstOut;
        Fragment inFragment = fragments.lastIn;
        FragmentTransitionImpl impl = FragmentTransition.chooseImpl(outFragment, inFragment);
        if (impl == null) {
            return;
        }
        boolean inIsPop = fragments.lastInIsPop;
        boolean outIsPop = fragments.firstOutIsPop;
        Object enterTransition = FragmentTransition.getEnterTransition(impl, inFragment, inIsPop);
        Object exitTransition = FragmentTransition.getExitTransition(impl, outFragment, outIsPop);
        ArrayList<View> sharedElementsOut = new ArrayList<View>();
        ArrayList<View> sharedElementsIn = new ArrayList<View>();
        Object sharedElementTransition = FragmentTransition.configureSharedElementsOrdered(impl, container, nonExistentView, nameOverrides, fragments, sharedElementsOut, sharedElementsIn, enterTransition, exitTransition);
        if (enterTransition == null && sharedElementTransition == null && exitTransition == null) {
            return;
        }
        ArrayList<View> exitingViews = FragmentTransition.configureEnteringExitingViews(impl, exitTransition, outFragment, sharedElementsOut, nonExistentView);
        if (exitingViews == null || exitingViews.isEmpty()) {
            exitTransition = null;
        }
        impl.addTarget(enterTransition, nonExistentView);
        Object transition = FragmentTransition.mergeTransitions(impl, enterTransition, exitTransition, sharedElementTransition, inFragment, fragments.lastInIsPop);
        if (outFragment != null && exitingViews != null && (exitingViews.size() > 0 || sharedElementsOut.size() > 0)) {
            final CancellationSignal signal = new CancellationSignal();
            callback.onStart(outFragment, signal);
            impl.setListenerForTransitionEnd(outFragment, transition, signal, new Runnable(){

                @Override
                public void run() {
                    callback.onComplete(outFragment, signal);
                }
            });
        }
        if (transition != null) {
            ArrayList<View> enteringViews = new ArrayList<View>();
            impl.scheduleRemoveTargets(transition, enterTransition, enteringViews, exitTransition, exitingViews, sharedElementTransition, sharedElementsIn);
            FragmentTransition.scheduleTargetChange(impl, container, inFragment, nonExistentView, sharedElementsIn, enterTransition, enteringViews, exitTransition, exitingViews);
            impl.setNameOverridesOrdered((View)container, sharedElementsIn, (Map<String, String>)nameOverrides);
            impl.beginDelayedTransition(container, transition);
            impl.scheduleNameReset(container, sharedElementsIn, (Map<String, String>)nameOverrides);
        }
    }

    private static void scheduleTargetChange(final FragmentTransitionImpl impl, ViewGroup sceneRoot, final Fragment inFragment, final View nonExistentView, final ArrayList<View> sharedElementsIn, final Object enterTransition, final ArrayList<View> enteringViews, final Object exitTransition, final ArrayList<View> exitingViews) {
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                if (enterTransition != null) {
                    impl.removeTarget(enterTransition, nonExistentView);
                    ArrayList<View> views = FragmentTransition.configureEnteringExitingViews(impl, enterTransition, inFragment, sharedElementsIn, nonExistentView);
                    enteringViews.addAll(views);
                }
                if (exitingViews != null) {
                    if (exitTransition != null) {
                        ArrayList<View> tempExiting = new ArrayList<View>();
                        tempExiting.add(nonExistentView);
                        impl.replaceTargets(exitTransition, exitingViews, tempExiting);
                    }
                    exitingViews.clear();
                    exitingViews.add(nonExistentView);
                }
            }
        });
    }

    private static FragmentTransitionImpl chooseImpl(Fragment outFragment, Fragment inFragment) {
        ArrayList<Object> transitions = new ArrayList<Object>();
        if (outFragment != null) {
            Object sharedReturnTransition;
            Object returnTransition;
            Object exitTransition = outFragment.getExitTransition();
            if (exitTransition != null) {
                transitions.add(exitTransition);
            }
            if ((returnTransition = outFragment.getReturnTransition()) != null) {
                transitions.add(returnTransition);
            }
            if ((sharedReturnTransition = outFragment.getSharedElementReturnTransition()) != null) {
                transitions.add(sharedReturnTransition);
            }
        }
        if (inFragment != null) {
            Object sharedEnterTransition;
            Object reenterTransition;
            Object enterTransition = inFragment.getEnterTransition();
            if (enterTransition != null) {
                transitions.add(enterTransition);
            }
            if ((reenterTransition = inFragment.getReenterTransition()) != null) {
                transitions.add(reenterTransition);
            }
            if ((sharedEnterTransition = inFragment.getSharedElementEnterTransition()) != null) {
                transitions.add(sharedEnterTransition);
            }
        }
        if (transitions.isEmpty()) {
            return null;
        }
        if (PLATFORM_IMPL != null && FragmentTransition.canHandleAll(PLATFORM_IMPL, transitions)) {
            return PLATFORM_IMPL;
        }
        if (SUPPORT_IMPL != null && FragmentTransition.canHandleAll(SUPPORT_IMPL, transitions)) {
            return SUPPORT_IMPL;
        }
        if (PLATFORM_IMPL != null || SUPPORT_IMPL != null) {
            throw new IllegalArgumentException("Invalid Transition types");
        }
        return null;
    }

    private static boolean canHandleAll(FragmentTransitionImpl impl, List<Object> transitions) {
        int size = transitions.size();
        for (int i = 0; i < size; ++i) {
            if (impl.canHandle(transitions.get(i))) continue;
            return false;
        }
        return true;
    }

    private static Object getSharedElementTransition(FragmentTransitionImpl impl, Fragment inFragment, Fragment outFragment, boolean isPop) {
        if (inFragment == null || outFragment == null) {
            return null;
        }
        Object transition = impl.cloneTransition(isPop ? outFragment.getSharedElementReturnTransition() : inFragment.getSharedElementEnterTransition());
        return impl.wrapTransitionInSet(transition);
    }

    private static Object getEnterTransition(FragmentTransitionImpl impl, Fragment inFragment, boolean isPop) {
        if (inFragment == null) {
            return null;
        }
        return impl.cloneTransition(isPop ? inFragment.getReenterTransition() : inFragment.getEnterTransition());
    }

    private static Object getExitTransition(FragmentTransitionImpl impl, Fragment outFragment, boolean isPop) {
        if (outFragment == null) {
            return null;
        }
        return impl.cloneTransition(isPop ? outFragment.getReturnTransition() : outFragment.getExitTransition());
    }

    private static Object configureSharedElementsReordered(final FragmentTransitionImpl impl, ViewGroup sceneRoot, View nonExistentView, ArrayMap<String, String> nameOverrides, FragmentContainerTransition fragments, ArrayList<View> sharedElementsOut, ArrayList<View> sharedElementsIn, Object enterTransition, Object exitTransition) {
        View epicenterView;
        Rect epicenter;
        final Fragment inFragment = fragments.lastIn;
        final Fragment outFragment = fragments.firstOut;
        if (inFragment != null) {
            inFragment.requireView().setVisibility(0);
        }
        if (inFragment == null || outFragment == null) {
            return null;
        }
        final boolean inIsPop = fragments.lastInIsPop;
        Object sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(impl, inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(impl, nameOverrides, sharedElementTransition, fragments);
        final ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(impl, nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
            if (outSharedElements != null) {
                outSharedElements.clear();
            }
            if (inSharedElements != null) {
                inSharedElements.clear();
            }
        } else {
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsOut, outSharedElements, nameOverrides.keySet());
            FragmentTransition.addSharedElementsWithMatchingNames(sharedElementsIn, inSharedElements, nameOverrides.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            sharedElementsIn.add(nonExistentView);
            impl.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(impl, sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            epicenter = new Rect();
            epicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
            if (epicenterView != null) {
                impl.setEpicenter(enterTransition, epicenter);
            }
        } else {
            epicenter = null;
            epicenterView = null;
        }
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, (ArrayMap<String, View>)inSharedElements, false);
                if (epicenterView != null) {
                    impl.getBoundsOnScreen(epicenterView, epicenter);
                }
            }
        });
        return sharedElementTransition;
    }

    private static void addSharedElementsWithMatchingNames(ArrayList<View> views, ArrayMap<String, View> sharedElements, Collection<String> nameOverridesSet) {
        for (int i = sharedElements.size() - 1; i >= 0; --i) {
            View view = (View)sharedElements.valueAt(i);
            if (!nameOverridesSet.contains(ViewCompat.getTransitionName(view))) continue;
            views.add(view);
        }
    }

    private static Object configureSharedElementsOrdered(final FragmentTransitionImpl impl, ViewGroup sceneRoot, final View nonExistentView, final ArrayMap<String, String> nameOverrides, final FragmentContainerTransition fragments, final ArrayList<View> sharedElementsOut, final ArrayList<View> sharedElementsIn, final Object enterTransition, Object exitTransition) {
        Rect inEpicenter;
        final Fragment inFragment = fragments.lastIn;
        final Fragment outFragment = fragments.firstOut;
        if (inFragment == null || outFragment == null) {
            return null;
        }
        final boolean inIsPop = fragments.lastInIsPop;
        Object sharedElementTransition = nameOverrides.isEmpty() ? null : FragmentTransition.getSharedElementTransition(impl, inFragment, outFragment, inIsPop);
        ArrayMap<String, View> outSharedElements = FragmentTransition.captureOutSharedElements(impl, nameOverrides, sharedElementTransition, fragments);
        if (nameOverrides.isEmpty()) {
            sharedElementTransition = null;
        } else {
            sharedElementsOut.addAll(outSharedElements.values());
        }
        if (enterTransition == null && exitTransition == null && sharedElementTransition == null) {
            return null;
        }
        FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, outSharedElements, true);
        if (sharedElementTransition != null) {
            inEpicenter = new Rect();
            impl.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementsOut);
            boolean outIsPop = fragments.firstOutIsPop;
            BackStackRecord outTransaction = fragments.firstOutTransaction;
            FragmentTransition.setOutEpicenter(impl, sharedElementTransition, exitTransition, outSharedElements, outIsPop, outTransaction);
            if (enterTransition != null) {
                impl.setEpicenter(enterTransition, inEpicenter);
            }
        } else {
            inEpicenter = null;
        }
        final Object finalSharedElementTransition = sharedElementTransition;
        OneShotPreDrawListener.add((View)sceneRoot, new Runnable(){

            @Override
            public void run() {
                ArrayMap<String, View> inSharedElements = FragmentTransition.captureInSharedElements(impl, (ArrayMap<String, String>)nameOverrides, finalSharedElementTransition, fragments);
                if (inSharedElements != null) {
                    sharedElementsIn.addAll(inSharedElements.values());
                    sharedElementsIn.add(nonExistentView);
                }
                FragmentTransition.callSharedElementStartEnd(inFragment, outFragment, inIsPop, inSharedElements, false);
                if (finalSharedElementTransition != null) {
                    impl.swapSharedElementTargets(finalSharedElementTransition, sharedElementsOut, sharedElementsIn);
                    View inEpicenterView = FragmentTransition.getInEpicenterView(inSharedElements, fragments, enterTransition, inIsPop);
                    if (inEpicenterView != null) {
                        impl.getBoundsOnScreen(inEpicenterView, inEpicenter);
                    }
                }
            }
        });
        return sharedElementTransition;
    }

    private static ArrayMap<String, View> captureOutSharedElements(FragmentTransitionImpl impl, ArrayMap<String, String> nameOverrides, Object sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList names;
        SharedElementCallback sharedElementCallback;
        if (nameOverrides.isEmpty() || sharedElementTransition == null) {
            nameOverrides.clear();
            return null;
        }
        Fragment outFragment = fragments.firstOut;
        ArrayMap outSharedElements = new ArrayMap();
        impl.findNamedViews((Map<String, View>)outSharedElements, outFragment.requireView());
        BackStackRecord outTransaction = fragments.firstOutTransaction;
        if (fragments.firstOutIsPop) {
            sharedElementCallback = outFragment.getEnterTransitionCallback();
            names = outTransaction.mSharedElementTargetNames;
        } else {
            sharedElementCallback = outFragment.getExitTransitionCallback();
            names = outTransaction.mSharedElementSourceNames;
        }
        if (names != null) {
            outSharedElements.retainAll((Collection)names);
        }
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, (Map<String, View>)outSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = (String)names.get(i);
                View view = (View)outSharedElements.get((Object)name);
                if (view == null) {
                    nameOverrides.remove((Object)name);
                    continue;
                }
                if (name.equals(ViewCompat.getTransitionName(view))) continue;
                String targetValue = (String)nameOverrides.remove((Object)name);
                nameOverrides.put((Object)ViewCompat.getTransitionName(view), (Object)targetValue);
            }
        } else {
            nameOverrides.retainAll((Collection)outSharedElements.keySet());
        }
        return outSharedElements;
    }

    static ArrayMap<String, View> captureInSharedElements(FragmentTransitionImpl impl, ArrayMap<String, String> nameOverrides, Object sharedElementTransition, FragmentContainerTransition fragments) {
        ArrayList names;
        SharedElementCallback sharedElementCallback;
        Fragment inFragment = fragments.lastIn;
        View fragmentView = inFragment.getView();
        if (nameOverrides.isEmpty() || sharedElementTransition == null || fragmentView == null) {
            nameOverrides.clear();
            return null;
        }
        ArrayMap inSharedElements = new ArrayMap();
        impl.findNamedViews((Map<String, View>)inSharedElements, fragmentView);
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (fragments.lastInIsPop) {
            sharedElementCallback = inFragment.getExitTransitionCallback();
            names = inTransaction.mSharedElementSourceNames;
        } else {
            sharedElementCallback = inFragment.getEnterTransitionCallback();
            names = inTransaction.mSharedElementTargetNames;
        }
        if (names != null) {
            inSharedElements.retainAll((Collection)names);
            inSharedElements.retainAll(nameOverrides.values());
        }
        if (sharedElementCallback != null) {
            sharedElementCallback.onMapSharedElements(names, (Map<String, View>)inSharedElements);
            for (int i = names.size() - 1; i >= 0; --i) {
                String key;
                String name = (String)names.get(i);
                View view = (View)inSharedElements.get((Object)name);
                if (view == null) {
                    key = FragmentTransition.findKeyForValue(nameOverrides, name);
                    if (key == null) continue;
                    nameOverrides.remove((Object)key);
                    continue;
                }
                if (name.equals(ViewCompat.getTransitionName(view)) || (key = FragmentTransition.findKeyForValue(nameOverrides, name)) == null) continue;
                nameOverrides.put((Object)key, (Object)ViewCompat.getTransitionName(view));
            }
        } else {
            FragmentTransition.retainValues(nameOverrides, (ArrayMap<String, View>)inSharedElements);
        }
        return inSharedElements;
    }

    static String findKeyForValue(ArrayMap<String, String> map, String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return (String)map.keyAt(i);
        }
        return null;
    }

    static View getInEpicenterView(ArrayMap<String, View> inSharedElements, FragmentContainerTransition fragments, Object enterTransition, boolean inIsPop) {
        BackStackRecord inTransaction = fragments.lastInTransaction;
        if (enterTransition != null && inSharedElements != null && inTransaction.mSharedElementSourceNames != null && !inTransaction.mSharedElementSourceNames.isEmpty()) {
            String targetName = inIsPop ? (String)inTransaction.mSharedElementSourceNames.get(0) : (String)inTransaction.mSharedElementTargetNames.get(0);
            return (View)inSharedElements.get((Object)targetName);
        }
        return null;
    }

    private static void setOutEpicenter(FragmentTransitionImpl impl, Object sharedElementTransition, Object exitTransition, ArrayMap<String, View> outSharedElements, boolean outIsPop, BackStackRecord outTransaction) {
        if (outTransaction.mSharedElementSourceNames != null && !outTransaction.mSharedElementSourceNames.isEmpty()) {
            String sourceName = outIsPop ? (String)outTransaction.mSharedElementTargetNames.get(0) : (String)outTransaction.mSharedElementSourceNames.get(0);
            View outEpicenterView = (View)outSharedElements.get((Object)sourceName);
            impl.setEpicenter(sharedElementTransition, outEpicenterView);
            if (exitTransition != null) {
                impl.setEpicenter(exitTransition, outEpicenterView);
            }
        }
    }

    static void retainValues(@NonNull ArrayMap<String, String> nameOverrides, @NonNull ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = (String)nameOverrides.valueAt(i);
            if (namedViews.containsKey((Object)targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    static void callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<View> views = new ArrayList<View>();
            ArrayList<String> names = new ArrayList<String>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add((String)sharedElements.keyAt(i));
                views.add((View)sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    static ArrayList<View> configureEnteringExitingViews(FragmentTransitionImpl impl, Object transition, Fragment fragment, ArrayList<View> sharedElements, View nonExistentView) {
        ArrayList<View> viewList = null;
        if (transition != null) {
            viewList = new ArrayList<View>();
            View root = fragment.getView();
            if (root != null) {
                impl.captureTransitioningViews(viewList, root);
            }
            if (sharedElements != null) {
                viewList.removeAll(sharedElements);
            }
            if (!viewList.isEmpty()) {
                viewList.add(nonExistentView);
                impl.addTargets(transition, viewList);
            }
        }
        return viewList;
    }

    static void setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    private static Object mergeTransitions(FragmentTransitionImpl impl, Object enterTransition, Object exitTransition, Object sharedElementTransition, Fragment inFragment, boolean isPop) {
        boolean overlap = true;
        if (enterTransition != null && exitTransition != null && inFragment != null) {
            overlap = isPop ? inFragment.getAllowReturnTransitionOverlap() : inFragment.getAllowEnterTransitionOverlap();
        }
        Object transition = overlap ? impl.mergeTransitionsTogether(exitTransition, enterTransition, sharedElementTransition) : impl.mergeTransitionsInSequence(exitTransition, enterTransition, sharedElementTransition);
        return transition;
    }

    public static void calculateFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        int numOps = transaction.mOps.size();
        for (int opNum = 0; opNum < numOps; ++opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, false, isReordered);
        }
    }

    public static void calculatePopFragments(BackStackRecord transaction, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isReordered) {
        if (!transaction.mManager.getContainer().onHasView()) {
            return;
        }
        int numOps = transaction.mOps.size();
        for (int opNum = numOps - 1; opNum >= 0; --opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)transaction.mOps.get(opNum);
            FragmentTransition.addToFirstInLastOut(transaction, op, transitioningFragments, true, isReordered);
        }
    }

    static boolean supportsTransition() {
        return PLATFORM_IMPL != null || SUPPORT_IMPL != null;
    }

    private static void addToFirstInLastOut(BackStackRecord transaction, FragmentTransaction.Op op, SparseArray<FragmentContainerTransition> transitioningFragments, boolean isPop, boolean isReorderedTransaction) {
        Fragment fragment = op.mFragment;
        if (fragment == null) {
            return;
        }
        int containerId = fragment.mContainerId;
        if (containerId == 0) {
            return;
        }
        int command = isPop ? INVERSE_OPS[op.mCmd] : op.mCmd;
        boolean setLastIn = false;
        boolean wasRemoved = false;
        boolean setFirstOut = false;
        boolean wasAdded = false;
        switch (command) {
            case 5: {
                setLastIn = isReorderedTransaction ? fragment.mHiddenChanged && !fragment.mHidden && fragment.mAdded : fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 1: 
            case 7: {
                setLastIn = isReorderedTransaction ? fragment.mIsNewlyAdded : !fragment.mAdded && !fragment.mHidden;
                wasAdded = true;
                break;
            }
            case 4: {
                setFirstOut = isReorderedTransaction ? fragment.mHiddenChanged && fragment.mAdded && fragment.mHidden : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
                break;
            }
            case 3: 
            case 6: {
                setFirstOut = isReorderedTransaction ? !fragment.mAdded && fragment.mView != null && fragment.mView.getVisibility() == 0 && fragment.mPostponedAlpha >= 0.0f : fragment.mAdded && !fragment.mHidden;
                wasRemoved = true;
            }
        }
        FragmentContainerTransition containerTransition = (FragmentContainerTransition)transitioningFragments.get(containerId);
        if (setLastIn) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.lastIn = fragment;
            containerTransition.lastInIsPop = isPop;
            containerTransition.lastInTransaction = transaction;
        }
        if (!isReorderedTransaction && wasAdded) {
            if (containerTransition != null && containerTransition.firstOut == fragment) {
                containerTransition.firstOut = null;
            }
            if (!transaction.mReorderingAllowed) {
                FragmentManager manager = transaction.mManager;
                FragmentStateManager fragmentStateManager = manager.createOrGetFragmentStateManager(fragment);
                manager.getFragmentStore().makeActive(fragmentStateManager);
                manager.moveToState(fragment);
            }
        }
        if (setFirstOut && (containerTransition == null || containerTransition.firstOut == null)) {
            containerTransition = FragmentTransition.ensureContainer(containerTransition, transitioningFragments, containerId);
            containerTransition.firstOut = fragment;
            containerTransition.firstOutIsPop = isPop;
            containerTransition.firstOutTransaction = transaction;
        }
        if (!isReorderedTransaction && wasRemoved && containerTransition != null && containerTransition.lastIn == fragment) {
            containerTransition.lastIn = null;
        }
    }

    private static FragmentContainerTransition ensureContainer(FragmentContainerTransition containerTransition, SparseArray<FragmentContainerTransition> transitioningFragments, int containerId) {
        if (containerTransition == null) {
            containerTransition = new FragmentContainerTransition();
            transitioningFragments.put(containerId, (Object)containerTransition);
        }
        return containerTransition;
    }

    private FragmentTransition() {
    }

    static class FragmentContainerTransition {
        public Fragment lastIn;
        public boolean lastInIsPop;
        public BackStackRecord lastInTransaction;
        public Fragment firstOut;
        public boolean firstOutIsPop;
        public BackStackRecord firstOutTransaction;

        FragmentContainerTransition() {
        }
    }

    static interface Callback {
        public void onStart(@NonNull Fragment var1, @NonNull CancellationSignal var2);

        public void onComplete(@NonNull Fragment var1, @NonNull CancellationSignal var2);
    }
}

