/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.os.Build;
import androidx.annotation.NonNull;
import java.util.ArrayList;

class AnimatorUtils {
    static void addPauseListener(@NonNull Animator animator2, @NonNull AnimatorListenerAdapter listener) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator2.addPauseListener((Animator.AnimatorPauseListener)listener);
        }
    }

    static void pause(@NonNull Animator animator2) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator2.pause();
        } else {
            ArrayList listeners = animator2.getListeners();
            if (listeners != null) {
                int size = listeners.size();
                for (int i = 0; i < size; ++i) {
                    Animator.AnimatorListener listener = (Animator.AnimatorListener)listeners.get(i);
                    if (!(listener instanceof AnimatorPauseListenerCompat)) continue;
                    ((AnimatorPauseListenerCompat)listener).onAnimationPause(animator2);
                }
            }
        }
    }

    static void resume(@NonNull Animator animator2) {
        if (Build.VERSION.SDK_INT >= 19) {
            animator2.resume();
        } else {
            ArrayList listeners = animator2.getListeners();
            if (listeners != null) {
                int size = listeners.size();
                for (int i = 0; i < size; ++i) {
                    Animator.AnimatorListener listener = (Animator.AnimatorListener)listeners.get(i);
                    if (!(listener instanceof AnimatorPauseListenerCompat)) continue;
                    ((AnimatorPauseListenerCompat)listener).onAnimationResume(animator2);
                }
            }
        }
    }

    private AnimatorUtils() {
    }

    static interface AnimatorPauseListenerCompat {
        public void onAnimationPause(Animator var1);

        public void onAnimationResume(Animator var1);
    }
}

