/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.content.Context;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.Map;
import java.util.TreeMap;
import org.homunculus.android.component.Str;
import org.homunculus.android.core.AndroidScopeContext;
import org.homunculusframework.factory.scope.Scope;

public class ActionModeBuilder {
    private ActionMode mActionMode;
    private Integer mActionMenuId;
    private View mCustomView;
    private Str mTitle;
    private Str mSubtitle;
    private Map<Integer, ActionListener> mActions = new TreeMap<Integer, ActionListener>();
    private DestroyListener mDestroyListener;

    private ActionModeBuilder() {
    }

    public static ActionModeBuilder define() {
        return new ActionModeBuilder();
    }

    public ActionModeBuilder setTitle(Str title) {
        this.mTitle = title;
        return this;
    }

    public ActionModeBuilder setSubtitle(Str subtitle) {
        this.mSubtitle = subtitle;
        return this;
    }

    public ActionModeBuilder setOnDestroyListener(DestroyListener destroyListener) {
        this.mDestroyListener = destroyListener;
        return this;
    }

    public ActionModeBuilder setCustomView(View customView) {
        this.mCustomView = customView;
        return this;
    }

    public ActionModeBuilder addAction(int actionId, ActionListener listener) {
        this.mActions.put(actionId, listener);
        return this;
    }

    public ActionModeBuilder setActionMenuId(Integer actionMenuId) {
        this.mActionMenuId = actionMenuId;
        return this;
    }

    public ActionModeBuilder setActionMenu(Integer actionMenuId, Map<Integer, ActionListener> actions) {
        this.mActionMenuId = actionMenuId;
        if (actions != null) {
            this.mActions.putAll(actions);
        }
        return this;
    }

    public ActionMode create(View view) {
        return this.create(AndroidScopeContext.getScope(view.getContext()), view);
    }

    public ActionMode create(@Nullable Scope scope, View view) {
        Context context = view.getContext();
        if (scope != null) {
            scope.addDestroyCallback(s -> {
                if (this.mActionMode != null) {
                    this.mActionMode.finish();
                }
            });
        }
        final String title = this.mTitle != null ? this.mTitle.getString(context) : null;
        final String subtitle = this.mSubtitle != null ? this.mSubtitle.getString(context) : null;
        this.mActionMode = view.startActionMode(new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
                MenuInflater inflater = mode.getMenuInflater();
                if (ActionModeBuilder.this.mActionMenuId != null) {
                    inflater.inflate(ActionModeBuilder.this.mActionMenuId.intValue(), menu2);
                }
                if (ActionModeBuilder.this.mCustomView != null) {
                    mode.setCustomView(ActionModeBuilder.this.mCustomView);
                } else {
                    if (title != null) {
                        mode.setTitle((CharSequence)title);
                    }
                    if (subtitle != null) {
                        mode.setSubtitle((CharSequence)subtitle);
                    }
                }
                return true;
            }

            public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
                return false;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                ActionListener listener = (ActionListener)ActionModeBuilder.this.mActions.get(item.getItemId());
                if (listener != null) {
                    return listener.onActionItemClicked(mode, item);
                }
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
                if (ActionModeBuilder.this.mDestroyListener != null) {
                    ActionModeBuilder.this.mDestroyListener.onDestroyActionMode(mode);
                    ActionModeBuilder.this.mDestroyListener = null;
                }
                ActionModeBuilder.this.mActions.clear();
                ActionModeBuilder.this.mActionMode = null;
            }
        });
        return this.mActionMode;
    }

    public static interface DestroyListener {
        public void onDestroyActionMode(ActionMode var1);
    }

    public static interface ActionListener {
        public boolean onActionItemClicked(ActionMode var1, MenuItem var2);
    }
}

