/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.Nullable;
import org.homunculus.android.component.R;
import org.homunculus.android.flavor.AndroidMainHandler;
import org.homunculusframework.concurrent.Task;
import org.homunculusframework.lang.Function;
import org.homunculusframework.lang.Panic;

public class Debounce {
    private Debounce() {
        throw new Panic();
    }

    public static void clickOnce(View where, @Nullable View.OnClickListener what) {
        Object tmp = where.getTag(R.id.debounce_view_adapter);
        if (!(tmp instanceof DebounceAdapterOnce)) {
            DebounceAdapterOnce adapter = new DebounceAdapterOnce(where, what);
            where.setTag(R.id.debounce_view_adapter, (Object)adapter);
            where.setOnClickListener((View.OnClickListener)adapter);
            where.setEnabled(true);
        }
    }

    public static void click(View where, Function<View, Task<?>> taskFactory) {
        Object tmp = where.getTag(R.id.debounce_view_adapter);
        if (!(tmp instanceof DebounceAdapter)) {
            DebounceAdapter adapter = new DebounceAdapter(where, taskFactory);
            where.setTag(R.id.debounce_view_adapter, (Object)adapter);
            where.setOnClickListener((View.OnClickListener)adapter);
        }
    }

    public static void clearClick(View where) {
        where.setTag(R.id.debounce_view_adapter, null);
        where.setOnClickListener(null);
        where.setEnabled(true);
    }

    private static class DebounceAdapterOnce
    implements View.OnClickListener {
        private final View.OnClickListener delegate;
        private boolean hasRun;
        private final View view;

        private DebounceAdapterOnce(View view, @Nullable View.OnClickListener delegate) {
            this.delegate = delegate;
            this.view = view;
        }

        public void onClick(View v) {
            if (this.delegate != null && !this.hasRun) {
                this.view.setEnabled(false);
                this.hasRun = true;
                this.delegate.onClick(v);
            }
        }
    }

    private static class DebounceAdapter
    implements View.OnClickListener {
        private final Function<View, Task<?>> taskFactory;
        private final View view;
        private final Handler handler;

        public DebounceAdapter(View view, Function<View, Task<?>> taskFactory) {
            this.taskFactory = taskFactory;
            this.view = view;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public void onClick(View v) {
            Task task = (Task)this.taskFactory.apply((Object)v);
            this.view.setEnabled(false);
            task.whenDone(res -> {
                if (AndroidMainHandler.isMainThread()) {
                    this.view.setEnabled(true);
                } else {
                    this.handler.post(() -> this.view.setEnabled(true));
                }
            });
        }
    }
}

