/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.Map;
import java.util.WeakHashMap;
import org.homunculus.android.core.AndroidScopeContext;

public class Display {
    public static final String NAME_DISPLAY = "$display";
    private static final Map<Context, Display> sDisplays = new WeakHashMap<Context, Display>();
    private final DisplayMetrics mMetrics;

    protected Display(Context context) {
        this.mMetrics = context.getResources().getDisplayMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display from(Context context) {
        Display display = AndroidScopeContext.resolve(context, Display.class);
        if (display != null) {
            return display;
        }
        Map<Context, Display> map = sDisplays;
        synchronized (map) {
            Display dp = sDisplays.get(context);
            if (dp == null) {
                dp = new Display(context);
                sDisplays.put(context, dp);
            }
            return dp;
        }
    }

    public int dipToPix(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mMetrics);
    }

    public int pixToDip(int px) {
        return (int)((float)px / this.mMetrics.density);
    }

    public int getWidth() {
        return this.mMetrics.widthPixels;
    }

    public int getHeight() {
        return this.mMetrics.heightPixels;
    }
}

