/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.homunculus.android.core.ActivityCallback;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculusframework.concurrent.Task;
import org.homunculusframework.factory.scope.LifecycleOwner;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Destroyable;
import org.homunculusframework.lang.Result;
import org.homunculusframework.scope.SettableTask;

public class Permissions
implements Destroyable {
    public static final String TAG_PERMISSION_DENIED = "permission.denied";
    private final Scope mScope;
    private final ActivityEventDispatcher mEventDispatcher;
    private final ActivityEventDispatcher.ActivityEventCallback mCallback;
    private final List<RequestHolder> mFeatureRequests;

    public Permissions(Scope scope, ActivityEventDispatcher<?> eventDispatcher) {
        this.mScope = scope;
        this.mEventDispatcher = eventDispatcher;
        this.mFeatureRequests = new ArrayList<RequestHolder>();
        this.mCallback = new ActivityEventDispatcher.AbsActivityEventCallback(){

            @Override
            public void onActivityRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults) {
                for (RequestHolder holder : Permissions.this.mFeatureRequests) {
                    if (requestCode != holder.id) continue;
                    for (int i = 0; i < permissions.length; ++i) {
                        String permission2 = permissions[i];
                        int grantResult = grantResults[i];
                        holder.updateResponse(permission2, grantResult);
                    }
                    holder.task.set(Arrays.asList(holder.responses));
                    Permissions.this.mFeatureRequests.remove(holder);
                    return;
                }
            }
        };
        new ActivityCallback((LifecycleOwner)scope, eventDispatcher).setDelegate(this.mCallback);
    }

    public Task<List<PermissionResponse>> handlePermissions(String ... permissions) {
        RequestHolder holder = new RequestHolder(this.mScope, permissions);
        this.mFeatureRequests.add(holder);
        ArrayList<String> missingPermissions = new ArrayList<String>();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            int state = ContextCompat.checkSelfPermission((Context)this.getActivity(), permission2);
            holder.responses[i] = new PermissionResponse(permission2, state);
            if (!holder.responses[i].isDenied()) continue;
            missingPermissions.add(permission2);
        }
        if (missingPermissions.isEmpty()) {
            holder.task.set(Arrays.asList(holder.responses));
        } else {
            ActivityCompat.requestPermissions(this.getActivity(), missingPermissions.toArray(new String[missingPermissions.size()]), holder.id);
        }
        return holder.task;
    }

    public Task<PermissionResponse> handlePermission(String permission2) {
        SettableTask response = SettableTask.create((Scope)this.mScope, (String)("handlePermission-" + permission2));
        this.handlePermissions(permission2).whenDone(res -> response.set((Object)((PermissionResponse)res.get(0))));
        return response;
    }

    public static boolean allGranted(List<PermissionResponse> responses) {
        int grants = 0;
        for (PermissionResponse r : responses) {
            if (!r.isGranted()) continue;
            ++grants;
        }
        return responses.size() == grants;
    }

    public Activity getActivity() {
        return this.mEventDispatcher.getActivity();
    }

    public void destroy() {
        this.mEventDispatcher.unregister(this.mCallback);
    }

    private class RequestHolder {
        final String[] requestedPermissions;
        final SettableTask<List<PermissionResponse>> task;
        final int id = ActivityEventDispatcher.generateNextRequestId();
        final PermissionResponse[] responses;

        RequestHolder(Scope scope, String ... permissions2) {
            this.requestedPermissions = permissions2;
            this.task = SettableTask.create((Scope)scope, (String)("handlePermissions-" + Arrays.toString(permissions2)));
            this.responses = new PermissionResponse[permissions2.length];
        }

        void updateResponse(String permission2, int grant) {
            for (int i = 0; i < this.responses.length; ++i) {
                if (this.responses[i] == null || !this.responses[i].permission.equals(permission2)) continue;
                this.responses[i] = new PermissionResponse(permission2, grant);
            }
        }
    }

    public static final class PermissionResponse {
        private final String permission;
        private final int result;

        PermissionResponse(String permission2, int result) {
            this.permission = permission2;
            this.result = result;
        }

        public String getPermission() {
            return this.permission;
        }

        public boolean isGranted() {
            return this.result == 0;
        }

        public boolean isDenied() {
            return this.result == -1;
        }

        public int getResult() {
            return this.result;
        }

        public Result<String> asResult() {
            if (this.isGranted()) {
                return Result.create((Object)this.permission);
            }
            Result res = Result.create();
            res.put(Permissions.TAG_PERMISSION_DENIED);
            res.put("permission", (Object)this.permission);
            res.put("flag", (Object)this.result);
            return res;
        }
    }
}

