/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.toolbarbuilder;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import java.util.Map;
import java.util.TreeMap;
import org.homunculus.android.compat.EventAppCompatActivity;
import org.homunculus.android.component.Str;
import org.homunculus.android.component.module.toolbarbuilder.ContentViewHolder;
import org.homunculus.android.component.module.toolbarbuilder.ToolbarCreator;
import org.homunculus.android.component.module.toolbarbuilder.ToolbarHolder;
import org.homunculusframework.factory.scope.Scope;

public abstract class ToolbarConfiguration {
    private EventAppCompatActivity mAppCompatActivity;
    private Scope mScope;
    View mCustomView;
    Integer mToolbarColor;
    Integer mTitleTextColor;
    Drawable mBackgroundDrawable;
    Str mTitleRes;
    Integer mMenuId;
    boolean mShowNavigationIcons = true;
    Context mToolbarTitleTextAppearanceContext;
    Integer mToolbarTitleTextAppearance;
    Context mToolbarSubTitleTextAppearanceContext;
    Integer mToolbarSubTitleTextAppearance;
    Drawable mToolbarLogoAsDrawable;
    Integer mToolbarLogoAsResource;
    Runnable mUpAction;
    Map<Integer, MenuItemClickListener> mItems = new TreeMap<Integer, MenuItemClickListener>();
    ToolbarContentConfiguratorListener mToolbarContentConfiguratorListener;
    Float mElevation;

    private ToolbarConfiguration() {
    }

    public ToolbarConfiguration(EventAppCompatActivity activity, Scope scope) {
        this.mAppCompatActivity = activity;
        this.mScope = scope;
        this.configure();
    }

    Scope getScope() {
        return this.mScope;
    }

    protected abstract void configure();

    public <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> createToolbar(ContentView contentView) {
        return new ToolbarCreator(this).create(this.mScope, this.mAppCompatActivity, contentView);
    }

    public <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> createToolbar(ContentView contentView, @Nullable LeftDrawer leftDrawer) {
        return new ToolbarCreator(this).create(this.mScope, this.mAppCompatActivity, contentView, leftDrawer);
    }

    public <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> createToolbar(ContentView contentView, @Nullable LeftDrawer leftDrawer, @Nullable RightDrawer rightDrawer) {
        return new ToolbarCreator(this).create(this.mScope, this.mAppCompatActivity, contentView, leftDrawer, rightDrawer);
    }

    public ToolbarConfiguration setTitleTextAppearance(Context context, @StyleRes int resId) {
        this.mToolbarTitleTextAppearanceContext = this.mToolbarTitleTextAppearanceContext;
        this.mToolbarTitleTextAppearance = this.mToolbarTitleTextAppearance;
        return this;
    }

    public ToolbarConfiguration setSubTitleTextAppearance(Context context, @StyleRes int resId) {
        this.mToolbarSubTitleTextAppearanceContext = this.mToolbarSubTitleTextAppearanceContext;
        this.mToolbarSubTitleTextAppearance = this.mToolbarSubTitleTextAppearance;
        return this;
    }

    public ToolbarConfiguration setLogo(Drawable drawable2) {
        this.mToolbarLogoAsDrawable = drawable2;
        this.mToolbarLogoAsResource = null;
        return this;
    }

    public ToolbarConfiguration setLogo(@DrawableRes int drawable2) {
        this.mToolbarLogoAsDrawable = null;
        this.mToolbarLogoAsResource = drawable2;
        return this;
    }

    public ToolbarConfiguration setToolbarColor(@ColorRes Integer toolbarColor) {
        this.mToolbarColor = toolbarColor;
        return this;
    }

    public ToolbarConfiguration setTitleTextColor(@ColorRes Integer textColor) {
        this.mTitleTextColor = textColor;
        return this;
    }

    public ToolbarConfiguration setTitle(Str textRes) {
        this.mTitleRes = textRes;
        return this;
    }

    public ToolbarConfiguration setBackgroundDrawable(Drawable backgroundDrawable) {
        this.mBackgroundDrawable = backgroundDrawable;
        return this;
    }

    public ToolbarConfiguration setCustomView(View customView) {
        this.mCustomView = customView;
        return this;
    }

    public ToolbarConfiguration setShowNavigationIcons(boolean showNavigationIcons) {
        this.mShowNavigationIcons = showNavigationIcons;
        return this;
    }

    public ToolbarConfiguration setMenuId(Integer menuId) {
        this.mMenuId = menuId;
        return this;
    }

    public ToolbarConfiguration setUpAction(Runnable upAction) {
        this.mUpAction = upAction;
        return this;
    }

    public ToolbarConfiguration addMenuItemListener(Integer id2, MenuItemClickListener clickListener) {
        this.mItems.put(id2, clickListener);
        return this;
    }

    public ToolbarConfiguration setMenu(Integer menuId, Map<Integer, MenuItemClickListener> clicklistener) {
        this.mMenuId = menuId;
        this.mItems.putAll(clicklistener);
        return this;
    }

    public MenuConfiguration setMenu(Integer menuId) {
        return new MenuConfiguration(menuId);
    }

    public ToolbarConfiguration setElevation(float elevation) {
        this.mElevation = Float.valueOf(elevation);
        return this;
    }

    public ToolbarConfiguration setToolbarContentConfiguratorListener(ToolbarContentConfiguratorListener toolbarContentConfiguratorListener) {
        this.mToolbarContentConfiguratorListener = toolbarContentConfiguratorListener;
        return this;
    }

    public class MenuConfiguration {
        private final Map<Integer, MenuItemClickListener> clicklistener = new TreeMap<Integer, MenuItemClickListener>();
        private final int menuId;

        private MenuConfiguration(int menuId) {
            this.menuId = menuId;
            ToolbarConfiguration.this.mMenuId = menuId;
            ToolbarConfiguration.this.mItems = this.clicklistener;
        }

        public MenuConfiguration onItemClick(int item, MenuItemClickListener listener) {
            this.clicklistener.put(item, listener);
            return this;
        }

        public ToolbarConfiguration apply() {
            ToolbarConfiguration.this.setMenu(this.menuId, this.clicklistener);
            return ToolbarConfiguration.this;
        }
    }

    public static interface ToolbarContentConfiguratorListener {
        public void onMenuCreated(Menu var1);
    }

    public static interface MenuItemClickListener {
        public boolean onMenuItemSelected(MenuItem var1);
    }
}

