/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.toolbarbuilder;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import java.util.concurrent.atomic.AtomicInteger;
import org.homunculus.android.compat.EventAppCompatActivity;
import org.homunculus.android.component.InputManager;
import org.homunculus.android.component.R;
import org.homunculus.android.component.Widget;
import org.homunculus.android.component.module.toolbarbuilder.ContentViewHolder;
import org.homunculus.android.component.module.toolbarbuilder.ToolbarConfiguration;
import org.homunculus.android.component.module.toolbarbuilder.ToolbarHolder;
import org.homunculus.android.core.ActivityCallback;
import org.homunculus.android.core.ActivityEventDispatcher;
import org.homunculus.android.core.AndroidScopeContext;
import org.homunculusframework.factory.scope.LifecycleOwner;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Panic;
import org.homunculusframework.scope.LifecycleEntry;
import org.slf4j.LoggerFactory;

class ToolbarCreator {
    private int generationId;
    private static final String NGID = "toolbarBuilderGenerationId";
    private AtomicInteger nextGeneratedId;
    private ContentViewHolder mDrawerLayout;
    private ToolbarConfiguration mToolbarConfiguration;

    ToolbarCreator(ToolbarConfiguration template) {
        this.mToolbarConfiguration = template;
    }

    <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> create(@Nullable Scope scope, EventAppCompatActivity activity, ContentView contentView) {
        return this.create(scope, activity, contentView, null, null);
    }

    <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> create(@Nullable Scope scope, EventAppCompatActivity activity, ContentView contentView, @Nullable LeftDrawer leftDrawer) {
        return this.create(scope, activity, contentView, leftDrawer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> create(@Nullable Scope scope, EventAppCompatActivity activity, ContentView contentView, @Nullable LeftDrawer leftDrawer, @Nullable RightDrawer rightDrawer) {
        Class<ToolbarCreator> clazz = ToolbarCreator.class;
        synchronized (ToolbarCreator.class) {
            Scope activityScope = AndroidScopeContext.getScope((Context)activity);
            if (activityScope == null) {
                this.nextGeneratedId = new AtomicInteger();
            } else {
                LifecycleEntry ctr = LifecycleEntry.get((LifecycleOwner)activityScope, (String)NGID, AtomicInteger.class);
                if (ctr.get() == null) {
                    ctr.set((Object)new AtomicInteger());
                }
                this.nextGeneratedId = (AtomicInteger)ctr.get();
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            this.generationId = this.nextGeneratedId.incrementAndGet();
            if (scope != null) {
                scope.addDestroyCallback(obj -> {
                    this.mToolbarConfiguration.mItems.clear();
                    this.mToolbarConfiguration.mItems = null;
                });
            }
            this.initMenu(scope, activity, activity.getEventDispatcher());
            ToolbarHolder<ContentView> toolbar = this.initToolbar(scope, activity, contentView);
            return this.initDrawerLayout(activity, toolbar, leftDrawer, rightDrawer);
        }
    }

    private boolean isInvalidMenu() {
        return this.generationId != this.nextGeneratedId.get();
    }

    private void logInvalidMenu() {
        LoggerFactory.getLogger(this.getClass()).warn("Toolbar is already invalid");
    }

    private void initMenu(Scope scope, final AppCompatActivity activity, ActivityEventDispatcher dispatcher) {
        ActivityCallback<Activity> callback = new ActivityCallback<Activity>((LifecycleOwner)scope, dispatcher);
        callback.setDelegate(new ActivityEventDispatcher.AbsActivityEventCallback<Activity>(){

            @Override
            public void onActionModeStarted(ActionMode mode) {
                if (ToolbarCreator.this.isInvalidMenu()) {
                    ToolbarCreator.this.logInvalidMenu();
                    return;
                }
                super.onActionModeStarted(mode);
                if (ToolbarCreator.this.mDrawerLayout != null) {
                    ToolbarCreator.this.mDrawerLayout.setDrawerLockMode(1);
                }
            }

            @Override
            public void onActionModeFinished(ActionMode mode) {
                if (ToolbarCreator.this.isInvalidMenu()) {
                    ToolbarCreator.this.logInvalidMenu();
                    return;
                }
                super.onActionModeFinished(mode);
                if (ToolbarCreator.this.mDrawerLayout != null) {
                    ToolbarCreator.this.mDrawerLayout.setDrawerLockMode(0);
                }
            }

            @Override
            public boolean onActivityCreateOptionsMenu(Activity activity2, Menu menu2) {
                if (ToolbarCreator.this.isInvalidMenu()) {
                    ToolbarCreator.this.logInvalidMenu();
                    return false;
                }
                return this.invalidateOptionsMenu(menu2);
            }

            @Override
            public boolean onActivityPrepareOptionsMenu(Activity activity2, Menu menu2) {
                if (ToolbarCreator.this.isInvalidMenu()) {
                    ToolbarCreator.this.logInvalidMenu();
                    return false;
                }
                return this.invalidateOptionsMenu(menu2);
            }

            private boolean invalidateOptionsMenu(Menu menu2) {
                menu2.clear();
                if (((ToolbarCreator)ToolbarCreator.this).mToolbarConfiguration.mMenuId != null) {
                    activity.getMenuInflater().inflate(((ToolbarCreator)ToolbarCreator.this).mToolbarConfiguration.mMenuId.intValue(), menu2);
                }
                if (((ToolbarCreator)ToolbarCreator.this).mToolbarConfiguration.mToolbarContentConfiguratorListener != null) {
                    ((ToolbarCreator)ToolbarCreator.this).mToolbarConfiguration.mToolbarContentConfiguratorListener.onMenuCreated(menu2);
                }
                return true;
            }

            @Override
            public boolean onActivityOptionsItemSelected(Activity activity2, MenuItem item) {
                if (ToolbarCreator.this.isInvalidMenu()) {
                    ToolbarCreator.this.logInvalidMenu();
                    return false;
                }
                ToolbarConfiguration.MenuItemClickListener itemListener = ((ToolbarCreator)ToolbarCreator.this).mToolbarConfiguration.mItems.get(item.getItemId());
                if (itemListener != null) {
                    itemListener.onMenuItemSelected(item);
                }
                return super.onActivityOptionsItemSelected(activity2, item);
            }
        });
        activity.supportInvalidateOptionsMenu();
    }

    private <ContentView extends View> ToolbarHolder<ContentView> initToolbar(Scope scope, AppCompatActivity activity, ContentView contentView) {
        AppCompatActivity ctx;
        Toolbar toolbar = new Toolbar((Context)activity);
        int barSize = (int)activity.getResources().getDimension(R.dimen.toolbarbuilder_barheight);
        toolbar.setMinimumHeight(barSize);
        toolbar.setId(Widget.generateViewId());
        if (this.mToolbarConfiguration.mToolbarColor != null) {
            toolbar.setBackgroundColor(ContextCompat.getColor((Context)activity, this.mToolbarConfiguration.mToolbarColor));
        }
        if (this.mToolbarConfiguration.mTitleTextColor != null) {
            toolbar.setTitleTextColor(ContextCompat.getColor((Context)activity, this.mToolbarConfiguration.mTitleTextColor));
        }
        if (this.mToolbarConfiguration.mElevation != null && Build.VERSION.SDK_INT >= 21) {
            toolbar.setElevation(this.mToolbarConfiguration.mElevation.floatValue());
        }
        activity.setSupportActionBar(toolbar);
        ActionBar ab = activity.getSupportActionBar();
        if (ab == null) {
            throw new Panic("should not happen! actionBar was just set");
        }
        if (this.mToolbarConfiguration.mBackgroundDrawable != null) {
            ab.setBackgroundDrawable(this.mToolbarConfiguration.mBackgroundDrawable);
        }
        if (this.mToolbarConfiguration.mCustomView != null) {
            ab.setCustomView(this.mToolbarConfiguration.mCustomView);
        }
        if (this.mToolbarConfiguration.mTitleRes != null) {
            ab.setTitle(this.mToolbarConfiguration.mTitleRes.getString((Context)activity));
            ab.setDisplayShowTitleEnabled(true);
        } else {
            ab.setDisplayShowTitleEnabled(false);
        }
        ab.setDisplayHomeAsUpEnabled(this.mToolbarConfiguration.mShowNavigationIcons);
        ToolbarHolder<ContentView> holder = new ToolbarHolder<ContentView>((LifecycleOwner)scope, (Context)activity, contentView, toolbar);
        holder.setId(Widget.generateViewId());
        holder.addView((View)toolbar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, barSize, 0.0f));
        holder.addView(contentView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1, 1.0f));
        if (this.mToolbarConfiguration.mToolbarTitleTextAppearance != null) {
            ctx = this.mToolbarConfiguration.mToolbarTitleTextAppearanceContext != null ? this.mToolbarConfiguration.mToolbarTitleTextAppearanceContext : activity;
            toolbar.setTitleTextAppearance((Context)ctx, this.mToolbarConfiguration.mToolbarTitleTextAppearance);
        }
        if (this.mToolbarConfiguration.mToolbarSubTitleTextAppearance != null) {
            ctx = this.mToolbarConfiguration.mToolbarSubTitleTextAppearanceContext != null ? this.mToolbarConfiguration.mToolbarSubTitleTextAppearanceContext : activity;
            toolbar.setTitleTextAppearance((Context)ctx, this.mToolbarConfiguration.mToolbarSubTitleTextAppearance);
        }
        return holder;
    }

    private <ContentView extends View, LeftDrawer extends View, RightDrawer extends View> ContentViewHolder<ToolbarHolder<ContentView>, LeftDrawer, RightDrawer> initDrawerLayout(AppCompatActivity activity, ToolbarHolder<ContentView> contentLayout, LeftDrawer leftDrawer, RightDrawer rightDrawer) {
        DrawerLayout.LayoutParams params;
        ContentViewHolder drawerLayout;
        if (this.mToolbarConfiguration.mUpAction != null) {
            contentLayout.getToolbar().setNavigationOnClickListener(v -> this.mToolbarConfiguration.mUpAction.run());
        }
        this.mDrawerLayout = drawerLayout = new ContentViewHolder((Context)activity, contentLayout, leftDrawer, rightDrawer);
        if (leftDrawer != null) {
            params = new DrawerLayout.LayoutParams(-2, -1);
            params.gravity = 0x800003;
            drawerLayout.addView(leftDrawer, (ViewGroup.LayoutParams)params);
            contentLayout.getToolbar().setNavigationOnClickListener(v -> {
                if (drawerLayout.isDrawerOpen(leftDrawer)) {
                    drawerLayout.closeDrawer(leftDrawer);
                } else {
                    drawerLayout.openDrawer(leftDrawer);
                }
            });
        }
        if (rightDrawer != null) {
            params = new DrawerLayout.LayoutParams(-2, -1);
            params.gravity = 0x800005;
            drawerLayout.setOnTouchListener((v, event) -> {
                InputManager.hideSoftInput(activity);
                return false;
            });
            drawerLayout.addView(rightDrawer, (ViewGroup.LayoutParams)params);
        }
        if (leftDrawer != null || rightDrawer != null) {
            ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(activity, drawerLayout, R.string.toolbarbuilder_open_drawer_content_desc_res, R.string.toolbarbuilder_close_drawer_content_desc_res);
            if (leftDrawer != null) {
                toggle.setDrawerIndicatorEnabled(true);
            } else {
                toggle.setDrawerIndicatorEnabled(false);
            }
            toggle.syncState();
        }
        if (this.mToolbarConfiguration.mToolbarLogoAsResource != null) {
            contentLayout.getToolbar().setLogo(this.mToolbarConfiguration.mToolbarLogoAsResource);
        } else if (this.mToolbarConfiguration.mToolbarLogoAsDrawable != null) {
            contentLayout.getToolbar().setLogo(this.mToolbarConfiguration.mToolbarLogoAsDrawable);
        }
        return drawerLayout;
    }
}

