/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.component.module.validator.conversionAdapters;

import com.google.android.material.textfield.TextInputLayout;
import org.homunculus.android.component.module.validator.ViewErrorHandler;
import org.homunculus.android.component.module.validator.conversionAdapters.ConversionAdapter;
import org.homunculus.android.component.module.validator.viewErrorHandlers.TextInputLayoutViewErrorHandler;

public class StringToTextInputLayoutAdapter
implements ConversionAdapter<TextInputLayout, String> {
    @Override
    public void setFieldValueToView(String value, TextInputLayout view) {
        try {
            view.getEditText().setText((CharSequence)value);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot set text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public String getFieldValueFromView(TextInputLayout view) {
        try {
            return view.getEditText().getText().toString();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Cannot get text, because EditText in TextInputLayout is null!: " + view.getId(), e);
        }
    }

    @Override
    public ViewErrorHandler<TextInputLayout> getErrorHandler() {
        return new TextInputLayoutViewErrorHandler();
    }
}

