/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.android.core;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Bundle;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.homunculus.android.flavor.AndroidMainHandler;
import org.homunculusframework.factory.scope.EmptyScope;
import org.homunculusframework.factory.scope.Scope;

public class ActivityEventDispatcher<T extends Activity> {
    private static final AtomicInteger mRequestCode = new AtomicInteger();
    private final InternalEventDispatcher mDispatcher;
    private final T mActivity;
    private ActivityStatus mStatus;
    private Bundle mSavedInstanceStateAtOnCreate;
    private final Scope mBaseScope;
    private List<ActivityEventCallback<T>> callbacks = new ArrayList<ActivityEventCallback<T>>();
    private List<ActivityResult> mBufferedActivityResults;

    public ActivityEventDispatcher(Scope baseScope, T activity) {
        this.mStatus = ActivityStatus.Launching;
        this.mActivity = activity;
        this.mDispatcher = new InternalEventDispatcher();
        this.mBufferedActivityResults = new ArrayList<ActivityResult>();
        this.mBaseScope = baseScope == null ? new EmptyScope() : baseScope;
    }

    public List<ActivityResult> getBufferedActivityResults() {
        return this.mBufferedActivityResults;
    }

    @Nullable
    public ActivityResult consumeActivityResult(int requestCode) {
        for (int i = 0; i < this.mBufferedActivityResults.size(); ++i) {
            ActivityResult res = this.mBufferedActivityResults.get(i);
            if (res.getRequestCode() != requestCode) continue;
            this.mBufferedActivityResults.remove(i);
            return res;
        }
        return null;
    }

    public ActivityEventDispatcher(T activity) {
        this(null, activity);
    }

    public static int generateNextRequestId() {
        return mRequestCode.incrementAndGet();
    }

    public ActivityStatus getStatus() {
        return this.mStatus;
    }

    public T getActivity() {
        return this.mActivity;
    }

    public void register(ActivityEventCallback<T> callback) {
        switch (this.mStatus) {
            case Running: {
                callback.onBufferedCreate(this.mActivity, this.mSavedInstanceStateAtOnCreate);
                callback.onBufferedResume(this.mActivity);
                break;
            }
            case Pausing: 
            case Stopping: {
                callback.onBufferedCreate(this.mActivity, this.mSavedInstanceStateAtOnCreate);
                callback.onBufferedResume(this.mActivity);
                callback.onBufferedPause(this.mActivity);
                break;
            }
            case Destroying: 
            case Dead: {
                callback.onBufferedCreate(this.mActivity, this.mSavedInstanceStateAtOnCreate);
                callback.onBufferedResume(this.mActivity);
                callback.onBufferedPause(this.mActivity);
                callback.onBufferedDestroy(this.mActivity);
            }
        }
        this.callbacks.add(callback);
    }

    public void unregister(ActivityEventCallback<T> callback) {
        this.callbacks.remove(callback);
    }

    public ActivityEventCallback<T> getEventDispatcher() {
        return this.mDispatcher;
    }

    public void destroy() {
        this.getEventDispatcher().onActivityDestroy(this.mActivity);
    }

    private List<ActivityEventCallback<T>> getCallbacks() {
        return this.callbacks;
    }

    public static enum ActivityStatus {
        Launching,
        Creating,
        Starting,
        Running,
        Pausing,
        Stopping,
        Destroying,
        Dead;

    }

    private class InternalEventDispatcher
    extends AbsActivityEventCallback<T> {
        private InternalEventDispatcher() {
        }

        @Override
        public void onActionModeStarted(ActionMode mode) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActionModeStarted(mode);
            }
            super.onActionModeStarted(mode);
        }

        @Override
        public void onActionModeFinished(ActionMode mode) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActionModeFinished(mode);
            }
            super.onActionModeFinished(mode);
        }

        @Override
        public void onActivityNewIntent(T activity, Intent intent) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityNewIntent(activity, intent);
            }
        }

        @Override
        public void onBufferedPause(T activity) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onBufferedPause(activity);
            }
        }

        @Override
        public void onBufferedResume(T activity) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onBufferedResume(activity);
            }
        }

        @Override
        public void onBufferedCreate(T activity, Bundle savedInstanceState) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onBufferedCreate(activity, savedInstanceState);
            }
        }

        @Override
        public void onBufferedDestroy(T activity) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onBufferedDestroy(activity);
            }
        }

        @Override
        public void onActivityResume(T activity) {
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Running;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityResume(activity);
            }
            this.onBufferedResume(activity);
        }

        @Override
        public void onActivityPause(T activity) {
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Pausing;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityPause(activity);
            }
            this.onBufferedPause(activity);
        }

        @Override
        public void onActivityStop(T activity) {
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Stopping;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityStop(activity);
            }
        }

        @Override
        public void onActivityStart(T activity) {
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Starting;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityStart(activity);
            }
        }

        @Override
        public void onActivityDestroy(T activity) {
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Destroying;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityDestroy(activity);
            }
            ActivityEventDispatcher.this.mStatus = ActivityStatus.Dead;
        }

        @Override
        public void onActivityCrash(T activity, Thread thread, Throwable throwable) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityCrash(activity, thread, throwable);
            }
        }

        @Override
        public void onLowMemory(T activity) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onLowMemory(activity);
            }
        }

        @Override
        public boolean onActivityBackPressed(T activity) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityBackPressed(activity)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityKeyDown(T activity, int keyCode, KeyEvent event) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityKeyDown(activity, keyCode, event)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityKeyUp(T activity, int keyCode, KeyEvent event) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityKeyUp(activity, keyCode, event)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onActivityCreate(T activity, Bundle savedInstanceState) {
            ActivityEventDispatcher.this.mSavedInstanceStateAtOnCreate = savedInstanceState;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityCreate(activity, savedInstanceState);
            }
        }

        @Override
        public boolean onActivityKeyLongPress(T activity, int keyCode, KeyEvent event) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityKeyLongPress(activity, keyCode, event)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityKeyMultiple(T activity, int keyCode, int repeatCount, KeyEvent event) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityKeyMultiple(activity, keyCode, repeatCount, event)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityDispatchKeyEvent(T activity, KeyEvent event) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityDispatchKeyEvent(activity, event)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityResult(T activity, int requestCode, int resultCode, Intent data) {
            AndroidMainHandler.assertMainThread();
            ActivityEventDispatcher.this.mBufferedActivityResults.add(new ActivityResult((Activity)activity, requestCode, resultCode, data));
            boolean consumed = false;
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityResult(activity, requestCode, resultCode, data)) continue;
                consumed = true;
                break;
            }
            if (consumed) {
                ActivityEventDispatcher.this.mBufferedActivityResults.remove(ActivityEventDispatcher.this.mBufferedActivityResults.size() - 1);
            }
            return consumed;
        }

        @Override
        public boolean onActivityCreateOptionsMenu(T activity, Menu menu2) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityCreateOptionsMenu(activity, menu2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityMenuOpened(T activity, int featureId, Menu menu2) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityMenuOpened(activity, featureId, menu2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityOptionsItemSelected(T activity, MenuItem item) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityOptionsItemSelected(activity, item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void onActivityRequestPermissionsResult(T activity, int requestCode, String[] permissions, int[] grantResults) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                cb.onActivityRequestPermissionsResult(activity, requestCode, permissions, grantResults);
            }
        }

        @Override
        public boolean onActivityPrepareOptionsMenu(T activity, Menu menu2) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityPrepareOptionsMenu(activity, menu2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean onActivityMenuItemSelected(T activity, int featureId, MenuItem item) {
            for (ActivityEventCallback cb : ActivityEventDispatcher.this.getCallbacks()) {
                if (!cb.onActivityMenuItemSelected(activity, featureId, item)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class ActivityResult {
        private final Activity activity;
        private final int requestCode;
        private final int resultCode;
        private final Intent data;

        public ActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {
            this.activity = activity;
            this.requestCode = requestCode;
            this.resultCode = resultCode;
            this.data = data;
        }

        public Activity getActivity() {
            return this.activity;
        }

        public int getRequestCode() {
            return this.requestCode;
        }

        public int getResultCode() {
            return this.resultCode;
        }

        public Intent getData() {
            return this.data;
        }
    }

    public static interface ActivityEventCallback<T extends Activity> {
        public void onBufferedResume(T var1);

        public void onBufferedPause(T var1);

        public void onBufferedCreate(T var1, Bundle var2);

        public void onBufferedDestroy(T var1);

        public boolean onActivityGenericMotionEvent(T var1, MotionEvent var2);

        public void onActivityCrash(T var1, Thread var2, Throwable var3);

        public boolean onActivityCreateThumbnail(T var1, Bitmap var2, Canvas var3);

        public void onActivityCreate(T var1, Bundle var2);

        public void onActivityPostCreate(T var1, Bundle var2);

        public void onActivityTitleChanged(T var1, CharSequence var2, int var3);

        public void onActivityUserLeaveHint(T var1);

        public ActionMode onActivityWindowStartingActionMode(T var1, ActionMode.Callback var2);

        public ActionMode onActivityWindowStartingActionMode(T var1, ActionMode.Callback var2, int var3);

        public boolean onActivityDispatchKeyEvent(T var1, KeyEvent var2);

        public void onActivitySaveInstanceState(T var1, Bundle var2);

        public void onActivityRestoreInstanceState(T var1, Bundle var2);

        public void onActivityStart(T var1);

        public void onActivityRestart(T var1);

        public void onActivityResume(T var1);

        public void onActivityPostResume(T var1);

        public void onActivityConfigurationChanged(T var1, Configuration var2);

        public void onActivityPause(T var1);

        public void onActivityStop(T var1);

        public void onActivityDestroy(T var1);

        public void onActionModeStarted(ActionMode var1);

        public void onActionModeFinished(ActionMode var1);

        public boolean onActivityKeyUp(T var1, int var2, KeyEvent var3);

        public boolean onActivityKeyDown(T var1, int var2, KeyEvent var3);

        public boolean onActivityResult(T var1, int var2, int var3, Intent var4);

        public boolean onActivityCreatePanelMenu(T var1, int var2, Menu var3);

        public boolean onActivityPreparePanel(T var1, int var2, View var3, Menu var4);

        public boolean onActivityMenuItemSelected(T var1, int var2, MenuItem var3);

        public boolean onActivityMenuOpened(T var1, int var2, Menu var3);

        public boolean onActivityPanelClosed(T var1, int var2, Menu var3);

        public void onActivityRequestPermissionsResult(T var1, int var2, String[] var3, int[] var4);

        public boolean onActivityContextItemSelected(T var1, MenuItem var2);

        public boolean onActivityPrepareOptionsMenu(T var1, Menu var2);

        public boolean onActivityCreateOptionsMenu(T var1, Menu var2);

        public void onActivityChildTitleChanged(T var1, Activity var2, CharSequence var3);

        public void onActivityNewIntent(T var1, Intent var2);

        public boolean onActivityKeyLongPress(T var1, int var2, KeyEvent var3);

        public boolean onActivityKeyMultiple(T var1, int var2, int var3, KeyEvent var4);

        public boolean onActivityKeyShortcut(T var1, int var2, KeyEvent var3);

        public boolean onNavigateUp();

        public boolean onActivityNavigateUpFromChild(T var1, Activity var2);

        public boolean onActivityOptionsItemSelected(T var1, MenuItem var2);

        public boolean onActivitySearchRequested(T var1);

        public boolean onActivitySearchRequested(T var1, SearchEvent var2);

        public boolean onActivityTouchEvent(T var1, MotionEvent var2);

        public boolean onActivityTrackballEvent(T var1, MotionEvent var2);

        public CharSequence onActivityCreateDescription(T var1);

        public Uri onActivityProvideReferrer(T var1);

        public View onActivityCreatePanelView(T var1, int var2);

        public boolean onActivityBackPressed(T var1);

        public void onLowMemory(T var1);
    }

    public static class AbsActivityEventCallback<T extends Activity>
    implements ActivityEventCallback<T> {
        @Override
        public void onBufferedPause(T activity) {
        }

        @Override
        public void onBufferedResume(T activity) {
        }

        @Override
        public void onBufferedCreate(T activity, Bundle savedInstanceState) {
        }

        @Override
        public void onBufferedDestroy(T activity) {
        }

        @Override
        public void onActivityCrash(T activity, Thread thread, Throwable throwable) {
        }

        @Override
        public void onActivityRequestPermissionsResult(T activity, int requestCode, String[] permissions, int[] grantResults) {
        }

        @Override
        public boolean onActivityBackPressed(T activity) {
            return false;
        }

        @Override
        public boolean onNavigateUp() {
            return false;
        }

        @Override
        public boolean onActivityNavigateUpFromChild(T activity, Activity child) {
            return false;
        }

        @Override
        public boolean onActivityOptionsItemSelected(T activity, MenuItem item) {
            return false;
        }

        @Override
        public boolean onActivitySearchRequested(T activity) {
            return false;
        }

        @Override
        public boolean onActivitySearchRequested(T activity, SearchEvent searchEvent) {
            return false;
        }

        @Override
        public boolean onActivityTouchEvent(T activity, MotionEvent event) {
            return false;
        }

        @Override
        public boolean onActivityTrackballEvent(T activity, MotionEvent event) {
            return false;
        }

        @Override
        public CharSequence onActivityCreateDescription(T activity) {
            return null;
        }

        @Override
        public Uri onActivityProvideReferrer(T activity) {
            return null;
        }

        @Override
        public View onActivityCreatePanelView(T activity, int featureId) {
            return null;
        }

        @Override
        public void onActionModeStarted(ActionMode mode) {
        }

        @Override
        public void onActionModeFinished(ActionMode mode) {
        }

        @Override
        public void onLowMemory(T activity) {
        }

        @Override
        public boolean onActivityKeyShortcut(T activity, int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onActivityKeyMultiple(T activity, int keyCode, int repeatCount, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onActivityKeyLongPress(T activity, int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onActivityGenericMotionEvent(T activity, MotionEvent event) {
            return false;
        }

        @Override
        public boolean onActivityCreateThumbnail(T activity, Bitmap outBitmap, Canvas canvas) {
            return false;
        }

        @Override
        public ActionMode onActivityWindowStartingActionMode(T activity, ActionMode.Callback callback, int type) {
            return null;
        }

        @Override
        public ActionMode onActivityWindowStartingActionMode(T activity, ActionMode.Callback callback) {
            return null;
        }

        @Override
        public void onActivityUserLeaveHint(T activity) {
        }

        @Override
        public void onActivityNewIntent(T activity, Intent intent) {
        }

        @Override
        public void onActivityCreate(T activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityPostCreate(T activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityTitleChanged(T activity, CharSequence title, int color2) {
        }

        @Override
        public boolean onActivityDispatchKeyEvent(T activity, KeyEvent event) {
            return false;
        }

        @Override
        public void onActivitySaveInstanceState(T activity, Bundle outState) {
        }

        @Override
        public void onActivityRestoreInstanceState(T activity, Bundle savedInstanceState) {
        }

        @Override
        public void onActivityStart(T activity) {
        }

        @Override
        public void onActivityRestart(T activity) {
        }

        @Override
        public void onActivityResume(T activity) {
        }

        @Override
        public void onActivityPostResume(T activity) {
        }

        @Override
        public void onActivityConfigurationChanged(T activity, Configuration newConfig) {
        }

        @Override
        public void onActivityPause(T activity) {
        }

        @Override
        public void onActivityStop(T activity) {
        }

        @Override
        public void onActivityDestroy(T activity) {
        }

        @Override
        public boolean onActivityKeyUp(T activity, int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onActivityKeyDown(T activity, int keyCode, KeyEvent event) {
            return false;
        }

        @Override
        public boolean onActivityResult(T activity, int requestCode, int resultCode, Intent data) {
            return false;
        }

        @Override
        public boolean onActivityCreatePanelMenu(T activity, int featureId, Menu menu2) {
            return false;
        }

        @Override
        public boolean onActivityPreparePanel(T activity, int featureId, View view, Menu menu2) {
            return false;
        }

        @Override
        public boolean onActivityMenuItemSelected(T activity, int featureId, MenuItem item) {
            return false;
        }

        @Override
        public boolean onActivityMenuOpened(T activity, int featureId, Menu menu2) {
            return false;
        }

        @Override
        public boolean onActivityPanelClosed(T activity, int featureId, Menu menu2) {
            return false;
        }

        @Override
        public boolean onActivityContextItemSelected(T activity, MenuItem item) {
            return false;
        }

        @Override
        public boolean onActivityPrepareOptionsMenu(T activity, Menu menu2) {
            return false;
        }

        @Override
        public boolean onActivityCreateOptionsMenu(T activity, Menu menu2) {
            return false;
        }

        @Override
        public void onActivityChildTitleChanged(T activity, Activity childActivity, CharSequence title) {
        }
    }
}

