/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculusframework.factory.async.AsyncDelegate;
import org.homunculusframework.factory.container.BackgroundHandler;
import org.homunculusframework.factory.scope.Scope;

public class GenerateAsyncControllers
implements Generator {
    @Override
    public void generate(GenProject project) throws Exception {
        for (FullQualifiedName bean : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.SINGLETON)) {
            JDefinedClass jc = (JDefinedClass)project.getCodeModel()._package(bean.getPackageName())._class("Async" + bean.getSimpleName());
            AbstractJClass delegateType = project.getCodeModel().ref(bean.toString());
            jc._extends((AbstractJClass)project.getCodeModel().ref(AsyncDelegate.class).narrow(delegateType));
            jc.headerComment().add((Object)project.getDisclaimer(this.getClass()));
            jc.javadoc().add((Object)("This class provides asynchronous calls for all public methods of {@link " + bean.toString() + "}. \nThis should only be used from the UI and not from within other Controllers.\nIt always expects an injected Scope to determine the lifetime of the task.\nIf you need special behavior or other methods, it is fine to extend this class."));
            JMethod method = jc.constructor(1);
            JVar varScope = method.param(Scope.class, "scope");
            JVar varHandler = method.param(BackgroundHandler.class, "handler");
            JVar varDelegate = method.param((AbstractJType)delegateType, "delegate");
            method.body().invokeSuper().arg((IJExpression)varScope).arg((IJExpression)varHandler).arg((IJExpression)varDelegate);
        }
    }

    static class Method {
        final MethodDeclaration declaration;

        public Method(MethodDeclaration declaration) {
            this.declaration = declaration;
        }
    }
}

