/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.EClassType;
import com.helger.jcodemodel.IJAssignmentTarget;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.IJStatement;
import com.helger.jcodemodel.JAssignment;
import com.helger.jcodemodel.JBlock;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JDirectClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JFieldVar;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JSynchronizedBlock;
import com.helger.jcodemodel.JVar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.generator.GenerateBindables;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.Strings;
import org.homunculusframework.factory.flavor.hcf.ScopeElement;
import org.homunculusframework.factory.scope.AbsScope;
import org.homunculusframework.factory.scope.ContextScope;
import org.homunculusframework.factory.scope.Scope;
import org.homunculusframework.lang.Function;
import org.homunculusframework.lang.Panic;
import org.homunculusframework.lang.Ref;

public class GenerateScopes
implements Generator {
    @Override
    public void generate(GenProject project) throws Exception {
        ArrayList<JDefinedClass> appScopes = new ArrayList<JDefinedClass>();
        for (FullQualifiedName app : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.APPLICATION)) {
            appScopes.add(new ApplicationScopeGeneration().create(project, app));
        }
        if (appScopes.isEmpty()) {
            throw new Panic("you need to have exactly one application, but you currently have none");
        }
        if (appScopes.size() > 1) {
            throw new Panic("you need to have exactly one application, but you currently have " + appScopes.size());
        }
        JDefinedClass appScope = (JDefinedClass)appScopes.get(0);
        appScope._implements(project.getCodeModel().ref("org.homunculus.android.component.DefaultHomunculusScope"));
        ArrayList<JDefinedClass> acScopes = new ArrayList<JDefinedClass>();
        ArrayList activities = new ArrayList(project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.ACTIVITY));
        for (FullQualifiedName activity : activities) {
            acScopes.add(new ParentScopeGeneration(appScope).create(project, activity));
        }
        if (acScopes.isEmpty()) {
            throw new Panic("you need to have at least one activity");
        }
        JDefinedClass activitySuperSet = this.createCommonActivitiesScopeInterface(project.getResolver(), project.getCodeModel(), appScope, acScopes);
        for (int i = 0; i < acScopes.size(); ++i) {
            JDefinedClass acScope = (JDefinedClass)acScopes.get(i);
            acScope._implements((AbstractJClass)activitySuperSet.narrow(project.getCodeModel().ref(((FullQualifiedName)activities.get(i)).toString())));
        }
        for (FullQualifiedName bindable : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.BIND)) {
            JDefinedClass jDefinedClass = new ParentScopeGeneration(activitySuperSet).create(project, bindable);
        }
    }

    private JDefinedClass createCommonActivitiesScopeInterface(Resolver resolver, JCodeModel code, JDefinedClass appScope, List<JDefinedClass> activityScopes) throws Exception {
        HashMap<String, ArrayList<JMethod>> methods = new HashMap<String, ArrayList<JMethod>>();
        for (JDefinedClass activityScope : activityScopes) {
            for (JMethod jMethod : activityScope.methods()) {
                if (!jMethod.name().startsWith("get") || !jMethod.params().isEmpty()) continue;
                ArrayList<JMethod> list = (ArrayList<JMethod>)methods.get(jMethod.name());
                if (list == null) {
                    list = new ArrayList<JMethod>();
                    methods.put(jMethod.name(), list);
                }
                list.add(jMethod);
            }
        }
        JDefinedClass superSet = code._class(new FullQualifiedName(appScope.fullName()).getPackageName() + ".ActivityScope", EClassType.INTERFACE);
        superSet.javadoc().add((Object)"This interface contains all scope resources which are equal to all activities. This is the contract which is used by all other bindings.");
        JMethod getContext = null;
        for (Map.Entry entry : methods.entrySet()) {
            if (((List)entry.getValue()).size() != activityScopes.size()) continue;
            ArrayList<FullQualifiedName> returnTypes = new ArrayList<FullQualifiedName>();
            for (JMethod meth : (List)entry.getValue()) {
                returnTypes.add(new FullQualifiedName(meth.type().fullName()));
            }
            List<FullQualifiedName> superTypes = resolver.resolveCommonSuperTypes(returnTypes);
            JMethod commonMethod = superSet.method(1, (AbstractJType)code.ref(superTypes.get(0).toString()), (String)entry.getKey());
            if (!((String)entry.getKey()).equals("getContext")) continue;
            getContext = commonMethod;
        }
        if (getContext != null) {
            superSet._implements((AbstractJClass)code.ref(ContextScope.class).narrow((AbstractJClass)code.directClass("T")));
            superSet.generify("T").bound(code.ref(getContext.type().fullName()));
            getContext.type((AbstractJType)code.directClass("T"));
        } else {
            superSet._implements(Scope.class);
        }
        return superSet;
    }

    private static class ApplicationScopeGeneration
    extends ScopeGenerator {
        private ApplicationScopeGeneration() {
        }

        @Override
        void onStartGeneration(JCodeModel code) throws Exception {
            super.onStartGeneration(code);
            for (FullQualifiedName name : this.project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.SINGLETON)) {
                String singletonGetter = "get" + Strings.startUpperCase(name.getSimpleName());
                this.availableGetters.put(singletonGetter, name);
            }
        }

        @Override
        JDefinedClass create(GenProject project, FullQualifiedName bean) throws Exception {
            JDefinedClass scope = super.create(project, bean);
            JCodeModel code = project.getCodeModel();
            ArrayList<FullQualifiedName> singletons = new ArrayList<FullQualifiedName>((Collection)project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.SINGLETON));
            singletons.sort(Comparator.comparing(FullQualifiedName::getSimpleName));
            for (FullQualifiedName singleton : singletons) {
                try {
                    AbstractJClass providedType = code.ref(singleton.toString());
                    JMethod factoryMethod = this.createSingletonFactory(project.getResolver(), this.availableGetters, code, scope, providedType);
                    this.createDoubleCheckGetter(code, scope, providedType, JExpr.invoke((JMethod)factoryMethod));
                }
                catch (Throwable e) {
                    throw new Panic("failed to process " + singleton, e);
                }
            }
            return scope;
        }

        private JMethod createSingletonFactory(Resolver resolver, Map<String, FullQualifiedName> availableGetters, JCodeModel code, JDefinedClass where, AbstractJClass what) throws Exception {
            return new ObjectCreator().createFactoryMethod(resolver, availableGetters, code, where, what);
        }
    }

    private static class ParentScopeGeneration
    extends ScopeGenerator {
        final JDefinedClass parentScope;
        JDefinedClass commonParentInterface;

        public ParentScopeGeneration(JDefinedClass parentScope) {
            if (parentScope == null) {
                throw new Panic("parent scope is null");
            }
            this.parentScope = parentScope;
        }

        @Override
        void onStartGeneration(JCodeModel code) throws Exception {
            String commonInterfaceName = this.parentScope.fullName() + "Child";
            this.commonParentInterface = code._getClass(commonInterfaceName);
            if (this.commonParentInterface == null) {
                this.commonParentInterface = code._class(1, commonInterfaceName, EClassType.INTERFACE);
                this.commonParentInterface._implements(code.ref(Scope.class));
                this.commonParentInterface.method(1, (AbstractJType)this.parentScope, "getParent");
            }
        }

        @Override
        void onConstructorDefined(JDefinedClass scope, JMethod constructor) {
            scope._implements((AbstractJClass)this.commonParentInterface);
            JVar var = constructor.param((AbstractJType)this.parentScope, Strings.startLowerCase(this.parentScope.name()));
            JFieldVar fieldBean = scope.field(12, (AbstractJType)this.parentScope, var.name());
            constructor.body().add((IJStatement)JExpr._this().ref((JVar)fieldBean).assign((IJExpression)fieldBean));
            JMethod getParent = scope.method(1, (AbstractJType)this.parentScope, "getParent");
            getParent.annotate(Override.class);
            getParent.body()._return((IJExpression)fieldBean);
        }
    }

    private static class ObjectCreator {
        private ObjectCreator() {
        }

        JMethod createFactoryMethod(Resolver resolver, Map<String, FullQualifiedName> availableGetters, JCodeModel code, JDefinedClass where, AbstractJClass what) throws Exception {
            Object getter;
            JVar bean;
            JMethod creator = where.method(4, (AbstractJType)what, "create" + Strings.startUpperCase(what.name()));
            FullQualifiedName fqn = new FullQualifiedName(what.fullName());
            Constructor shortestConstructor = null;
            for (Constructor ctr : resolver.getConstructors(fqn)) {
                if (ctr.isPrivate() || shortestConstructor != null && ctr.getParameters().size() >= shortestConstructor.getParameters().size()) continue;
                shortestConstructor = ctr;
            }
            if (shortestConstructor == null) {
                bean = creator.body().decl((AbstractJType)what, "bean", (IJExpression)JExpr._new((AbstractJClass)what));
            } else {
                JInvocation expr = JExpr._new((AbstractJClass)what);
                for (Parameter p : shortestConstructor.getParameters()) {
                    getter = JExpr.invoke((String)("get" + Strings.startUpperCase(p.getType().getSimpleName())));
                    expr.arg((IJExpression)getter);
                }
                bean = creator.body().decl((AbstractJType)what, "bean", (IJExpression)expr);
            }
            int t = 0;
            block2: for (Field field : resolver.getFields(fqn)) {
                JAssignment beanFieldAssign;
                if (field.getAnnotation(Inject.class) == null) continue;
                getter = "get" + Strings.startUpperCase(field.getType().getFullQualifiedName().getSimpleName());
                if (availableGetters.containsKey(getter)) {
                    JAssignment beanFieldAssign2 = bean.ref(field.getName()).assign((IJExpression)JExpr.invoke((String)getter));
                    creator.body().add((IJStatement)beanFieldAssign2);
                    continue;
                }
                for (Map.Entry entry : availableGetters.entrySet()) {
                    if (!resolver.isInstanceOf(field.getType().getFullQualifiedName(), (FullQualifiedName)entry.getValue())) continue;
                    beanFieldAssign = bean.ref(field.getName()).assign((IJExpression)JExpr.invoke((String)((String)entry.getKey())));
                    creator.body().add((IJStatement)beanFieldAssign);
                    continue block2;
                }
                JVar varThis = creator.body().decl((AbstractJType)where, "t" + t, (IJExpression)JExpr._this());
                ++t;
                IJExpression iJExpression = GenerateBindables.createConstructorCall(GenerateBindables.createLiterals(field), resolver, code, varThis, where, varThis, (AbstractJType)code.ref(field.getType().getFullQualifiedName().toString()), (Ref<Boolean>)new Ref((Object)false));
                beanFieldAssign = bean.ref(field.getName()).assign(iJExpression);
                creator.body().add((IJStatement)beanFieldAssign);
            }
            creator.body()._return((IJExpression)bean);
            return creator;
        }
    }

    private static class ScopeGenerator {
        JCodeModel code;
        Map<String, FullQualifiedName> availableGetters;
        GenProject project;

        private ScopeGenerator() {
        }

        JDefinedClass create(GenProject project, FullQualifiedName bean) throws Exception {
            JCodeModel code;
            this.project = project;
            this.code = code = project.getCodeModel();
            Resolver resolver = project.getResolver();
            this.availableGetters = new HashMap<String, FullQualifiedName>();
            for (Method method : resolver.getMethods(bean)) {
                if (method.getAnnotation(ScopeElement.class) == null) continue;
                String getterName = "get" + Strings.startUpperCase(method.getType().getFullQualifiedName().getSimpleName());
                this.availableGetters.put(getterName, method.getType().getFullQualifiedName());
            }
            this.availableGetters.put("getContext", bean);
            this.onStartGeneration(code);
            AbstractJClass beanClass = code.ref(bean.toString());
            JDefinedClass scope = code._class(bean.toString() + "Scope")._extends(AbsScope.class);
            JFieldVar fieldBean = scope.field(12, (AbstractJType)beanClass, Strings.startLowerCase(bean.getSimpleName()));
            scope._implements((AbstractJClass)code.ref(ContextScope.class).narrow(fieldBean.type()));
            JMethod constructor = scope.constructor(1);
            this.onConstructorDefined(scope, constructor);
            JVar varBean = constructor.param((AbstractJType)beanClass, fieldBean.name());
            constructor.body().add((IJStatement)JExpr._this().ref((JVar)fieldBean).assign((IJExpression)varBean));
            scope.method(1, (AbstractJType)beanClass, "get" + Strings.startUpperCase(beanClass.name())).body()._return((IJExpression)fieldBean);
            for (Method method : project.getResolver().getMethods(bean)) {
                if (method.getAnnotation(ScopeElement.class) == null) continue;
                JInvocation jInvocation = fieldBean.invoke(method.getName());
                AbstractJClass providedType = code.ref(method.getType().getFullQualifiedName().toString());
                this.createDoubleCheckGetter(code, scope, providedType, jInvocation);
            }
            JMethod create = scope.method(1, Void.TYPE, "onCreate");
            create.body().add((IJStatement)JExpr._super().invoke("onCreate"));
            create.body().add((IJStatement)JExpr.invoke((String)"getParent").invoke("addScope").arg((IJExpression)JExpr._this()));
            create.annotate(Override.class);
            for (Method method : resolver.getMethods(bean)) {
                if (method.getAnnotation(PostConstruct.class) == null) continue;
                create.body().add((IJStatement)fieldBean.invoke(method.getName()));
            }
            JMethod jMethod = scope.method(1, Void.TYPE, "onDestroy");
            jMethod.body().add((IJStatement)JExpr._super().invoke("onDestroy"));
            jMethod.body().add((IJStatement)JExpr.invoke((String)"getParent").invoke("removeScope").arg((IJExpression)JExpr._this()));
            jMethod.annotate(Override.class);
            for (Method method : resolver.getMethods(bean)) {
                if (method.getAnnotation(PreDestroy.class) == null) continue;
                jMethod.body().add((IJStatement)fieldBean.invoke(method.getName()));
            }
            JMethod jMethod2 = scope.method(1, fieldBean.type(), "getContext");
            jMethod2.annotate(Override.class);
            jMethod2.body()._return((IJExpression)fieldBean);
            this.createResolveMethod(code, scope);
            this.createForEachEntryMethod(code, scope);
            return scope;
        }

        void onStartGeneration(JCodeModel code) throws Exception {
        }

        void createResolveMethod(JCodeModel code, JDefinedClass scope) {
            JDirectClass genericT = code.directClass("T");
            JMethod resolve = scope.method(1, (AbstractJType)genericT, "resolve");
            resolve.generify("T");
            resolve.annotate(Override.class);
            JVar typeVar = resolve.param((AbstractJType)code.ref(Class.class).narrow((AbstractJClass)genericT), "type");
            resolve.body()._if(typeVar.eqNull())._then()._return((IJExpression)JExpr._null());
            resolve.body()._if((IJExpression)JExpr._this().invoke("getClass").invoke("isAssignableFrom").arg((IJExpression)typeVar))._then()._return((IJExpression)JExpr.cast((AbstractJType)genericT, (IJExpression)JExpr._this()));
            for (JMethod method : scope.methods()) {
                if (!method.name().startsWith("get")) continue;
                JVar tmpVar = resolve.body().decl(method.type(), "_" + Strings.startLowerCase(method.name().substring(3)), (IJExpression)JExpr._this().invoke(method));
                JInvocation assignable = typeVar.invoke("isAssignableFrom").arg((IJExpression)JExpr.invoke((IJExpression)tmpVar, (String)"getClass"));
                resolve.body()._if(tmpVar.neNull().cand((IJExpression)assignable))._then()._return((IJExpression)JExpr.cast((AbstractJType)genericT, (IJExpression)tmpVar));
            }
            JVar tmpScope = resolve.body().decl((AbstractJType)code.ref(Scope.class), "parent", (IJExpression)JExpr._this().invoke("getParent"));
            resolve.body()._if(tmpScope.eqNull())._then()._return((IJExpression)JExpr._null());
            resolve.body()._return((IJExpression)tmpScope.invoke("resolve").arg((IJExpression)typeVar));
        }

        void createForEachEntryMethod(JCodeModel code, JDefinedClass scope) {
            JMethod resolve = scope.method(1, Void.TYPE, "forEachEntry");
            resolve.annotate(Override.class);
            JVar closureVar = resolve.param((AbstractJType)code.ref(Function.class).narrow(Object.class).narrow(Boolean.class), "closure");
            JVar nextVar = resolve.body().decl((AbstractJType)code.ref(Boolean.class), "next");
            for (JMethod method : scope.methods()) {
                if (!method.name().startsWith("get") || method.name().equals("getContext")) continue;
                resolve.body().assign((IJAssignmentTarget)nextVar, (IJExpression)closureVar.invoke("apply").arg((IJExpression)JExpr._this().invoke(method)));
                resolve.body()._if(nextVar.eqNull().cor(nextVar.eq((IJExpression)JExpr.FALSE)))._then()._return();
            }
        }

        void onConstructorDefined(JDefinedClass scope, JMethod constructor) {
            JMethod getParent = scope.method(1, Scope.class, "getParent");
            getParent.annotate(Override.class);
            getParent.body()._return((IJExpression)JExpr._null());
        }

        void createDoubleCheckGetter(JCodeModel code, JDefinedClass where, AbstractJClass what, JInvocation factory) {
            JFieldVar field = where.field(516, (AbstractJType)what, Strings.startLowerCase(what.name()));
            JMethod getter = where.method(1, (AbstractJType)what, "get" + Strings.startUpperCase(what.name()));
            JVar varBean = getter.body().decl((AbstractJType)what, what.name().equals("tmp") ? "_tmp" : "tmp", (IJExpression)field);
            JSynchronizedBlock sync = getter.body()._if(varBean.eqNull())._then().synchronizedBlock((IJExpression)JExpr._this());
            JBlock then = sync.body()._if(field.eqNull())._then();
            then.add((IJStatement)field.assign((IJExpression)JExpr.assign((IJAssignmentTarget)varBean, (IJExpression)factory)));
            getter.body()._return((IJExpression)varBean);
        }
    }
}

