/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JCodeModel;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JInvocation;
import com.helger.jcodemodel.JLambda;
import com.helger.jcodemodel.JLambdaParam;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.concurrent.Future;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.generator.PreprocessDiscoverBeans;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Parameter;
import org.homunculus.codegen.parse.Resolver;
import org.homunculusframework.concurrent.Cancellable;
import org.homunculusframework.concurrent.NotInterruptible;
import org.homunculusframework.concurrent.Task;
import org.homunculusframework.factory.container.Binding;
import org.homunculusframework.factory.container.MethodBinding;
import org.homunculusframework.factory.container.ModelAndView;
import org.homunculusframework.lang.Result;

public class GenerateTaskMethods
implements Generator {
    @Override
    public void generate(GenProject project) throws Exception {
        JCodeModel code = project.getCodeModel();
        Resolver resolver = project.getResolver();
        for (FullQualifiedName bean : project.getDiscoveredKinds().get((Object)PreprocessDiscoverBeans.DiscoveryKind.SINGLETON)) {
            String ctrName = "Async" + bean.getSimpleName();
            JDefinedClass cl = project.getCodeModel()._getClass(bean.getPackageName() + "." + ctrName);
            if (cl == null) {
                throw new RuntimeException(ctrName + " not found in codemodel");
            }
            int idCtr = 0;
            for (Method method : resolver.getMethods(bean)) {
                boolean isCancellable;
                String[] disallowedTypes;
                if (method.isPrivate() || method.isProtected() || method.isStatic()) continue;
                FullQualifiedName methodType = method.getType().getFullQualifiedName();
                for (String c : disallowedTypes = new String[]{MethodBinding.class.getName(), Task.class.getName(), Future.class.getName()}) {
                    if (!resolver.isInstanceOf(methodType, new FullQualifiedName(c))) continue;
                    throw method.newLintException("It is not allowed, that a HCF controller exports the type " + c);
                }
                if (resolver.isInstanceOf(methodType, new FullQualifiedName(Binding.class)) || resolver.isInstanceOf(methodType, new FullQualifiedName(ModelAndView.class))) continue;
                AbstractJClass actualReturn = project.getCodeModel().ref(method.getType().getFullQualifiedName().toString());
                JMethod newMeth = cl.method(1, (AbstractJType)project.getCodeModel().ref(Task.class).narrow((AbstractJClass)project.getCodeModel().ref(Result.class).narrow(actualReturn)), method.getName());
                newMeth.javadoc().add((Object)("Uses {@link org.homunculusframework.factory.container.Container#NAME_BACKGROUND_HANDLER} from the current scope to execute {@link " + method.asJavadocAnchor() + "} asynchronously."));
                JInvocation async = JExpr.invoke((String)"async");
                async.arg(idCtr++ + "-" + method.getName());
                boolean notInterruptible = method.getAnnotation(NotInterruptible.class) != null;
                boolean bl = isCancellable = method.getAnnotation(Cancellable.class) != null;
                if (notInterruptible) {
                    async.arg((IJExpression)cl.staticRef("DO_NOT_INTERRUPT"));
                } else {
                    async.arg((IJExpression)cl.staticRef("MAY_INTERRUPT"));
                }
                if (isCancellable) {
                    async.arg((IJExpression)cl.staticRef("CANCEL_PENDING"));
                } else {
                    async.arg((IJExpression)cl.staticRef("DO_NOT_CANCEL_PENDING"));
                }
                JLambda lambda = new JLambda();
                JLambdaParam ctr = lambda.addParam("ctr");
                JInvocation ctrInvokeMethod = ctr.invoke(method.getName());
                for (Parameter param : method.getParameters()) {
                    JVar asyncMethodParam = newMeth.param((AbstractJType)project.getCodeModel().ref(param.getType().toString()), param.getName());
                    ctrInvokeMethod.arg((IJExpression)asyncMethodParam);
                }
                lambda.body().lambdaExpr((IJExpression)ctrInvokeMethod);
                async.arg((IJExpression)lambda);
                newMeth.body()._return((IJExpression)async);
            }
        }
    }
}

