/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.generator;

import com.helger.jcodemodel.AbstractJClass;
import com.helger.jcodemodel.AbstractJType;
import com.helger.jcodemodel.IJExpression;
import com.helger.jcodemodel.JClassAlreadyExistsException;
import com.helger.jcodemodel.JDefinedClass;
import com.helger.jcodemodel.JExpr;
import com.helger.jcodemodel.JMethod;
import com.helger.jcodemodel.JVar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.homunculus.codegen.GenProject;
import org.homunculus.codegen.Generator;
import org.homunculus.codegen.XMLFile;
import org.homunculus.codegen.parse.Strings;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class GenerateViewsFromXML
implements Generator {
    private static final String XML_ID_SIMPLE = "android:id";
    private static final String INCLUDE = "include";
    private static final String AT_LAYOUT = "@layout/";
    private static final Map<String, String> ALIASE = new HashMap<String, String>();

    @Override
    public void generate(GenProject project) throws Exception {
        Map<String, XMLFile> toGenerate = this.collectViews(project);
    }

    private Map<String, XMLFile> collectViews(GenProject project) throws JClassAlreadyExistsException {
        HashMap<String, XMLFile> toGenerate = new HashMap<String, XMLFile>();
        for (XMLFile file : project.getXmlFiles()) {
            Object className;
            if (!file.getFile().getParentFile().getName().equals("layout")) continue;
            String mainPackage = project.getManifestPackage();
            String fname = file.getFile().getName().substring(0, file.getFile().getName().length() - 4);
            String[] relPackageName = fname.split(Pattern.quote("_"));
            if (relPackageName.length == 0) {
                className = mainPackage + "." + Strings.startUpperCase(Strings.nicefy(fname));
            } else {
                className = mainPackage;
                for (int i = 0; i < relPackageName.length - 1; ++i) {
                    className = (String)className + "." + relPackageName[i];
                }
                className = (String)className + "." + Strings.startUpperCase(Strings.nicefy(relPackageName[relPackageName.length - 1]));
            }
            this.genClass(project, file, (String)className);
        }
        return toGenerate;
    }

    private void genClass(GenProject project, XMLFile file, String className) throws JClassAlreadyExistsException {
        String simpleClassName;
        String packagename;
        if (className.lastIndexOf(46) > 0) {
            packagename = className.substring(0, className.lastIndexOf(46));
            simpleClassName = className.substring(className.lastIndexOf(46) + 1, className.length());
        } else {
            packagename = "";
            simpleClassName = className;
        }
        JDefinedClass cl = (JDefinedClass)project.getCodeModel()._package(packagename)._class(simpleClassName);
        cl._extends((AbstractJClass)project.getCodeModel().directClass("org.homunculus.android.component.InflaterView"));
        cl.javadoc().add((Object)project.getDisclaimer(this.getClass()));
        cl.javadoc().add((Object)("\nThis class has been generated from " + file.getFile().getAbsolutePath().substring(project.getProjectRoot().getAbsolutePath().length())));
        JMethod con = cl.constructor(1);
        JVar pCtx = con.param((AbstractJType)project.getCodeModel().ref("android.content.Context"), "context");
        String attribName = file.getFile().getName().substring(0, file.getFile().getName().length() - 4);
        String impName = project.getManifestPackage() + ".R.layout";
        con.javadoc().add((Object)("Inflates the layout from {@link " + impName + "." + attribName + "}"));
        con.body().invokeSuper().arg((IJExpression)pCtx).arg((IJExpression)project.getCodeModel().ref(impName).staticRef(attribName));
        this.inflate(project, file);
        List<Element> exports = file.collect(element -> {
            String id2 = element.getAttribute(XML_ID_SIMPLE);
            if (id2 == null || id2.trim().length() == 0) {
                return false;
            }
            return true;
        });
        for (Element element2 : exports) {
            if (element2.getNodeName().equals(INCLUDE)) {
                // empty if block
            }
            String id2 = element2.getAttribute(XML_ID_SIMPLE);
            AbstractJClass returnType = project.getCodeModel().ref(this.getAndroidViewName(element2.getNodeName()));
            JMethod meth = cl.method(1, (AbstractJType)returnType, "get" + this.makeNiceName(id2));
            String fieldName = id2.substring(id2.lastIndexOf("/") + 1);
            meth.body()._return(JExpr.direct((String)("findViewById(" + project.getManifestPackage() + ".R.id." + fieldName + ")")));
            Comment comment = this.grabLatestNode(element2);
            if (comment == null) continue;
            meth.javadoc().add((Object)comment.getNodeValue());
        }
    }

    private void inflate(GenProject project, XMLFile file) {
        List<Element> includes;
        block0: while (!(includes = file.collect(element -> element.getNodeName().equals(INCLUDE))).isEmpty()) {
            Iterator<Element> iterator = includes.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Element include = iterator.next();
                String layoutId = include.getAttribute("layout");
                if (layoutId.startsWith(AT_LAYOUT)) {
                    layoutId = layoutId.substring(AT_LAYOUT.length());
                }
                String androidId = include.getAttribute(XML_ID_SIMPLE);
                XMLFile includeFile = null;
                String targetFileName = layoutId + ".xml";
                for (XMLFile i : project.getXmlFiles()) {
                    if (!i.getFile().getName().equals(targetFileName)) continue;
                    includeFile = i;
                    break;
                }
                Element templateView = includeFile == null ? file.getDoc().createElement("android.view.View") : (Element)file.getDoc().importNode(includeFile.getDoc().getDocumentElement(), true);
                Node templateParent = include.getParentNode();
                templateParent.removeChild(include);
                if (include.getNextSibling() != null) {
                    Node nextSibling = include.getNextSibling();
                    templateParent.insertBefore(templateView, nextSibling);
                } else {
                    templateParent.appendChild(templateView);
                }
                if (androidId == null) continue;
                templateView.setAttribute(XML_ID_SIMPLE, androidId);
            }
            break;
        }
        return;
    }

    @Nullable
    private Comment grabLatestNode(Node node) {
        Node priorSib = node.getPreviousSibling();
        if (priorSib == null) {
            return null;
        }
        while (priorSib instanceof Text) {
            priorSib = priorSib.getPreviousSibling();
        }
        if (priorSib instanceof Comment) {
            return (Comment)priorSib;
        }
        return null;
    }

    private String getAndroidViewName(String id2) {
        if (id2.contains(".")) {
            return id2;
        }
        String overrideImport = ALIASE.get(id2);
        if (overrideImport != null) {
            return overrideImport;
        }
        return "android.widget." + id2;
    }

    private String makeNiceName(String androidIdDecl) {
        String name = androidIdDecl.substring(androidIdDecl.lastIndexOf("/") + 1);
        StringBuilder sb = new StringBuilder();
        for (String camel : name.split(Pattern.quote("_"))) {
            if (camel.length() == 0) continue;
            sb.append(camel.substring(0, 1).toUpperCase());
            sb.append(camel.substring(1));
        }
        return Strings.nicefy(sb.toString());
    }

    static {
        ALIASE.put("ImageView", "android.widget.ImageView");
        ALIASE.put("ViewGroup", "android.view.ViewGroup");
        ALIASE.put("View", "android.view.View");
    }
}

