/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import javax.annotation.Nullable;
import org.homunculus.codegen.generator.LintException;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.javaparser.SrcFile;
import org.homunculus.codegen.parse.javaparser.TypeContext;
import org.slf4j.LoggerFactory;

public class JPAnnotation
implements Annotation {
    private final AnnotationExpr annotationDeclaration;
    private final FullQualifiedName fqn;
    private final TypeContext ctx;

    public JPAnnotation(TypeContext ctx, FullQualifiedName fqn, AnnotationExpr annotationDeclaration) {
        this.annotationDeclaration = annotationDeclaration;
        this.fqn = fqn;
        this.ctx = ctx;
    }

    @Override
    public FullQualifiedName getFullQualifiedName() {
        return this.fqn;
    }

    @Override
    @Nullable
    public String getString(String key) {
        if (key == null || key.isEmpty()) {
            key = "value";
        }
        if (this.annotationDeclaration instanceof SingleMemberAnnotationExpr && key.equals("value")) {
            SingleMemberAnnotationExpr expr = (SingleMemberAnnotationExpr)this.annotationDeclaration;
            if (expr.getMemberValue() instanceof StringLiteralExpr) {
                return ((StringLiteralExpr)expr.getMemberValue()).getValue();
            }
            if (expr.getMemberValue() instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)expr.getMemberValue();
                String value = JPAnnotation.resolveLocalStaticFieldValue(this.ctx.src, nameExpr.getNameAsString());
                if (value != null) {
                    return value;
                }
                LoggerFactory.getLogger(this.getClass()).warn("constant evaluation from NameExpr not supported: {}", (Object)nameExpr);
                return null;
            }
            if (expr.getMemberValue() instanceof IntegerLiteralExpr) {
                IntegerLiteralExpr integerExp = (IntegerLiteralExpr)expr.getMemberValue();
                return Integer.toString((Integer)integerExp.asNumber());
            }
            if (expr.getMemberValue() instanceof FieldAccessExpr) {
                FieldAccessExpr fieldExpr = (FieldAccessExpr)expr.getMemberValue();
                String scopeName = ((NameExpr)fieldExpr.getScope()).getNameAsString();
                FullQualifiedName fqnScope = new FullQualifiedName(this.ctx.src.getFullQualifiedName(scopeName));
                try {
                    return (String)Class.forName(fqnScope.toString()).getField(fieldExpr.getNameAsString()).get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (expr.getMemberValue() instanceof UnaryExpr) {
                UnaryExpr fieldExpr = (UnaryExpr)expr.getMemberValue();
                return fieldExpr.getOperator().asString() + fieldExpr.getExpression().toString();
            }
            LoggerFactory.getLogger(this.getClass()).warn("constant evaluation from SingleMemberAnnotationExpr.member not supported: {} -> {}", expr.getMemberValue().getClass(), (Object)expr);
            return null;
        }
        LoggerFactory.getLogger(this.getClass()).warn("constant evaluation from annotationDeclaration not supported: {}", this.annotationDeclaration.getClass());
        return null;
    }

    @Nullable
    private static String resolveLocalStaticFieldValue(SrcFile src, String fieldName) {
        for (FieldDeclaration f : ((ClassOrInterfaceDeclaration)src.getUnit().getClassByName(src.getPrimaryClassName()).get()).getFields()) {
            VariableDeclarator var;
            if (f.getVariables().size() <= 0 || !(var = (VariableDeclarator)f.getVariables().get(0)).getNameAsString().equals(fieldName) || !var.getInitializer().isPresent() || !(var.getInitializer().get() instanceof StringLiteralExpr)) continue;
            return ((Expression)var.getInitializer().get()).asStringLiteralExpr().asString();
        }
        return null;
    }

    public String toString() {
        return this.getFullQualifiedName().toString();
    }

    @Override
    @Nullable
    public FullQualifiedName getConstant(String key) {
        SingleMemberAnnotationExpr expr;
        if (this.annotationDeclaration instanceof SingleMemberAnnotationExpr && (expr = (SingleMemberAnnotationExpr)this.annotationDeclaration).getMemberValue() instanceof FieldAccessExpr) {
            FieldAccessExpr fae = (FieldAccessExpr)expr.getMemberValue();
            Object tmp = fae.getScope().toString();
            int fIdxDot = ((String)tmp).indexOf(46);
            if (fIdxDot > 0) {
                tmp = this.ctx.src.getFullQualifiedName(((String)tmp).substring(0, fIdxDot)) + ((String)tmp).substring(fIdxDot);
            }
            return new FullQualifiedName((String)tmp + "." + fae.getNameAsString());
        }
        return null;
    }

    @Override
    public LintException newLintException(String msg) {
        return new LintException(msg, this.ctx.src, (Range)this.annotationDeclaration.getRange().get());
    }
}

