/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.javaparser;

import com.github.javaparser.Range;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import java.util.ArrayList;
import java.util.List;
import org.homunculus.codegen.generator.LintException;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Type;
import org.homunculus.codegen.parse.javaparser.JPAnnotation;
import org.homunculus.codegen.parse.javaparser.TypeContext;
import org.homunculus.codegen.parse.javaparser.TypeUtil;

public class JPField
implements Field {
    private final FieldDeclaration fieldDeclaration;
    private final TypeContext ctx;
    private final boolean isDeclared;

    public JPField(TypeContext ctx, FieldDeclaration fieldDeclaration, boolean isDeclared) {
        this.fieldDeclaration = fieldDeclaration;
        this.ctx = ctx;
        this.isDeclared = isDeclared;
    }

    @Override
    public FullQualifiedName getDeclaringType() {
        return this.ctx.name;
    }

    @Override
    public boolean isPublic() {
        return this.fieldDeclaration.isPublic();
    }

    @Override
    public boolean isProtected() {
        return this.fieldDeclaration.isProtected();
    }

    @Override
    public boolean isPrivate() {
        return this.fieldDeclaration.isPrivate();
    }

    @Override
    public String getName() {
        return ((VariableDeclarator)this.fieldDeclaration.getVariables().get(0)).getNameAsString();
    }

    @Override
    public Type getType() {
        return TypeUtil.convert(this.ctx, ((VariableDeclarator)this.fieldDeclaration.getVariables().get(0)).getType());
    }

    @Override
    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        for (AnnotationExpr a : this.fieldDeclaration.getAnnotations()) {
            res.add(new JPAnnotation(this.ctx, new FullQualifiedName(this.ctx.src.getFullQualifiedName(a.getNameAsString())), a));
        }
        return res;
    }

    @Override
    public LintException newLintException(String msg) {
        throw new LintException(msg, this.ctx.src, (Range)this.fieldDeclaration.getRange().get());
    }
}

