/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.javaparser;

import android.app.Activity;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.homunculus.codegen.parse.Annotation;
import org.homunculus.codegen.parse.Constructor;
import org.homunculus.codegen.parse.Field;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Method;
import org.homunculus.codegen.parse.Resolver;
import org.homunculus.codegen.parse.javaparser.JPAnnotation;
import org.homunculus.codegen.parse.javaparser.JPConstructor;
import org.homunculus.codegen.parse.javaparser.JPField;
import org.homunculus.codegen.parse.javaparser.JPMethod;
import org.homunculus.codegen.parse.javaparser.SrcFile;
import org.homunculus.codegen.parse.javaparser.TypeContext;
import org.homunculus.codegen.parse.jcodemodel.JCodeModelResolver;
import org.homunculus.codegen.parse.reflection.ReflectionResolver;

public class JPResolver
implements Resolver {
    private List<SrcFile> srcFiles;
    private Map<FullQualifiedName, TypeContext> typeTree = new HashMap<FullQualifiedName, TypeContext>();
    private ReflectionResolver reflection = new ReflectionResolver();
    private JCodeModelResolver codeResolver;
    static final Map<FullQualifiedName, FullQualifiedName> instanceOfTable = new HashMap<FullQualifiedName, FullQualifiedName>();

    public JPResolver(JCodeModelResolver codeResolver, List<SrcFile> srcFiles) {
        this.srcFiles = srcFiles;
        this.codeResolver = codeResolver;
        for (SrcFile file : srcFiles) {
            file.setResolver(this);
            for (TypeDeclaration td : file.getUnit().getTypes()) {
                FullQualifiedName fqn = new FullQualifiedName(file.getFullQualifiedName(td.getNameAsString()));
                this.typeTree.put(fqn, new TypeContext(file, td, fqn));
            }
        }
    }

    @Override
    public void getSuperTypes(FullQualifiedName name, List<FullQualifiedName> dst) throws ClassNotFoundException {
        ArrayList<FullQualifiedName> found = new ArrayList<FullQualifiedName>();
        ArrayList<FullQualifiedName> notFound = new ArrayList<FullQualifiedName>();
        ArrayList<FullQualifiedName> seeds = new ArrayList<FullQualifiedName>();
        seeds.add(name);
        for (int retry = 0; retry < 20; ++retry) {
            ArrayList tmp = new ArrayList(seeds);
            for (FullQualifiedName seed : tmp) {
                this.listTypes(seed, found, notFound);
                this.reflection.listTypes(seed, found, notFound);
                this.codeResolver.listTypes(seed, found, notFound);
            }
            this.unique(seeds);
            this.unique(found);
            this.unique(notFound);
            notFound.removeAll(found);
            seeds.clear();
            seeds.addAll(notFound);
        }
        dst.addAll(found);
        dst.addAll(notFound);
        this.unique(dst);
        dst.remove(new FullQualifiedName(Object.class));
        dst.add(new FullQualifiedName(Object.class));
    }

    private void unique(List<FullQualifiedName> list) {
        HashSet<FullQualifiedName> used = new HashSet<FullQualifiedName>();
        ArrayList<FullQualifiedName> tmp = new ArrayList<FullQualifiedName>(list.size());
        for (FullQualifiedName fqn : list) {
            if (used.contains(fqn)) continue;
            tmp.add(fqn);
            used.add(fqn);
        }
        list.clear();
        list.addAll(tmp);
    }

    public void listTypes(FullQualifiedName src, List<FullQualifiedName> found, List<FullQualifiedName> notFound) {
        TypeContext tc = this.typeTree.get(src);
        if (tc == null) {
            notFound.add(src);
        } else if (tc.type instanceof ClassOrInterfaceDeclaration) {
            FullQualifiedName fqn;
            ClassOrInterfaceDeclaration dec = (ClassOrInterfaceDeclaration)tc.type;
            for (ClassOrInterfaceType s : dec.getExtendedTypes()) {
                fqn = new FullQualifiedName(tc.src.getFullQualifiedName(s.getNameAsString()));
                this.listTypes(fqn, found, notFound);
            }
            for (ClassOrInterfaceType s : dec.getImplementedTypes()) {
                fqn = new FullQualifiedName(tc.src.getFullQualifiedName(s.getNameAsString()));
                this.listTypes(fqn, found, notFound);
            }
        }
    }

    @Override
    public boolean has(FullQualifiedName name) {
        if (this.typeTree.containsKey(name)) {
            return true;
        }
        if (this.codeResolver.has(name)) {
            return true;
        }
        return this.reflection.has(name);
    }

    @Override
    public List<Constructor> getConstructors(FullQualifiedName name) throws ClassNotFoundException {
        TypeContext tc = this.typeTree.get(name);
        if (tc == null) {
            try {
                return this.reflection.getConstructors(name);
            }
            catch (ClassNotFoundException nfe) {
                return this.codeResolver.getConstructors(name);
            }
        }
        ClassOrInterfaceDeclaration dec = (ClassOrInterfaceDeclaration)tc.src.getUnit().getClassByName(name.getSimpleName()).get();
        ArrayList<Constructor> res = new ArrayList<Constructor>();
        for (ConstructorDeclaration c : dec.getConstructors()) {
            res.add(new JPConstructor(tc, name, c));
        }
        return res;
    }

    @Override
    public List<FullQualifiedName> getTypes() {
        return new ArrayList<FullQualifiedName>(this.typeTree.keySet());
    }

    @Override
    public boolean isAbstract(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.getModifiers().contains((Node)Modifier.abstractModifier());
    }

    @Override
    public boolean isPublic(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.isPublic();
    }

    @Override
    public boolean isStatic(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.isStatic();
    }

    @Override
    public boolean isNested(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.isNestedType();
    }

    @Override
    public boolean isPrivate(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.isPrivate();
    }

    @Override
    public boolean isTopLevelType(FullQualifiedName name) {
        return this.typeTree.get((Object)name).type.isTopLevelType();
    }

    @Override
    public List<Annotation> getAnnotations(FullQualifiedName name) {
        ArrayList<Annotation> res = new ArrayList<Annotation>();
        TypeContext ctx = this.typeTree.get(name);
        NodeList tmp = ctx.type.getAnnotations();
        for (AnnotationExpr a : tmp) {
            res.add(new JPAnnotation(ctx, new FullQualifiedName(ctx.src.getFullQualifiedName(a.getNameAsString())), a));
        }
        return res;
    }

    @Override
    @Nullable
    public List<Method> getMethods(FullQualifiedName name) throws ClassNotFoundException {
        TypeContext td = this.typeTree.get(name);
        if (td == null) {
            return this.reflection.getMethods(name);
        }
        ArrayList<Method> res = new ArrayList<Method>();
        boolean isDeclared = true;
        while (td != null) {
            if (td.type instanceof ClassOrInterfaceDeclaration) {
                for (MethodDeclaration m : td.type.asClassOrInterfaceDeclaration().getMethods()) {
                    res.add(new JPMethod(td, name, m, isDeclared));
                }
                if (td.type.asClassOrInterfaceDeclaration().getExtendedTypes().size() > 0) {
                    String superTypeName = ((ClassOrInterfaceType)td.type.asClassOrInterfaceDeclaration().getExtendedTypes().get(0)).getNameAsString();
                    FullQualifiedName superType = new FullQualifiedName(td.src.getFullQualifiedName(superTypeName));
                    td = this.typeTree.get(superType);
                    if (td == null) {
                        try {
                            res.addAll(this.reflection.getMethods(superType));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            System.out.println("unable to resolve methods for: " + superType);
                        }
                        break;
                    }
                } else {
                    td = null;
                }
            }
            isDeclared = false;
        }
        return res;
    }

    @Override
    public List<Field> getFields(FullQualifiedName name) throws ClassNotFoundException {
        TypeContext td = this.typeTree.get(name);
        if (td == null) {
            return this.reflection.getFields(name);
        }
        ArrayList<Field> res = new ArrayList<Field>();
        boolean isDeclared = true;
        while (td != null) {
            if (td.type instanceof ClassOrInterfaceDeclaration) {
                for (FieldDeclaration m : td.type.asClassOrInterfaceDeclaration().getFields()) {
                    res.add(new JPField(td, m, isDeclared));
                }
                if (td.type.asClassOrInterfaceDeclaration().getExtendedTypes().size() > 0) {
                    String superTypeName = ((ClassOrInterfaceType)td.type.asClassOrInterfaceDeclaration().getExtendedTypes().get(0)).getNameAsString();
                    FullQualifiedName superType = new FullQualifiedName(td.src.getPackageName() + "." + superTypeName);
                    td = this.typeTree.get(superType);
                    if (td == null) {
                        try {
                            res.addAll(this.reflection.getFields(superType));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                        break;
                    }
                } else {
                    td = null;
                }
            } else {
                td = null;
            }
            isDeclared = false;
        }
        return res;
    }

    @Override
    public boolean isInstanceOf(FullQualifiedName which, FullQualifiedName what) {
        if (which.equals(what)) {
            return true;
        }
        if (what.equals(instanceOfTable.get(which))) {
            return true;
        }
        TypeContext root = this.typeTree.get(which);
        String startingPoint = which.toString();
        while (root != null) {
            if (!(root.type instanceof ClassOrInterfaceDeclaration)) {
                root = null;
                continue;
            }
            if (root.type.asClassOrInterfaceDeclaration().getExtendedTypes().isEmpty()) {
                root = null;
                continue;
            }
            String superTypeName = ((ClassOrInterfaceType)root.type.asClassOrInterfaceDeclaration().getExtendedTypes().get(0)).getNameAsString();
            FullQualifiedName superType = new FullQualifiedName(root.src.getFullQualifiedName(superTypeName));
            if (superType.equals(what)) {
                return true;
            }
            root = this.typeTree.get(superType);
            startingPoint = superType.toString();
            if (!what.equals(instanceOfTable.get(superType))) continue;
            return true;
        }
        if (what.equals(new FullQualifiedName(startingPoint))) {
            return true;
        }
        try {
            for (Class<?> reflectionRoot = Class.forName(startingPoint); reflectionRoot != null; reflectionRoot = reflectionRoot.getSuperclass()) {
                if (!new FullQualifiedName(reflectionRoot).equals(what)) continue;
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            ArrayList<FullQualifiedName> superTypes = new ArrayList<FullQualifiedName>();
            this.codeResolver.listTypes(new FullQualifiedName(startingPoint), superTypes, superTypes);
            for (FullQualifiedName fqnSuperType : superTypes) {
                if (!fqnSuperType.equals(what)) continue;
                return true;
            }
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return false;
    }

    static {
        instanceOfTable.put(new FullQualifiedName("org.homunculus.android.component.HomunculusActivity"), new FullQualifiedName(Activity.class));
        instanceOfTable.put(new FullQualifiedName("org.homunculus.android.compat.EventAppCompatActivity"), new FullQualifiedName(Activity.class));
    }
}

