/*
 * Decompiled with CFR 0.152.
 */
package org.homunculus.codegen.parse.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import java.io.File;
import javax.annotation.Nullable;
import org.homunculus.codegen.parse.FullQualifiedName;
import org.homunculus.codegen.parse.Resolver;

public class SrcFile {
    private final File file;
    private final CompilationUnit unit;
    private Resolver resolver;

    public SrcFile(File file, CompilationUnit unit) {
        this.file = file;
        this.unit = unit;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public CompilationUnit getUnit() {
        return this.unit;
    }

    public File getFile() {
        return this.file;
    }

    public String getPrimaryClassName() {
        return this.getFile().getName().substring(0, this.getFile().getName().length() - 5);
    }

    public String getFullQualifiedName(String name) {
        if (name.contains(".")) {
            return name;
        }
        String tmp = "." + name;
        for (ImportDeclaration imp : this.unit.getImports()) {
            if (!imp.getNameAsString().endsWith(tmp)) continue;
            return imp.getNameAsString();
        }
        if (this.unit.getPackageDeclaration().isPresent()) {
            if (this.unit.getClassByName(name).isPresent()) {
                return ((PackageDeclaration)this.unit.getPackageDeclaration().get()).getNameAsString() + "." + name;
            }
            tmp = ((PackageDeclaration)this.unit.getPackageDeclaration().get()).getName().toString() + "." + name;
            if (this.resolver.has(new FullQualifiedName(tmp))) {
                return tmp;
            }
            switch (name) {
                case "int": 
                case "float": 
                case "boolean": 
                case "double": 
                case "char": 
                case "long": {
                    return name;
                }
            }
            return "java.lang." + name;
        }
        return name;
    }

    public String getFullQualifiedName(Type type) {
        if (type instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType itype = (ClassOrInterfaceType)type;
            StringBuilder str = new StringBuilder();
            itype.getScope().ifPresent(s -> str.append(s.asString()).append("."));
            str.append(itype.getName().asString());
            return this.getFullQualifiedName(str.toString());
        }
        return type.toString();
    }

    public String getFullQualifiedNamePrimaryClassName() {
        if (this.unit.getPackageDeclaration().isPresent()) {
            return ((PackageDeclaration)this.unit.getPackageDeclaration().get()).getNameAsString() + "." + this.getPrimaryClassName();
        }
        return this.getPrimaryClassName();
    }

    public String getPackageName() {
        if (this.unit.getPackageDeclaration().isPresent()) {
            return ((PackageDeclaration)this.unit.getPackageDeclaration().get()).getNameAsString();
        }
        return "";
    }

    @Nullable
    public AnnotationExpr getAnnotation(ClassOrInterfaceDeclaration type, String fqn) {
        for (AnnotationExpr a : type.getAnnotations()) {
            String aFqn = this.getFullQualifiedName(a.getNameAsString());
            if (!aFqn.equals(fqn)) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public AnnotationExpr getAnnotation(ClassOrInterfaceDeclaration type, Class annotation) {
        return this.getAnnotation(type, annotation.getName());
    }
}

