/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.beeline.spring.beans;

import brave.propagation.ExtraFieldPropagation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.honeycomb.beeline.spring.autoconfig.BeelineProperties;
import io.honeycomb.beeline.tracing.Beeline;
import io.honeycomb.beeline.tracing.SpanBuilderFactory;
import io.honeycomb.beeline.tracing.TracerSpan;
import io.honeycomb.beeline.tracing.propagation.PropagationContext;
import io.honeycomb.libhoney.Event;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public class BraveBeelineReporter
implements Reporter<Span> {
    private static final Short MICROS_IN_MILLISECOND = 1000;
    private final Beeline beeline;
    private final BeelineProperties properties;

    public BraveBeelineReporter(Beeline beeline, BeelineProperties properties) {
        this.beeline = beeline;
        this.properties = properties;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public void report(Span span) {
        try (io.honeycomb.beeline.tracing.Span hcRootSpan = this.transformBraveSpanToHoneycombSpan(span);){
            this.adaptBraveModelToHoneycombModel(span, hcRootSpan);
        }
    }

    private void adaptBraveModelToHoneycombModel(Span span, io.honeycomb.beeline.tracing.Span hcRootSpan) {
        this.adaptBraveAnnotationToHoneycombSpanEvent(span, hcRootSpan);
        ExtraFieldPropagation.getAll().forEach((arg_0, arg_1) -> ((io.honeycomb.beeline.tracing.Span)hcRootSpan).addField(arg_0, arg_1));
        span.tags().forEach((arg_0, arg_1) -> ((io.honeycomb.beeline.tracing.Span)hcRootSpan).addField(arg_0, arg_1));
    }

    private void adaptBraveAnnotationToHoneycombSpanEvent(Span span, io.honeycomb.beeline.tracing.Span hcRootSpan) {
        SpanBuilderFactory.SpanBuilder spanBuilder = this.beeline.getSpanBuilderFactory().createBuilderFromParent(hcRootSpan);
        if (spanBuilder.getProcessor().runSamplerHook(hcRootSpan) <= 0) {
            return;
        }
        span.annotations().forEach(annotation -> {
            spanBuilder.setSpanName(annotation.value());
            Event event = spanBuilder.getProcessor().generateSpanEvent(spanBuilder.build());
            event.setTimestamp(annotation.timestamp());
            event.sendPresampled();
        });
    }

    private io.honeycomb.beeline.tracing.Span transformBraveSpanToHoneycombSpan(Span span) {
        PropagationContext propagationContext = new PropagationContext(span.traceId(), span.parentId(), null, null);
        TracerSpan hcRootSpan = this.beeline.getTracer().startTrace(this.beeline.getSpanBuilderFactory().createBuilder().setSpanName(span.name()).setServiceName(this.properties.getServiceName()).setParentContext(propagationContext).setSpanId(span.id()).build());
        Long startTimestamp = span.timestamp();
        if (startTimestamp != null && startTimestamp > 0L) {
            hcRootSpan.markStart(startTimestamp / (long)MICROS_IN_MILLISECOND.shortValue(), startTimestamp / (long)MICROS_IN_MILLISECOND.shortValue());
        }
        if (span.durationAsLong() > 0L) {
            hcRootSpan.setDuration((double)span.durationAsLong() / (double)MICROS_IN_MILLISECOND.shortValue());
        }
        return hcRootSpan;
    }
}

