/*
 * Decompiled with CFR 0.152.
 */
package sparkz.util.serialization;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import sparkz.util.encode.ZigZagEncoder$;
import sparkz.util.serialization.Writer;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001daa\u0002\u0007\u000e!\u0003\r\t\u0001\u0006\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006I\u00011\t!\n\u0005\u0006Y\u0001!\t%\f\u0005\u0006q\u0001!\t%\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006\u0007\u0002!\t\u0005\u0012\u0005\u0006\u0015\u0002!\te\u0013\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006%\u0002!\te\u0015\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006i\u0002!\t%\u001e\u0002\n-2\u000bvK]5uKJT!AD\b\u0002\u001bM,'/[1mSj\fG/[8o\u0015\t\u0001\u0012#\u0001\u0003vi&d'\"\u0001\n\u0002\rM\u0004\u0018M]6{\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011A$H\u0007\u0002\u001b%\u0011a$\u0004\u0002\u0007/JLG/\u001a:\u0002\r\u0011Jg.\u001b;%)\u0005\t\u0003C\u0001\f#\u0013\t\u0019sC\u0001\u0003V]&$\u0018a\u0002;p\u0005f$Xm]\u000b\u0002MA\u0019acJ\u0015\n\u0005!:\"!B!se\u0006L\bC\u0001\f+\u0013\tYsC\u0001\u0003CsR,\u0017\u0001\u00039viNCwN\u001d;\u0015\u00059zS\"\u0001\u0001\t\u000bA\u001a\u0001\u0019A\u0019\u0002\u0003a\u0004\"A\u0006\u001a\n\u0005M:\"!B*i_J$\bFA\u00026!\t1b'\u0003\u00028/\t1\u0011N\u001c7j]\u0016\f\u0011\u0002];u+NCwN\u001d;\u0015\u00059R\u0004\"\u0002\u0019\u0005\u0001\u0004Y\u0004C\u0001\f=\u0013\titCA\u0002J]RD#\u0001B\u001b\u0002\rA,H/\u00138u)\tq\u0013\tC\u00031\u000b\u0001\u00071\b\u000b\u0002\u0006k\u00059\u0001/\u001e;V\u0013:$HC\u0001\u0018F\u0011\u0015\u0001d\u00011\u0001G!\t1r)\u0003\u0002I/\t!Aj\u001c8hQ\t1Q'A\u0004qkRduN\\4\u0015\u00059b\u0005\"\u0002\u0019\b\u0001\u00041\u0005FA\u00046\u0003!\u0001X\u000f^+M_:<GC\u0001\u0018Q\u0011\u0015\u0001\u0004\u00021\u0001GQ\tAQ'A\u0004qkR\u0014\u0015\u000e^:\u0015\u00059\"\u0006\"B+\n\u0001\u00041\u0016A\u0001=t!\r1re\u0016\t\u0003-aK!!W\f\u0003\u000f\t{w\u000e\\3b]\"\u0012\u0011\"N\u0001\naV$x\n\u001d;j_:,\"!\u00184\u0015\u0005y{GC\u0001\u0018`\u0011\u0015\u0001'\u00021\u0001b\u0003!\u0001X\u000f\u001e,bYV,\u0007#\u0002\fc]\u0011\f\u0013BA2\u0018\u0005%1UO\\2uS>t'\u0007\u0005\u0002fM2\u0001A!B4\u000b\u0005\u0004A'!\u0001+\u0012\u0005%d\u0007C\u0001\fk\u0013\tYwCA\u0004O_RD\u0017N\\4\u0011\u0005Yi\u0017B\u00018\u0018\u0005\r\te.\u001f\u0005\u0006a)\u0001\r\u0001\u001d\t\u0004-E$\u0017B\u0001:\u0018\u0005\u0019y\u0005\u000f^5p]\"\u0012!\"N\u0001\u000faV$8\u000b[8siN#(/\u001b8h)\tqc\u000fC\u0003x\u0017\u0001\u0007\u00010A\u0001t!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a_\f\u000e\u0003qT!!`\n\u0002\rq\u0012xn\u001c;?\u0013\tyx#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f^\u0001")
public interface VLQWriter
extends Writer {
    public byte[] toBytes();

    public static /* synthetic */ VLQWriter putShort$(VLQWriter $this, short x) {
        return $this.putShort(x);
    }

    @Override
    default public VLQWriter putShort(short x) {
        return this.putULong(ZigZagEncoder$.MODULE$.encodeZigZagInt(x));
    }

    public static /* synthetic */ VLQWriter putUShort$(VLQWriter $this, int x) {
        return $this.putUShort(x);
    }

    @Override
    default public VLQWriter putUShort(int x) {
        Predef$.MODULE$.require(x >= 0 && x <= 65535, (Function0 & Serializable)() -> new StringBuilder(37).append("Value ").append(x).append(" is out of unsigned short range").toString());
        return this.putUInt(x);
    }

    public static /* synthetic */ VLQWriter putInt$(VLQWriter $this, int x) {
        return $this.putInt(x);
    }

    @Override
    default public VLQWriter putInt(int x) {
        return this.putULong(ZigZagEncoder$.MODULE$.encodeZigZagInt(x));
    }

    public static /* synthetic */ VLQWriter putUInt$(VLQWriter $this, long x) {
        return $this.putUInt(x);
    }

    @Override
    default public VLQWriter putUInt(long x) {
        Predef$.MODULE$.require(x >= 0L && x <= 0xFFFFFFFFL, (Function0 & Serializable)() -> new StringBuilder(29).append(x).append(" is out of unsigned int range").toString());
        return this.putULong(x);
    }

    public static /* synthetic */ VLQWriter putLong$(VLQWriter $this, long x) {
        return $this.putLong(x);
    }

    @Override
    default public VLQWriter putLong(long x) {
        return this.putULong(ZigZagEncoder$.MODULE$.encodeZigZagLong(x));
    }

    public static /* synthetic */ VLQWriter putULong$(VLQWriter $this, long x) {
        return $this.putULong(x);
    }

    @Override
    default public VLQWriter putULong(long x) {
        byte[] buffer = new byte[10];
        int position = 0;
        long value = x;
        while (true) {
            if ((value & (0x7FL ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
                buffer[position] = (byte)value;
                this.putBytes(buffer, 0, ++position);
                return this;
            }
            buffer[position] = (byte)((int)value & 0x7F | 0x80);
            ++position;
            value >>>= 7;
        }
    }

    public static /* synthetic */ VLQWriter putBits$(VLQWriter $this, boolean[] xs) {
        return $this.putBits(xs);
    }

    @Override
    default public VLQWriter putBits(boolean[] xs) {
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.booleanArrayOps(xs))) {
            return this;
        }
        int len = xs.length;
        BitSet bitSet = new BitSet(len);
        for (int i = 0; i < len; ++i) {
            boolean bool = xs[i];
            bitSet.set(i, bool);
        }
        byte[] bytes = Arrays.copyOf(bitSet.toByteArray(), xs.length + 7 >> 3);
        this.putBytes(bytes);
        return this;
    }

    public static /* synthetic */ VLQWriter putOption$(VLQWriter $this, Option x, Function2 putValue) {
        return $this.putOption((Option<T>)x, (Function2<VLQWriter, T, BoxedUnit>)putValue);
    }

    default public <T> VLQWriter putOption(Option<T> x, Function2<VLQWriter, T, BoxedUnit> putValue) {
        Object object;
        Option<T> option = x;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            this.put((byte)1);
            object = putValue.apply((Object)this, v);
        } else if (None$.MODULE$.equals(option)) {
            object = this.put((byte)0);
        } else {
            throw new MatchError(option);
        }
        return this;
    }

    public static /* synthetic */ VLQWriter putShortString$(VLQWriter $this, String s) {
        return $this.putShortString(s);
    }

    @Override
    default public VLQWriter putShortString(String s) {
        byte[] bytes = s.getBytes();
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)) < 256);
        this.putUByte((byte)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bytes)));
        this.putBytes(bytes);
        return this;
    }

    public static void $init$(VLQWriter $this) {
    }
}

