/*
Copyright 2021 Fausto Spoto

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package io.hotmoka.node.tendermint.internal.beans;

/**
 * A bean corresponding to the response of a query
 * about a transaction.
 */
public class TendermintTxResponse {

	/**
	 * Creates the bean.
	 */
	public TendermintTxResponse() {}

	/**
	 * The version of the protocol.
	 */
	public String jsonrpc;

	/**
	 * The id of the message.
	 */
	public long id;

	/**
	 * The result of the query, if any.
	 */
	public TendermintTopLevelResult result;

	/**
	 * An error result, if any.
	 */
	public Object error;
}