/*
Copyright 2021 Fausto Spoto

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package io.hotmoka.node.tendermint.internal.beans;

/**
 * A bean corresponding to the result of a query about the
 * priority of a validator a Tendermint node.
 */
public class TendermintValidatorPriority {

	/**
	 * Creates the bean.
	 */
	public TendermintValidatorPriority() {}

	/**
	 * The Tendermint address of the validator.
	 */
	public String address;

	/**
	 * The public key of the validator.
	 */
	public TendermintPubKey pub_key;

	/**
	 * The power of the validator.
	 */
	public long voting_power;
}