/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node;

import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.crypto.SignatureAlgorithms;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;

public final class SignatureAlgorithmForTransactionRequests {
    private SignatureAlgorithmForTransactionRequests() {
    }

    public static SignatureAlgorithm<SignedTransactionRequest> sha256dsa() throws NoSuchAlgorithmException {
        return SignatureAlgorithms.sha256dsa(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> ed25519() throws NoSuchAlgorithmException {
        return SignatureAlgorithms.ed25519(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> ed25519det() throws NoSuchAlgorithmException {
        return SignatureAlgorithms.ed25519det(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> qtesla1() throws NoSuchAlgorithmException {
        return SignatureAlgorithms.qtesla1(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> qtesla3() throws NoSuchAlgorithmException {
        return SignatureAlgorithms.qtesla3(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> empty() {
        return SignatureAlgorithms.empty(SignedTransactionRequest::toByteArrayWithoutSignature);
    }

    public static SignatureAlgorithm<SignedTransactionRequest> of(String name) throws NoSuchAlgorithmException {
        name = name.toLowerCase();
        try {
            Method method = SignatureAlgorithmForTransactionRequests.class.getMethod(name, new Class[0]);
            return (SignatureAlgorithm)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NoSuchAlgorithmException("unknown signature algorithm named " + name, e);
        }
    }

    public static SignatureAlgorithm<SignedTransactionRequest> of(SignatureAlgorithms.TYPES type) throws NoSuchAlgorithmException {
        return SignatureAlgorithmForTransactionRequests.of(type.name());
    }
}

