/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.internal;

import io.hotmoka.beans.CodeExecutionException;
import io.hotmoka.beans.TransactionException;
import io.hotmoka.beans.TransactionRejectedException;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.responses.ConstructorCallTransactionResponse;
import io.hotmoka.beans.responses.JarStoreNonInitialTransactionResponse;
import io.hotmoka.beans.responses.MethodCallTransactionResponse;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.node.api.CodeSupplier;
import io.hotmoka.node.api.JarSupplier;
import io.hotmoka.node.api.Node;
import io.hotmoka.node.api.Subscription;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractNodeImpl
implements Node {
    protected static final Logger logger = Logger.getLogger(Node.class.getName());
    private final Map<StorageReference, Set<SubscriptionImpl>> subscriptions;

    protected AbstractNodeImpl() {
        this.subscriptions = new HashMap<StorageReference, Set<SubscriptionImpl>>();
    }

    protected AbstractNodeImpl(AbstractNodeImpl parent) {
        this.subscriptions = parent.subscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Subscription subscribeToEvents(StorageReference creator, BiConsumer<StorageReference, StorageReference> handler) throws UnsupportedOperationException {
        if (handler == null) {
            throw new NullPointerException("the handler cannot be null");
        }
        SubscriptionImpl subscription = new SubscriptionImpl(creator, handler);
        Map<StorageReference, Set<SubscriptionImpl>> map = this.subscriptions;
        synchronized (map) {
            this.subscriptions.computeIfAbsent(creator, __ -> new HashSet()).add(subscription);
        }
        return subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyEvent(StorageReference creator, StorageReference event) {
        Map<StorageReference, Set<SubscriptionImpl>> map = this.subscriptions;
        synchronized (map) {
            Set<SubscriptionImpl> subscriptionsPerKey = this.subscriptions.get(creator);
            if (subscriptionsPerKey != null) {
                subscriptionsPerKey.forEach(subscription -> subscription.accept(creator, event));
            }
            if ((subscriptionsPerKey = this.subscriptions.get(null)) != null) {
                subscriptionsPerKey.forEach(subscription -> subscription.accept(creator, event));
            }
        }
        logger.info(String.valueOf(event) + ": notified as event with creator " + String.valueOf(creator));
    }

    protected final JarSupplier jarSupplierFor(TransactionReference reference) {
        return AbstractNodeImpl.jarSupplierFor(reference, () -> ((JarStoreNonInitialTransactionResponse)this.getPolledResponse(reference)).getOutcomeAt(reference));
    }

    protected final CodeSupplier<StorageReference> constructorSupplierFor(TransactionReference reference) {
        return AbstractNodeImpl.codeSupplierFor(reference, () -> ((ConstructorCallTransactionResponse)this.getPolledResponse(reference)).getOutcome());
    }

    protected final CodeSupplier<StorageValue> methodSupplierFor(TransactionReference reference) {
        return AbstractNodeImpl.codeSupplierFor(reference, () -> ((MethodCallTransactionResponse)this.getPolledResponse(reference)).getOutcome());
    }

    protected static <T> T wrapInCaseOfExceptionSimple(Callable<T> what) throws TransactionRejectedException {
        try {
            return what.call();
        }
        catch (TransactionRejectedException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "unexpected exception", t);
            throw new TransactionRejectedException(t);
        }
    }

    protected static <T> T wrapInCaseOfExceptionMedium(Callable<T> what) throws TransactionRejectedException, TransactionException {
        try {
            return what.call();
        }
        catch (TransactionException | TransactionRejectedException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "unexpected exception", t);
            throw new TransactionRejectedException(t);
        }
    }

    protected static <T> T wrapInCaseOfExceptionFull(Callable<T> what) throws TransactionRejectedException, TransactionException, CodeExecutionException {
        try {
            return what.call();
        }
        catch (CodeExecutionException | TransactionException | TransactionRejectedException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "unexpected exception", t);
            throw new TransactionRejectedException(t);
        }
    }

    private static JarSupplier jarSupplierFor(final TransactionReference reference, final Callable<TransactionReference> task) {
        return new JarSupplier(){
            private volatile TransactionReference cachedGet;

            public TransactionReference getReferenceOfRequest() {
                return reference;
            }

            public TransactionReference get() throws TransactionRejectedException, TransactionException {
                return this.cachedGet != null ? this.cachedGet : (this.cachedGet = (TransactionReference)AbstractNodeImpl.wrapInCaseOfExceptionMedium(task));
            }
        };
    }

    private static <W extends StorageValue> CodeSupplier<W> codeSupplierFor(final TransactionReference reference, final Callable<W> task) {
        return new CodeSupplier<W>(){
            private volatile W cachedGet;

            public TransactionReference getReferenceOfRequest() {
                return reference;
            }

            public W get() throws TransactionRejectedException, TransactionException, CodeExecutionException {
                return this.cachedGet != null ? this.cachedGet : (this.cachedGet = (StorageValue)AbstractNodeImpl.wrapInCaseOfExceptionFull(task));
            }
        };
    }

    private class SubscriptionImpl
    implements Subscription,
    BiConsumer<StorageReference, StorageReference> {
        private final StorageReference key;
        private final BiConsumer<StorageReference, StorageReference> handler;

        private SubscriptionImpl(StorageReference key, BiConsumer<StorageReference, StorageReference> handler) {
            this.key = key;
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Map<StorageReference, Set<SubscriptionImpl>> map = AbstractNodeImpl.this.subscriptions;
            synchronized (map) {
                Set<SubscriptionImpl> subscriptionsForKey = AbstractNodeImpl.this.subscriptions.get(this.key);
                if (subscriptionsForKey != null && subscriptionsForKey.remove(this) && subscriptionsForKey.isEmpty()) {
                    AbstractNodeImpl.this.subscriptions.remove(this.key);
                }
            }
        }

        @Override
        public void accept(StorageReference key, StorageReference event) {
            this.handler.accept(key, event);
        }
    }
}

