/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.internal;

import io.hotmoka.beans.references.LocalTransactionReference;
import io.hotmoka.beans.references.TransactionReference;
import io.hotmoka.beans.values.StorageReference;
import io.hotmoka.beans.values.StorageValue;
import io.hotmoka.crypto.AbstractAccount;
import io.hotmoka.crypto.api.Entropy;
import io.hotmoka.node.api.Account;
import java.io.IOException;
import java.math.BigInteger;

public class AccountImpl
extends AbstractAccount<StorageReference>
implements Account {
    public AccountImpl(Entropy entropy, StorageReference reference) {
        super(entropy, (Comparable)reference);
        if (reference.progressive.signum() != 0) {
            throw new IllegalArgumentException("accounts are limited to have 0 as progressive index");
        }
    }

    public AccountImpl(StorageReference reference) throws IOException {
        super((Comparable)reference);
        if (reference.progressive.signum() != 0) {
            throw new IllegalArgumentException("accounts are limited to have 0 as progressive index");
        }
    }

    public AccountImpl(StorageReference reference, String dir) throws IOException {
        super((Comparable)reference, dir);
        if (reference.progressive.signum() != 0) {
            throw new IllegalArgumentException("accounts are limited to have 0 as progressive index");
        }
    }

    public AccountImpl(String reference) throws IOException {
        this(new StorageReference(reference));
    }

    public AccountImpl(String reference, String dir) throws IOException {
        this(new StorageReference(reference), dir);
    }

    public AccountImpl(Entropy entropy, byte[] reference) {
        this(entropy, new StorageReference((TransactionReference)new LocalTransactionReference(reference), BigInteger.ZERO));
    }

    public int compareTo(Entropy other) {
        int diff = super.compareTo(other);
        if (diff != 0) {
            return diff;
        }
        return ((StorageReference)this.reference).compareTo((StorageValue)((AccountImpl)other).reference);
    }

    public byte[] getReferenceAsBytes() {
        return ((StorageReference)this.reference).transaction.getHashAsBytes();
    }
}

