/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.internal;

import com.moandjiezana.toml.Toml;
import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.node.SignatureAlgorithmForTransactionRequests;
import io.hotmoka.node.api.ConsensusConfig;
import io.hotmoka.node.api.ConsensusConfigBuilder;
import java.io.FileNotFoundException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public abstract class ConsensusConfigImpl
implements ConsensusConfig {
    public final LocalDateTime genesisTime;
    public final String chainId;
    public final long maxErrorLength;
    public final long maxDependencies;
    public final long maxCumulativeSizeOfDependencies;
    public final boolean allowsSelfCharged;
    public final boolean allowsUnsignedFaucet;
    public final boolean allowsMintBurnFromGamete;
    public final boolean skipsVerification;
    public final String publicKeyOfGamete;
    public final BigInteger initialGasPrice;
    public final BigInteger maxGasPerTransaction;
    public final boolean ignoresGasPrice;
    public final BigInteger targetGasAtReward;
    public final long oblivion;
    public final long initialInflation;
    public final long verificationVersion;
    public final BigInteger initialSupply;
    public final BigInteger finalSupply;
    public final BigInteger initialRedSupply;
    public final BigInteger ticketForNewPoll;
    public final SignatureAlgorithm<SignedTransactionRequest> signature;

    public ConsensusConfigImpl(ConsensusConfigBuilderImpl<?> builder) {
        this.genesisTime = builder.genesisTime;
        this.chainId = builder.chainId;
        this.maxErrorLength = builder.maxErrorLength;
        this.maxDependencies = builder.maxDependencies;
        this.maxCumulativeSizeOfDependencies = builder.maxCumulativeSizeOfDependencies;
        this.allowsSelfCharged = builder.allowsSelfCharged;
        this.allowsUnsignedFaucet = builder.allowsUnsignedFaucet;
        this.allowsMintBurnFromGamete = builder.allowsMintBurnFromGamete;
        this.initialGasPrice = builder.initialGasPrice;
        this.maxGasPerTransaction = builder.maxGasPerTransaction;
        this.ignoresGasPrice = builder.ignoresGasPrice;
        this.skipsVerification = builder.skipsVerification;
        this.targetGasAtReward = builder.targetGasAtReward;
        this.oblivion = builder.oblivion;
        this.initialInflation = builder.initialInflation;
        this.verificationVersion = builder.verificationVersion;
        this.ticketForNewPoll = builder.ticketForNewPoll;
        this.initialSupply = builder.initialSupply;
        this.finalSupply = builder.finalSupply;
        this.initialRedSupply = builder.initialRedSupply;
        this.publicKeyOfGamete = builder.publicKeyOfGamete;
        this.signature = builder.signature;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            ConsensusConfigImpl otherConfig = (ConsensusConfigImpl)other;
            return this.genesisTime.equals(otherConfig.genesisTime) && this.chainId.equals(otherConfig.chainId) && this.maxErrorLength == otherConfig.maxErrorLength && this.maxDependencies == otherConfig.maxDependencies && this.maxCumulativeSizeOfDependencies == otherConfig.maxCumulativeSizeOfDependencies && this.allowsSelfCharged == otherConfig.allowsSelfCharged && this.allowsUnsignedFaucet == otherConfig.allowsUnsignedFaucet && this.allowsMintBurnFromGamete == otherConfig.allowsMintBurnFromGamete && this.initialGasPrice.equals(otherConfig.initialGasPrice) && this.maxGasPerTransaction.equals(otherConfig.maxGasPerTransaction) && this.ignoresGasPrice == otherConfig.ignoresGasPrice && this.skipsVerification == otherConfig.skipsVerification && this.targetGasAtReward.equals(otherConfig.targetGasAtReward) && this.oblivion == otherConfig.oblivion && this.initialInflation == otherConfig.initialInflation && this.verificationVersion == otherConfig.verificationVersion && this.ticketForNewPoll.equals(otherConfig.ticketForNewPoll) && this.initialSupply.equals(otherConfig.initialSupply) && this.finalSupply.equals(otherConfig.finalSupply) && this.initialRedSupply.equals(otherConfig.initialRedSupply) && this.publicKeyOfGamete.equals(otherConfig.publicKeyOfGamete) && this.signature.getName().equals(otherConfig.signature.getName());
        }
        return false;
    }

    public String toString() {
        return this.toToml();
    }

    public String toToml() {
        StringBuilder sb = new StringBuilder();
        sb.append("# This is a TOML config file for the consensus of a Hotmoka network.\n");
        sb.append("# For more information about TOML, see https://github.com/toml-lang/toml\n");
        sb.append("# For more information about Hotmoka, see https://www.hotmoka.io\n");
        sb.append("\n");
        sb.append("# the genesis time, UTC, in ISO8601 format\n");
        sb.append("genesis_time = \"" + String.valueOf(this.genesisTime) + "\"\n");
        sb.append("\n");
        sb.append("# the chain identifier of the node\n");
        sb.append("chain_id = \"" + this.chainId + "\"\n");
        sb.append("\n");
        sb.append("# the maximal length of the error message kept in the store of the node\n");
        sb.append("max_error_length = " + this.maxErrorLength + "\n");
        sb.append("\n");
        sb.append("# the maximal number of dependencies in the classpath of a transaction\n");
        sb.append("max_dependencies = " + this.maxDependencies + "\n");
        sb.append("\n");
        sb.append("# the maximal cumulative size (in bytes) of the instrumented jars\n");
        sb.append("# of the dependencies of a transaction\n");
        sb.append("max_cumulative_size_of_dependencies = " + this.maxCumulativeSizeOfDependencies + "\n");
        sb.append("\n");
        sb.append("# true if and only if the use of the @SelfCharged annotation is allowed\n");
        sb.append("allows_self_charged = " + this.allowsSelfCharged + "\n");
        sb.append("\n");
        sb.append("# true if and only if the use of the faucet of the gamete is allowed without a valid signature\n");
        sb.append("allows_unsigned_faucet = " + this.allowsUnsignedFaucet + "\n");
        sb.append("\n");
        sb.append("# true if and only if the gamete of the node can call, for free, the add method of the accounts ledger\n");
        sb.append("# and the mint/burn methods of the accounts, without paying gas and without paying for the minted coins\n");
        sb.append("allows_mint_burn_from_gamete = " + this.allowsMintBurnFromGamete + "\n");
        sb.append("\n");
        sb.append("# true if and only if the static verification of the classes of the jars installed in the node must be skipped\n");
        sb.append("skips_verification = " + this.skipsVerification + "\n");
        sb.append("\n");
        sb.append("# the Base64-encoded public key of the gamete account\n");
        sb.append("public_key_of_gamete = \"" + this.publicKeyOfGamete + "\"\n");
        sb.append("\n");
        sb.append("# the initial gas price\n");
        sb.append("initial_gas_price = \"" + String.valueOf(this.initialGasPrice) + "\"\n");
        sb.append("\n");
        sb.append("# the maximal amount of gas that a non-view transaction can consume\n");
        sb.append("max_gas_per_transaction = \"" + String.valueOf(this.maxGasPerTransaction) + "\"\n");
        sb.append("\n");
        sb.append("# true if and only if the node ignores the minimum gas price;\n");
        sb.append("# hence requests that specify a lower gas price than the current gas price of the node are executed anyway;\n");
        sb.append("# this is mainly useful for testing\n");
        sb.append("ignores_gas_price = " + this.ignoresGasPrice + "\n");
        sb.append("\n");
        sb.append("# the units of gas that are aimed to be rewarded at each reward;\n");
        sb.append("# if the actual reward is smaller, the price of gas must decrease;\n");
        sb.append("# if it is larger, the price of gas must increase\n");
        sb.append("target_gas_at_reward = \"" + String.valueOf(this.targetGasAtReward) + "\"\n");
        sb.append("\n");
        sb.append("# how quick the gas consumed at previous rewards is forgotten:\n");
        sb.append("# 0 means never, 1000000 means immediately;\n");
        sb.append("# hence a smaller level means that the latest rewards are heavier\n");
        sb.append("# in the determination of the gas price;\n");
        sb.append("# a value of 0 means that the gas price is constant\n");
        sb.append("oblivion = " + this.oblivion + "\n");
        sb.append("\n");
        sb.append("# the initial inflation applied to the gas consumed by transactions\n");
        sb.append("# before it gets sent as reward to the validators. 1000000 means 1%;\n");
        sb.append("# inflation can be negative. For instance, -300,000 means -0.3%\n");
        sb.append("initial_inflation = " + this.initialInflation + "\n");
        sb.append("\n");
        sb.append("# the version of the verification module to use\n");
        sb.append("verification_version = " + this.verificationVersion + "\n");
        sb.append("\n");
        sb.append("# the initial supply of coins in the node\n");
        sb.append("initial_supply = \"" + String.valueOf(this.initialSupply) + "\"\n");
        sb.append("\n");
        sb.append("# the final supply of coins in the node; once the current supply reaches\n");
        sb.append("# this final amount, it remains constant\n");
        sb.append("final_supply = \"" + String.valueOf(this.finalSupply) + "\"\n");
        sb.append("\n");
        sb.append("# the initial supply of red coins in the node\n");
        sb.append("initial_red_supply = \"" + String.valueOf(this.initialRedSupply) + "\"\n");
        sb.append("\n");
        sb.append("# the amount of coin to pay to start a new poll amount the validators,\n");
        sb.append("# for instance in order to change a consensus parameter\n");
        sb.append("ticket_for_new_poll = \"" + String.valueOf(this.ticketForNewPoll) + "\"\n");
        sb.append("\n");
        sb.append("# the name of the signature algorithm for signing requests\n");
        sb.append("signature = \"" + this.signature.getName() + "\"\n");
        return sb.toString();
    }

    public LocalDateTime getGenesisTime() {
        return this.genesisTime;
    }

    public String getChainId() {
        return this.chainId;
    }

    public long getMaxErrorLength() {
        return this.maxErrorLength;
    }

    public long getMaxDependencies() {
        return this.maxDependencies;
    }

    public long getMaxCumulativeSizeOfDependencies() {
        return this.maxCumulativeSizeOfDependencies;
    }

    public boolean allowsSelfCharged() {
        return this.allowsSelfCharged;
    }

    public boolean allowsUnsignedFaucet() {
        return this.allowsUnsignedFaucet;
    }

    public boolean allowsMintBurnFromGamete() {
        return this.allowsMintBurnFromGamete;
    }

    public boolean skipsVerification() {
        return this.skipsVerification;
    }

    public String getPublicKeyOfGamete() {
        return this.publicKeyOfGamete;
    }

    public BigInteger getInitialGasPrice() {
        return this.initialGasPrice;
    }

    public BigInteger getMaxGasPerTransaction() {
        return this.maxGasPerTransaction;
    }

    public boolean ignoresGasPrice() {
        return this.ignoresGasPrice;
    }

    public BigInteger getTargetGasAtReward() {
        return this.targetGasAtReward;
    }

    public long getOblivion() {
        return this.oblivion;
    }

    public long getInitialInflation() {
        return this.initialInflation;
    }

    public long getVerificationVersion() {
        return this.verificationVersion;
    }

    public BigInteger getInitialSupply() {
        return this.initialSupply;
    }

    public BigInteger getFinalSupply() {
        return this.finalSupply;
    }

    public BigInteger getInitialRedSupply() {
        return this.initialRedSupply;
    }

    public BigInteger getTicketForNewPoll() {
        return this.ticketForNewPoll;
    }

    public SignatureAlgorithm<SignedTransactionRequest> getSignature() {
        return this.signature;
    }

    protected <T extends ConsensusConfigBuilder<T>> T fill(T builder) {
        return (T)builder.setChainId(this.chainId).setGenesisTime(this.genesisTime).setMaxErrorLength(this.maxErrorLength).setMaxDependencies(this.maxDependencies).setMaxCumulativeSizeOfDependencies(this.maxCumulativeSizeOfDependencies).allowSelfCharged(this.allowsSelfCharged).allowUnsignedFaucet(this.allowsUnsignedFaucet).allowMintBurnFromGamete(this.allowsMintBurnFromGamete).signRequestsWith(this.signature).setMaxGasPerTransaction(this.maxGasPerTransaction).setInitialGasPrice(this.initialGasPrice).ignoreGasPrice(this.ignoresGasPrice).skipVerification(this.skipsVerification).setTargetGasAtReward(this.targetGasAtReward).setOblivion(this.oblivion).setInitialInflation(this.initialInflation).setVerificationVersion(this.verificationVersion).setInitialSupply(this.initialSupply).setFinalSupply(this.finalSupply).setInitialRedSupply(this.initialRedSupply).setPublicKeyOfGamete(this.publicKeyOfGamete).setTicketForNewPoll(this.ticketForNewPoll);
    }

    public static abstract class ConsensusConfigBuilderImpl<T extends ConsensusConfigBuilder<T>>
    implements ConsensusConfigBuilder<T> {
        private String chainId = "";
        private LocalDateTime genesisTime = LocalDateTime.now(ZoneId.of("UTC"));
        private long maxErrorLength = 300L;
        private boolean allowsSelfCharged = false;
        private boolean allowsUnsignedFaucet = false;
        private boolean allowsMintBurnFromGamete = false;
        private SignatureAlgorithm<SignedTransactionRequest> signature;
        private BigInteger maxGasPerTransaction = BigInteger.valueOf(1000000000L);
        private long maxDependencies = 20L;
        private long maxCumulativeSizeOfDependencies = 10000000L;
        private BigInteger initialGasPrice = BigInteger.valueOf(100L);
        private boolean ignoresGasPrice = false;
        private boolean skipsVerification = false;
        private BigInteger targetGasAtReward = BigInteger.valueOf(1000000L);
        private long oblivion = 250000L;
        private long initialInflation = 100000L;
        private long verificationVersion = 0L;
        private BigInteger initialSupply = BigInteger.ZERO;
        private BigInteger finalSupply = BigInteger.ZERO;
        private BigInteger initialRedSupply = BigInteger.ZERO;
        private String publicKeyOfGamete = "";
        private BigInteger ticketForNewPoll = BigInteger.valueOf(100L);

        protected ConsensusConfigBuilderImpl() throws NoSuchAlgorithmException {
            this(SignatureAlgorithmForTransactionRequests.ed25519());
        }

        protected ConsensusConfigBuilderImpl(SignatureAlgorithm<SignedTransactionRequest> signature) {
            this.signature = signature;
        }

        protected ConsensusConfigBuilderImpl(Toml toml) throws NoSuchAlgorithmException {
            String publicKeyOfGamete;
            String ticketForNewPoll;
            String initialRedSupply;
            String finalSupply;
            String initialSupply;
            Long verificationVersion;
            Long initialInflation;
            Long oblivion;
            String targetGasAtReward;
            Boolean skipsVerification;
            Boolean ignoresGasPrice;
            String initialGasPrice;
            String maxGasPerTransaction;
            String signature;
            Boolean allowsMintBurnFromGamete;
            Boolean allowsUnsignedFaucet;
            Boolean allowsSelfCharged;
            Long maxCumulativeSizeOfDependencies;
            Long maxDependencies;
            Long maxErrorLength;
            String chainId;
            String genesisTime = toml.getString("genesis_time");
            if (genesisTime != null) {
                this.setGenesisTime(LocalDateTime.parse(genesisTime, DateTimeFormatter.ISO_DATE_TIME));
            }
            if ((chainId = toml.getString("chain_id")) != null) {
                this.setChainId(chainId);
            }
            if ((maxErrorLength = toml.getLong("max_error_length")) != null) {
                this.setMaxErrorLength(maxErrorLength);
            }
            if ((maxDependencies = toml.getLong("max_dependencies")) != null) {
                this.setMaxDependencies(maxDependencies);
            }
            if ((maxCumulativeSizeOfDependencies = toml.getLong("max_cumulative_size_of_dependencies")) != null) {
                this.setMaxCumulativeSizeOfDependencies(maxCumulativeSizeOfDependencies);
            }
            if ((allowsSelfCharged = toml.getBoolean("allows_self_charged")) != null) {
                this.allowSelfCharged(allowsSelfCharged);
            }
            if ((allowsUnsignedFaucet = toml.getBoolean("allows_unsigned_faucet")) != null) {
                this.allowUnsignedFaucet(allowsUnsignedFaucet);
            }
            if ((allowsMintBurnFromGamete = toml.getBoolean("allows_mint_burn_from_gamete")) != null) {
                this.allowMintBurnFromGamete(allowsMintBurnFromGamete);
            }
            if ((signature = toml.getString("signature")) != null) {
                this.signRequestsWith(SignatureAlgorithmForTransactionRequests.of(signature));
            }
            if ((maxGasPerTransaction = toml.getString("max_gas_per_transaction")) != null) {
                this.setMaxGasPerTransaction(new BigInteger(maxGasPerTransaction));
            }
            if ((initialGasPrice = toml.getString("initial_gas_price")) != null) {
                this.setInitialGasPrice(new BigInteger(initialGasPrice));
            }
            if ((ignoresGasPrice = toml.getBoolean("ignores_gas_price")) != null) {
                this.ignoreGasPrice(ignoresGasPrice);
            }
            if ((skipsVerification = toml.getBoolean("skips_verification")) != null) {
                this.skipVerification(skipsVerification);
            }
            if ((targetGasAtReward = toml.getString("target_gas_at_reward")) != null) {
                this.setTargetGasAtReward(new BigInteger(targetGasAtReward));
            }
            if ((oblivion = toml.getLong("oblivion")) != null) {
                this.setOblivion(oblivion);
            }
            if ((initialInflation = toml.getLong("initial_inflation")) != null) {
                this.setInitialInflation(initialInflation);
            }
            if ((verificationVersion = toml.getLong("verification_version")) != null) {
                this.setVerificationVersion(verificationVersion);
            }
            if ((initialSupply = toml.getString("initial_supply")) != null) {
                this.setInitialSupply(new BigInteger(initialSupply));
            }
            if ((finalSupply = toml.getString("final_supply")) != null) {
                this.setFinalSupply(new BigInteger(finalSupply));
            }
            if ((initialRedSupply = toml.getString("initial_red_supply")) != null) {
                this.setInitialRedSupply(new BigInteger(initialRedSupply));
            }
            if ((ticketForNewPoll = toml.getString("ticket_for_new_poll")) != null) {
                this.setTicketForNewPoll(new BigInteger(ticketForNewPoll));
            }
            if ((publicKeyOfGamete = toml.getString("public_key_of_gamete")) != null) {
                this.setPublicKeyOfGamete(publicKeyOfGamete);
            }
        }

        public T setGenesisTime(LocalDateTime genesisTime) {
            this.genesisTime = genesisTime;
            return this.getThis();
        }

        public T setChainId(String chainId) {
            this.chainId = chainId;
            return this.getThis();
        }

        public T setMaxErrorLength(long maxErrorLength) {
            this.maxErrorLength = maxErrorLength;
            return this.getThis();
        }

        public T setMaxDependencies(long maxDependencies) {
            this.maxDependencies = maxDependencies;
            return this.getThis();
        }

        public T setMaxCumulativeSizeOfDependencies(long maxCumulativeSizeOfDependencies) {
            this.maxCumulativeSizeOfDependencies = maxCumulativeSizeOfDependencies;
            return this.getThis();
        }

        public T allowSelfCharged(boolean allowsSelfCharged) {
            this.allowsSelfCharged = allowsSelfCharged;
            return this.getThis();
        }

        public T allowUnsignedFaucet(boolean allowsUnsignedFaucet) {
            this.allowsUnsignedFaucet = allowsUnsignedFaucet;
            return this.getThis();
        }

        public T allowMintBurnFromGamete(boolean allowsMintBurnFromGamete) {
            this.allowsMintBurnFromGamete = allowsMintBurnFromGamete;
            return this.getThis();
        }

        public T signRequestsWith(SignatureAlgorithm<SignedTransactionRequest> signature) {
            if (signature == null) {
                throw new NullPointerException("the signature algorithm cannot be null");
            }
            this.signature = signature;
            return this.getThis();
        }

        public T setInitialGasPrice(BigInteger initialGasPrice) {
            if (initialGasPrice == null) {
                throw new NullPointerException("the initial gas price cannot be null");
            }
            if (initialGasPrice.signum() <= 0) {
                throw new IllegalArgumentException("the initial gas price must be positive");
            }
            this.initialGasPrice = initialGasPrice;
            return this.getThis();
        }

        public T setMaxGasPerTransaction(BigInteger maxGasPerTransaction) {
            if (maxGasPerTransaction == null) {
                throw new NullPointerException("the maximal amount of gas per transaction cannot be null");
            }
            if (maxGasPerTransaction.signum() <= 0) {
                throw new IllegalArgumentException("the maximal amount of gas per transaction must be positive");
            }
            this.maxGasPerTransaction = maxGasPerTransaction;
            return this.getThis();
        }

        public T setTargetGasAtReward(BigInteger targetGasAtReward) {
            if (targetGasAtReward == null) {
                throw new NullPointerException("the target gas at reward cannot be null");
            }
            if (targetGasAtReward.signum() <= 0) {
                throw new IllegalArgumentException("the target gas at reward must be positive");
            }
            this.targetGasAtReward = targetGasAtReward;
            return this.getThis();
        }

        public T setOblivion(long oblivion) {
            if (oblivion < 0L || oblivion > 1000000L) {
                throw new IllegalArgumentException("oblivion must be between 0 and 1_000_000");
            }
            this.oblivion = oblivion;
            return this.getThis();
        }

        public T setInitialInflation(long initialInflation) {
            this.initialInflation = initialInflation;
            return this.getThis();
        }

        public T ignoreGasPrice(boolean ignoresGasPrice) {
            this.ignoresGasPrice = ignoresGasPrice;
            return this.getThis();
        }

        public T skipVerification(boolean skipsVerification) {
            this.skipsVerification = skipsVerification;
            return this.getThis();
        }

        public T setVerificationVersion(long verificationVersion) {
            if (verificationVersion < 0L) {
                throw new IllegalArgumentException("the verification version must be non-negative");
            }
            this.verificationVersion = verificationVersion;
            return this.getThis();
        }

        public T setInitialSupply(BigInteger initialSupply) {
            if (initialSupply == null) {
                throw new NullPointerException("the initial supply cannot be null");
            }
            if (initialSupply.signum() < 0) {
                throw new IllegalArgumentException("the initial supply must be non-negative");
            }
            this.initialSupply = initialSupply;
            return this.getThis();
        }

        public T setInitialRedSupply(BigInteger initialRedSupply) {
            if (initialRedSupply == null) {
                throw new NullPointerException("the initial red supply cannot be null");
            }
            if (initialRedSupply.signum() < 0) {
                throw new IllegalArgumentException("the initial red supply must be non-negative");
            }
            this.initialRedSupply = initialRedSupply;
            return this.getThis();
        }

        public T setPublicKeyOfGamete(String publicKeyOfGamete) {
            if (publicKeyOfGamete == null) {
                throw new NullPointerException("the public key of the gamete cannot be null");
            }
            this.publicKeyOfGamete = publicKeyOfGamete;
            return this.getThis();
        }

        public T setFinalSupply(BigInteger finalSupply) {
            if (finalSupply == null) {
                throw new NullPointerException("the final supply cannot be null");
            }
            if (finalSupply.signum() < 0) {
                throw new IllegalArgumentException("the final supply must be non-negative");
            }
            this.finalSupply = finalSupply;
            return this.getThis();
        }

        public T setTicketForNewPoll(BigInteger ticketForNewPoll) {
            if (ticketForNewPoll == null) {
                throw new NullPointerException("the ticket for a new poll cannot be null");
            }
            if (ticketForNewPoll.signum() < 0) {
                throw new IllegalArgumentException("the ticket for new poll must be non-negative");
            }
            this.ticketForNewPoll = ticketForNewPoll;
            return this.getThis();
        }

        public abstract ConsensusConfig build();

        protected abstract T getThis();

        protected static Toml readToml(Path path) throws FileNotFoundException {
            try {
                return new Toml().read(path.toFile());
            }
            catch (RuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    throw (FileNotFoundException)cause;
                }
                throw e;
            }
        }
    }
}

