/*
 * Decompiled with CFR 0.152.
 */
package io.hotmoka.node.internal;

import com.moandjiezana.toml.Toml;
import io.hotmoka.beans.requests.SignedTransactionRequest;
import io.hotmoka.crypto.api.SignatureAlgorithm;
import io.hotmoka.node.api.ValidatorsConsensusConfig;
import io.hotmoka.node.api.ValidatorsConsensusConfigBuilder;
import io.hotmoka.node.internal.ConsensusConfigImpl;
import java.security.NoSuchAlgorithmException;

public abstract class ValidatorsConsensusConfigImpl
extends ConsensusConfigImpl
implements ValidatorsConsensusConfig {
    public final int percentStaked;
    public final int buyerSurcharge;
    public final int slashingForMisbehaving;
    public final int slashingForNotBehaving;

    public ValidatorsConsensusConfigImpl(ValidatorsConsensusConfigBuilderImpl<?> builder) {
        super(builder);
        this.percentStaked = builder.percentStaked;
        this.buyerSurcharge = builder.buyerSurcharge;
        this.slashingForMisbehaving = builder.slashingForMisbehaving;
        this.slashingForNotBehaving = builder.slashingForNotBehaving;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            ValidatorsConsensusConfigImpl otherConfig = (ValidatorsConsensusConfigImpl)other;
            return this.percentStaked == otherConfig.percentStaked && this.buyerSurcharge == otherConfig.buyerSurcharge && this.slashingForMisbehaving == otherConfig.slashingForMisbehaving && this.slashingForNotBehaving == otherConfig.slashingForNotBehaving;
        }
        return false;
    }

    @Override
    public String toToml() {
        StringBuilder sb = new StringBuilder(super.toToml());
        sb.append("\n");
        sb.append("# the amount of validators' rewards that gets staked. The rest is sent to the validators\n");
        sb.append("# immediately. 1000000 means 1%\n");
        sb.append("percent_staked = " + this.percentStaked + "\n");
        sb.append("\n");
        sb.append("# extra tax paid when a validator acquires the shares of another validator\n");
        sb.append("# (in percent of the offer cost). 1000000 means 1%\n");
        sb.append("buyer_surcharge = " + this.buyerSurcharge + "\n");
        sb.append("\n");
        sb.append("# the percent of stake that gets slashed for each misbehaving validator. 1000000 means 1%\n");
        sb.append("slashing_for_misbehaving = " + this.slashingForMisbehaving + "\n");
        sb.append("\n");
        sb.append("# the percent of stake that gets slashed for each validator that does not behave\n");
        sb.append("# (or does not vote). 1000000 means 1%\n");
        sb.append("slashing_for_not_behaving = " + this.slashingForNotBehaving + "\n");
        return sb.toString();
    }

    public int getPercentStaked() {
        return this.percentStaked;
    }

    public int getBuyerSurcharge() {
        return this.buyerSurcharge;
    }

    public int getSlashingForMisbehaving() {
        return this.slashingForMisbehaving;
    }

    public int getSlashingForNotBehaving() {
        return this.slashingForNotBehaving;
    }

    @Override
    protected <T extends ValidatorsConsensusConfigBuilder<T>> T fill(T builder) {
        return (T)super.fill(builder).setBuyerSurcharge(this.buyerSurcharge).setPercentStaked(this.percentStaked).setSlashingForMisbehaving(this.slashingForMisbehaving).setSlashingForNotBehaving(this.slashingForNotBehaving);
    }

    public static abstract class ValidatorsConsensusConfigBuilderImpl<T extends ValidatorsConsensusConfigBuilder<T>>
    extends ConsensusConfigImpl.ConsensusConfigBuilderImpl<T>
    implements ValidatorsConsensusConfigBuilder<T> {
        private int percentStaked = 75000000;
        private int buyerSurcharge = 50000000;
        private int slashingForMisbehaving = 1000000;
        private int slashingForNotBehaving = 500000;

        protected ValidatorsConsensusConfigBuilderImpl() throws NoSuchAlgorithmException {
        }

        protected ValidatorsConsensusConfigBuilderImpl(SignatureAlgorithm<SignedTransactionRequest> signature) {
            super(signature);
        }

        protected ValidatorsConsensusConfigBuilderImpl(Toml toml) throws NoSuchAlgorithmException {
            super(toml);
            Long slashingForNotBehaving;
            Long slashingForMisbehaving;
            Long buyerSurcharge;
            Long percentStaked = toml.getLong("percent_staked");
            if (percentStaked != null) {
                this.setPercentStaked((int)percentStaked.longValue());
            }
            if ((buyerSurcharge = toml.getLong("buyer_surcharge")) != null) {
                this.setBuyerSurcharge((int)buyerSurcharge.longValue());
            }
            if ((slashingForMisbehaving = toml.getLong("slashing_for_misbehaving")) != null) {
                this.setSlashingForMisbehaving((int)slashingForMisbehaving.longValue());
            }
            if ((slashingForNotBehaving = toml.getLong("slashing_for_not_behaving")) != null) {
                this.setSlashingForNotBehaving((int)slashingForNotBehaving.longValue());
            }
        }

        public T setPercentStaked(int percentStaked) {
            if (percentStaked < 0 || percentStaked > 100000000) {
                throw new IllegalArgumentException("percentStaked must be between 0 and 100_000_000");
            }
            this.percentStaked = percentStaked;
            return (T)((ValidatorsConsensusConfigBuilder)this.getThis());
        }

        public T setBuyerSurcharge(int buyerSurcharge) {
            if (buyerSurcharge < 0 || buyerSurcharge > 100000000) {
                throw new IllegalArgumentException("buyerSurcharge must be between 0 and 100_000_000");
            }
            this.buyerSurcharge = buyerSurcharge;
            return (T)((ValidatorsConsensusConfigBuilder)this.getThis());
        }

        public T setSlashingForMisbehaving(int slashingForMisbehaving) {
            if (slashingForMisbehaving < 0 || slashingForMisbehaving > 100000000) {
                throw new IllegalArgumentException("slashingForMisbehaving must be between 0 and 100_000_000");
            }
            this.slashingForMisbehaving = slashingForMisbehaving;
            return (T)((ValidatorsConsensusConfigBuilder)this.getThis());
        }

        public T setSlashingForNotBehaving(int slashingForNotBehaving) {
            if (slashingForNotBehaving < 0 || slashingForNotBehaving > 100000000) {
                throw new IllegalArgumentException("slashingForNotBehaving must be between 0 and 100_000_000");
            }
            this.slashingForNotBehaving = slashingForNotBehaving;
            return (T)((ValidatorsConsensusConfigBuilder)this.getThis());
        }

        public abstract ValidatorsConsensusConfig build();
    }
}

