/*
 * Decompiled with CFR 0.152.
 */
package io.hydrosphere.serving.model.api;

import io.hydrosphere.serving.contract.model_contract.ModelContract;
import io.hydrosphere.serving.contract.model_field.ModelField;
import io.hydrosphere.serving.contract.model_field.ModelField$TypeOrSubfields$Empty$;
import io.hydrosphere.serving.contract.model_signature.ModelSignature;
import io.hydrosphere.serving.model.api.TensorExampleGenerator;
import io.hydrosphere.serving.model.api.json.TensorJsonLens$;
import io.hydrosphere.serving.tensorflow.TensorShape;
import io.hydrosphere.serving.tensorflow.TensorShape$;
import io.hydrosphere.serving.tensorflow.TensorShape$AnyDims$;
import io.hydrosphere.serving.tensorflow.tensor.MapTensor;
import io.hydrosphere.serving.tensorflow.tensor.TypedTensor;
import io.hydrosphere.serving.tensorflow.tensor.TypedTensorFactory;
import io.hydrosphere.serving.tensorflow.tensor.TypedTensorFactory$;
import io.hydrosphere.serving.tensorflow.types.DataType;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_BOOL$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_COMPLEX128$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_COMPLEX64$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_DOUBLE$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_FLOAT$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_INT16$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_INT32$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_INT64$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_INT8$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_INVALID$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_QINT16$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_QINT32$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_QINT8$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_QUINT16$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_QUINT8$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_STRING$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_UINT16$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_UINT32$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_UINT64$;
import io.hydrosphere.serving.tensorflow.types.DataType$DT_UINT8$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import spray.json.JsObject;

public final class TensorExampleGenerator$
implements scala.Serializable {
    public static TensorExampleGenerator$ MODULE$;

    static {
        new TensorExampleGenerator$();
    }

    public Option<JsObject> generatePayload(ModelContract contract, String signature) {
        return this.forPredict(contract).map((Function1 & Serializable & scala.Serializable)x -> TensorJsonLens$.MODULE$.mapToJson(x.inputs()));
    }

    public Option<TensorExampleGenerator> forPredict(ModelContract modelContract) {
        return modelContract.predict().map((Function1 & Serializable & scala.Serializable)modelApi -> new TensorExampleGenerator((ModelSignature)modelApi));
    }

    public <T extends DataType> Object generateScalarData(T dataType) {
        Object object;
        T t = dataType;
        boolean bl = DataType$DT_FLOAT$.MODULE$.equals(t) ? true : DataType$DT_COMPLEX64$.MODULE$.equals(t);
        if (bl) {
            object = BoxesRunTime.boxToFloat((float)1.0f);
        } else {
            boolean bl2 = DataType$DT_DOUBLE$.MODULE$.equals(t) ? true : DataType$DT_COMPLEX128$.MODULE$.equals(t);
            if (bl2) {
                object = BoxesRunTime.boxToDouble((double)1.0);
            } else {
                boolean bl3 = DataType$DT_INT8$.MODULE$.equals(t) ? true : (DataType$DT_INT16$.MODULE$.equals(t) ? true : (DataType$DT_INT32$.MODULE$.equals(t) ? true : (DataType$DT_UINT8$.MODULE$.equals(t) ? true : (DataType$DT_UINT16$.MODULE$.equals(t) ? true : (DataType$DT_UINT32$.MODULE$.equals(t) ? true : (DataType$DT_QINT8$.MODULE$.equals(t) ? true : (DataType$DT_QINT16$.MODULE$.equals(t) ? true : (DataType$DT_QINT32$.MODULE$.equals(t) ? true : (DataType$DT_QUINT8$.MODULE$.equals(t) ? true : DataType$DT_QUINT16$.MODULE$.equals(t))))))))));
                if (bl3) {
                    object = BoxesRunTime.boxToInteger((int)1);
                } else {
                    boolean bl4 = DataType$DT_INT64$.MODULE$.equals(t) ? true : DataType$DT_UINT64$.MODULE$.equals(t);
                    if (bl4) {
                        object = BoxesRunTime.boxToLong((long)1L);
                    } else if (DataType$DT_STRING$.MODULE$.equals(t)) {
                        object = "foo";
                    } else if (DataType$DT_BOOL$.MODULE$.equals(t)) {
                        object = BoxesRunTime.boxToBoolean((boolean)true);
                    } else {
                        if (DataType$DT_INVALID$.MODULE$.equals(t)) {
                            throw new IllegalArgumentException("Can't convert data to DT_INVALID");
                        }
                        throw new IllegalArgumentException(new StringBuilder(33).append("Cannot process Tensor with ").append(t).append(" dtype").toString());
                    }
                }
            }
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Seq<T> createFlatTensor(TensorShape shape, Function0<T> generator) {
        boolean bl = false;
        TensorShape.Dims dims = null;
        TensorShape tensorShape = shape;
        if (TensorShape$AnyDims$.MODULE$.equals(tensorShape)) {
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{generator.apply()}));
        }
        if (tensorShape instanceof TensorShape.Dims) {
            bl = true;
            dims = (TensorShape.Dims)tensorShape;
            Seq<Object> dims2 = dims.dims();
            if (dims2.isEmpty()) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{generator.apply()}));
            }
        }
        if (!bl) throw new MatchError((Object)tensorShape);
        Seq<Object> dims3 = dims.dims();
        long flatLen = BoxesRunTime.unboxToLong((Object)((TraversableOnce)dims3.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$1 -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(x$1), 1L), Seq$.MODULE$.canBuildFrom())).product((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return (Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)flatLen)).map((Function1 & Serializable & scala.Serializable)x$2 -> generator.apply(), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<TypedTensor<?>> generateTensor(TensorShape shape, DataType dtype) {
        TypedTensorFactory<TypedTensor<?>> factory = TypedTensorFactory$.MODULE$.apply(dtype);
        Seq data = this.createFlatTensor(shape, (Function0 & Serializable & scala.Serializable)() -> MODULE$.generateScalarData(dtype));
        return factory.createFromAny(data, shape);
    }

    public Map<String, TypedTensor<?>> generateField(ModelField field) {
        Option<TypedTensor<?>> option;
        TensorShape shape = TensorShape$.MODULE$.apply(field.shape());
        ModelField.TypeOrSubfields typeOrSubfields = field.typeOrSubfields();
        if (ModelField$TypeOrSubfields$Empty$.MODULE$.equals(typeOrSubfields)) {
            option = None$.MODULE$;
        } else if (typeOrSubfields instanceof ModelField.TypeOrSubfields.Dtype) {
            ModelField.TypeOrSubfields.Dtype dtype = (ModelField.TypeOrSubfields.Dtype)typeOrSubfields;
            DataType value = dtype.value();
            option = this.generateTensor(shape, value);
        } else if (typeOrSubfields instanceof ModelField.TypeOrSubfields.Subfields) {
            ModelField.TypeOrSubfields.Subfields subfields = (ModelField.TypeOrSubfields.Subfields)typeOrSubfields;
            ModelField.Subfield value = subfields.value();
            option = this.generateNestedTensor(shape, value);
        } else {
            throw new MatchError((Object)typeOrSubfields);
        }
        Option<TypedTensor<?>> fieldValue = option;
        return Option$.MODULE$.option2Iterable(fieldValue.map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), x))).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<MapTensor> generateNestedTensor(TensorShape shape, ModelField.Subfield value) {
        Map<String, TypedTensor<?>> map = this.generateMap(value);
        Seq tensorData = this.createFlatTensor(shape, (Function0 & Serializable & scala.Serializable)() -> map);
        return new Some((Object)new MapTensor(shape, tensorData));
    }

    private Map<String, TypedTensor<?>> generateMap(ModelField.Subfield value) {
        return ((TraversableOnce)value.data().flatMap((Function1 & Serializable & scala.Serializable)field -> MODULE$.generateField((ModelField)field), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public TensorExampleGenerator apply(ModelSignature modelApi) {
        return new TensorExampleGenerator(modelApi);
    }

    public Option<ModelSignature> unapply(TensorExampleGenerator x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.modelApi());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TensorExampleGenerator$() {
        MODULE$ = this;
    }
}

