/*
 * Decompiled with CFR 0.152.
 */
package io.hydrosphere.serving.model.api;

import com.google.protobuf.ByteString;
import io.hydrosphere.serving.tensorflow.TensorShape;
import io.hydrosphere.serving.tensorflow.TensorShape$AnyDims$;
import io.hydrosphere.serving.tensorflow.TensorShape$Dims$;
import io.hydrosphere.serving.tensorflow.tensor.MapTensorData;
import io.hydrosphere.serving.tensorflow.tensor.TensorProto;
import io.hydrosphere.serving.tensorflow.tensor.TypedTensor;
import io.hydrosphere.serving.tensorflow.tensor.TypedTensorFactory$;
import io.hydrosphere.serving.tensorflow.tensor.VariantTensorDataProto;
import io.hydrosphere.serving.tensorflow.tensor_shape.TensorShapeProto;
import io.hydrosphere.serving.tensorflow.types.DataType;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class TensorUtil$ {
    public static TensorUtil$ MODULE$;

    static {
        new TensorUtil$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> Option<TypedTensor<T>> verifyShape(TypedTensor<T> tensor) {
        Some some;
        boolean bl = false;
        TensorShape.Dims dims = null;
        TensorShape tensorShape = tensor.shape();
        if (TensorShape$AnyDims$.MODULE$.equals(tensorShape)) {
            return new Some(tensor);
        }
        if (tensorShape instanceof TensorShape.Dims) {
            bl = true;
            dims = (TensorShape.Dims)tensorShape;
            Seq<Object> tensorDims = dims.dims();
            if (tensorDims.isEmpty()) {
                return new Some(tensor);
            }
        }
        if (!bl) throw new MatchError((Object)tensorShape);
        Seq<Object> tensorDims = dims.dims();
        if (tensorDims.isEmpty() && tensor.data().length() <= 1) {
            some = new Some(tensor);
            return some;
        } else {
            Iterator reverseTensorDimIter = tensorDims.reverseIterator();
            long[] actualDims = (long[])Array$.MODULE$.fill(tensorDims.length(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, ClassTag$.MODULE$.Long());
            int actualDimId = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(actualDims)).indices().last();
            int dimLen = tensor.data().length();
            boolean isShapeOk = true;
            while (isShapeOk && reverseTensorDimIter.hasNext()) {
                long currentDim = BoxesRunTime.unboxToLong((Object)reverseTensorDimIter.next());
                double subCount = (double)dimLen / (double)currentDim;
                if (RichDouble$.MODULE$.isWhole$extension(Predef$.MODULE$.doubleWrapper(subCount))) {
                    dimLen = (int)subCount;
                    actualDims[actualDimId] = subCount < 0.0 ? (long)RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(dimLen)) : currentDim;
                    --actualDimId;
                    continue;
                }
                isShapeOk = false;
            }
            if (isShapeOk) {
                TensorProto qual$1 = tensor.toProto();
                Option<TensorShapeProto> x$1 = new TensorShape.Dims((Seq<Object>)Predef$.MODULE$.wrapLongArray(actualDims), TensorShape$Dims$.MODULE$.apply$default$2()).toProto();
                DataType x$2 = qual$1.copy$default$1();
                int x$3 = qual$1.copy$default$3();
                ByteString x$4 = qual$1.copy$default$4();
                Seq<Object> x$5 = qual$1.copy$default$5();
                Seq<Object> x$6 = qual$1.copy$default$6();
                Seq<Object> x$7 = qual$1.copy$default$7();
                Seq<Object> x$8 = qual$1.copy$default$8();
                Seq<ByteString> x$9 = qual$1.copy$default$9();
                Seq<Object> x$10 = qual$1.copy$default$10();
                Seq<Object> x$11 = qual$1.copy$default$11();
                Seq<Object> x$12 = qual$1.copy$default$12();
                Seq<Object> x$13 = qual$1.copy$default$13();
                Seq<VariantTensorDataProto> x$14 = qual$1.copy$default$14();
                Seq<Object> x$15 = qual$1.copy$default$15();
                Seq<Object> x$16 = qual$1.copy$default$16();
                Seq<MapTensorData> x$17 = qual$1.copy$default$17();
                TensorProto rawTensor = qual$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                TypedTensor result = tensor.factory().fromProto(rawTensor);
                some = new Some((Object)result);
                return some;
            } else {
                some = None$.MODULE$;
            }
        }
        return some;
    }

    public Option<TensorProto> verifyShape(TensorProto tensor) {
        return this.verifyShape(TypedTensorFactory$.MODULE$.create(tensor)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toProto());
    }

    private TensorUtil$() {
        MODULE$ = this;
    }
}

