/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.VertxBaseTest;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class BaseClientTest
extends VertxBaseTest {
    protected static final List<io.vertx.core.http.HttpVersion> HTTP1x_ONLY = Collections.singletonList(io.vertx.core.http.HttpVersion.HTTP_1_1);
    protected static final List<io.vertx.core.http.HttpVersion> HTTP2_ONLY = Collections.singletonList(io.vertx.core.http.HttpVersion.HTTP_2);

    protected void server(boolean ssl, List<io.vertx.core.http.HttpVersion> serverVersions, Handler<HttpServerRequest> requestHandler, Handler<AsyncResult<HttpServer>> listenHandler) {
        if (ssl) {
            JksOptions keyStoreOptions = new JksOptions().setPath("keystore.jks").setPassword("test123");
            HttpServerOptions httpServerOptions = new HttpServerOptions().setSsl(true).setKeyStoreOptions(keyStoreOptions).setUseAlpn(true).setAlpnVersions(serverVersions);
            HttpServer httpServer = this.vertx.createHttpServer(httpServerOptions);
            httpServer.requestHandler(requestHandler).listen(0, "localhost", listenHandler);
        } else {
            HttpServer httpServer = this.vertx.createHttpServer();
            httpServer.requestHandler(requestHandler).listen(0, "localhost", listenHandler);
        }
    }

    protected HttpClientPool client(int port, boolean ssl, HttpVersion[] versions) throws Exception {
        HttpBuilder builder = HttpBuilder.forTesting().protocol(ssl ? Protocol.HTTPS : Protocol.HTTP).host("localhost").port(port);
        builder.allowHttp2(Stream.of(versions).anyMatch(v -> v == HttpVersion.HTTP_2_0));
        builder.allowHttp1x(Stream.of(versions).anyMatch(v -> v == HttpVersion.HTTP_1_1));
        return HttpClientPoolImpl.forTesting((Http)builder.build(true), (int)1);
    }

    protected void test(TestContext ctx, boolean ssl, HttpVersion[] clientVersions, List<io.vertx.core.http.HttpVersion> serverVersions, Handler<HttpServerRequest> requestHandler, ClientAction clientAction) {
        Async async = ctx.async();
        this.server(ssl, serverVersions, requestHandler, (Handler<AsyncResult<HttpServer>>)((Handler)event -> {
            if (event.failed()) {
                ctx.fail(event.cause());
            } else {
                HttpServer server = (HttpServer)event.result();
                this.cleanup.add(() -> ((HttpServer)server).close());
                try {
                    HttpClientPool client = this.client(server.actualPort(), ssl, clientVersions);
                    client.start(result -> {
                        if (result.failed()) {
                            ctx.fail(result.cause());
                            return;
                        }
                        this.cleanup.add(() -> ((HttpClientPool)client).shutdown());
                        clientAction.run(client, async);
                    });
                }
                catch (Exception e) {
                    ctx.fail((Throwable)e);
                }
            }
        }));
    }

    protected void sendRequestAndAssertStatus(TestContext ctx, HttpClientPool client, Async async, HttpMethod method, String path, int expectedStatus) {
        Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
        HttpRunData.initForTesting((Session)session);
        HttpRequest request = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
        AtomicBoolean statusReceived = new AtomicBoolean(false);
        HttpResponseHandlersImpl handlers = HttpResponseHandlersImpl.Builder.forTesting().status((StatusHandler & Serializable)(r, status) -> {
            if (status != expectedStatus) {
                ctx.fail();
            } else {
                statusReceived.set(true);
            }
        }).onCompletion((Action & Serializable)s -> {
            if (statusReceived.get()) {
                async.complete();
            } else {
                ctx.fail("Status was not received.");
            }
        }).build();
        request.method = method;
        request.path = path;
        HttpConnectionPool pool = client.next();
        request.start(pool, (HttpResponseHandlers)handlers, new SequenceInstance(), new Statistics(System.currentTimeMillis()));
        pool.acquire(false, c -> request.send(c, null, true, null));
    }

    @FunctionalInterface
    static interface ClientAction {
        public void run(HttpClientPool var1, Async var2);
    }
}

