/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.VertxBaseTest;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class BigResponseParsingTest
extends VertxBaseTest {
    private Vertx vertx = Vertx.vertx();
    private HttpServer httpServer;

    @Before
    public void before(TestContext ctx) {
        this.httpServer = this.vertx.createHttpServer().requestHandler(req -> {
            AtomicInteger counter = new AtomicInteger(100000);
            req.response().putHeader("content-length", String.valueOf(counter.get()));
            this.sendChunk((HttpServerRequest)req, counter);
        }).listen(0, "localhost", ctx.asyncAssertSuccess());
        this.cleanup.add(() -> ((HttpServer)this.httpServer).close());
    }

    private void sendChunk(HttpServerRequest req, AtomicInteger counter) {
        req.response().write((Object)Buffer.buffer((byte[])new byte[10000]), result -> {
            if (counter.addAndGet(-10000) == 0) {
                req.response().end();
            } else {
                this.sendChunk(req, counter);
            }
        });
    }

    private Future<HttpClientPool> getClientPool(TestContext ctx) {
        Http http = HttpBuilder.forTesting().protocol(Protocol.HTTP).host("localhost").port(this.httpServer.actualPort()).allowHttp2(false).build(true);
        try {
            HttpClientPoolImpl client = HttpClientPoolImpl.forTesting((Http)http, (int)1);
            Promise promise = Promise.promise();
            client.start(arg_0 -> this.lambda$getClientPool$2(ctx, promise, (HttpClientPool)client, arg_0));
            return promise.future();
        }
        catch (SSLException e) {
            return Future.failedFuture((Throwable)e);
        }
    }

    @Test
    public void test(TestContext ctx) {
        Async async = ctx.async();
        final AtomicInteger responseSize = new AtomicInteger();
        this.getClientPool(ctx).onComplete(result -> {
            HttpClientPool client = (HttpClientPool)result.result();
            Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
            HttpRunData.initForTesting((Session)session);
            HttpResponseHandlersImpl handlers = HttpResponseHandlersImpl.Builder.forTesting().rawBytes(new RawBytesHandler(){

                public void onRequest(Request request, ByteBuf buf, int offset, int length) {
                }

                public void onResponse(Request request, ByteBuf buf, int offset, int length, boolean isLastPart) {
                    responseSize.addAndGet(length);
                }
            }).onCompletion((Action & Serializable)s -> {
                ctx.assertTrue(responseSize.get() > 100000, String.valueOf(responseSize.get()));
                async.countDown();
            }).build();
            HttpRequest newRequest = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
            newRequest.method = HttpMethod.GET;
            newRequest.path = "/";
            SequenceInstance sequence = new SequenceInstance().reset(null, 0, new Step[0], null);
            HttpConnectionPool pool = client.next();
            newRequest.start(pool, (HttpResponseHandlers)handlers, sequence, new Statistics(System.currentTimeMillis()));
            pool.acquire(false, c -> newRequest.send(c, null, true, null));
        });
    }

    private /* synthetic */ void lambda$getClientPool$2(TestContext ctx, Promise promise, HttpClientPool client, AsyncResult result) {
        if (result.failed()) {
            ctx.fail(result.cause());
            promise.fail(result.cause());
            return;
        }
        this.cleanup.add(() -> ((HttpClientPool)client).shutdown());
        promise.complete((Object)client);
    }
}

