/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CertificatesTest {
    @Test
    public void testTrustJks(TestContext context) {
        this.test(context, false, (Handler<HttpServer>)((Handler)server -> this.executeRequestAndStop(context, (HttpServer)server, builder -> builder.trustManager().storeFile("keystore.jks").password("test123"))));
    }

    @Test
    public void testTrustCert(TestContext context) {
        this.test(context, false, (Handler<HttpServer>)((Handler)server -> this.executeRequestAndStop(context, (HttpServer)server, builder -> builder.trustManager().certFile("servercert.crt"))));
    }

    @Test
    public void testTrustBadCert(TestContext context) {
        this.test(context, false, (Handler<HttpServer>)((Handler)server -> {
            try {
                HttpClientPool client = this.client(server.actualPort(), builder -> builder.trustManager().certFile("badcert.pem"));
                client.start(context.asyncAssertFailure());
            }
            catch (SSLException e) {
                context.fail((Throwable)e);
            }
        }));
    }

    @Test
    public void testTrustBadJks(TestContext context) {
        this.test(context, false, (Handler<HttpServer>)((Handler)server -> {
            try {
                HttpClientPool client = this.client(server.actualPort(), builder -> builder.trustManager().storeFile("bad.jks"));
                client.start(context.asyncAssertFailure());
            }
            catch (SSLException e) {
                context.fail((Throwable)e);
            }
        }));
    }

    @Test
    public void testClientJks(TestContext context) {
        this.test(context, true, (Handler<HttpServer>)((Handler)server -> this.executeRequestAndStop(context, (HttpServer)server, builder -> builder.trustManager().storeFile("keystore.jks").password("test123").end().keyManager().storeFile("client.jks").password("test123"))));
    }

    @Test
    public void testClientBadJks(TestContext context) {
        this.test(context, true, (Handler<HttpServer>)((Handler)server -> {
            try {
                HttpClientPool client = this.client(server.actualPort(), builder -> builder.trustManager().storeFile("keystore.jks").password("test123").end().keyManager().storeFile("bad.jks").password("test123"));
                client.start(context.asyncAssertFailure());
            }
            catch (SSLException e) {
                context.fail((Throwable)e);
            }
        }));
    }

    @Test
    public void testClientCertAndKey(TestContext context) {
        this.test(context, true, (Handler<HttpServer>)((Handler)server -> this.executeRequestAndStop(context, (HttpServer)server, builder -> builder.trustManager().storeFile("keystore.jks").password("test123").end().keyManager().certFile("clientcert.pem").keyFile("clientkey.pem").password("test123"))));
    }

    private void test(TestContext context, boolean requireClientTrust, Handler<HttpServer> handler) {
        HttpServerOptions serverOptions = new HttpServerOptions().setSsl(true).setKeyStoreOptions(new JksOptions().setPath("keystore.jks").setPassword("test123"));
        if (requireClientTrust) {
            serverOptions.setClientAuth(ClientAuth.REQUIRED);
            serverOptions.setTrustStoreOptions(new JksOptions().setPath("client.jks").setPassword("test123"));
        }
        Vertx.vertx().createHttpServer(serverOptions).requestHandler(ctx -> ctx.response().end()).listen(0, "localhost", context.asyncAssertSuccess(handler));
    }

    private void executeRequestAndStop(TestContext context, HttpServer server, Consumer<HttpBuilder> configuration) {
        try {
            HttpClientPool client = this.client(server.actualPort(), configuration);
            Async async = context.async();
            client.start(context.asyncAssertSuccess(nil -> {
                Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
                HttpRunData.initForTesting((Session)session);
                HttpRequest request = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
                AtomicBoolean statusReceived = new AtomicBoolean(false);
                HttpResponseHandlersImpl handlers = HttpResponseHandlersImpl.Builder.forTesting().status((StatusHandler & Serializable)(r, status) -> {
                    if (status != 200) {
                        context.fail("Unexpected status " + status);
                    } else {
                        statusReceived.set(true);
                    }
                }).onCompletion((Action & Serializable)s -> {
                    client.shutdown();
                    server.close();
                    if (statusReceived.get()) {
                        async.complete();
                    } else {
                        context.fail("Status was not received.");
                    }
                }).build();
                request.method = HttpMethod.GET;
                request.path = "/ping";
                HttpConnectionPool pool = client.next();
                request.start(pool, (HttpResponseHandlers)handlers, new SequenceInstance(), new Statistics(System.currentTimeMillis()));
                pool.acquire(false, c -> request.send(c, null, true, null));
            }));
        }
        catch (SSLException e) {
            server.close();
            context.fail((Throwable)e);
        }
    }

    private HttpClientPool client(int port, Consumer<HttpBuilder> configuration) throws SSLException {
        HttpBuilder builder = HttpBuilder.forTesting().protocol(Protocol.HTTPS).host("localhost").port(port);
        configuration.accept(builder);
        return HttpClientPoolImpl.forTesting((Http)builder.build(true), (int)1);
    }
}

