/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.test.TestUtil;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ChunkedTransferTest
extends HttpScenarioTest {
    public static final String SHIBBOLETH = "Shibboleth";

    @Override
    protected void initHttp(HttpBuilder http) {
        http.pipeliningLimit(2);
    }

    @Override
    protected void initRouter() {
        this.router.route("/test").handler(ctx -> {
            HttpServerResponse response = ctx.response();
            response.setChunked(true);
            response.write("Foo");
            response.write("Bar");
            response.putTrailer("Custom", "Trailer");
            response.end();
        });
        this.router.route("/test2").handler(ctx -> ctx.response().end(SHIBBOLETH));
        this.router.route("/test3").handler(ctx -> {
            HttpServerResponse response = ctx.response().setChunked(true);
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            for (int i = 0; i < 3; ++i) {
                response.write(TestUtil.randomString((ThreadLocalRandom)rand, (int)100));
            }
            response.end();
        });
    }

    @Test
    public void testChunkedTransfer() {
        final AtomicBoolean rawBytesSeen = new AtomicBoolean(false);
        ((HttpStepCatalog)((HttpStepCatalog)((HttpStepCatalog)((SequenceBuilder)this.scenario().initialSequence("test").step((Step & Serializable)s -> {
            HttpDestinationTable.get((Session)s).getConnectionPoolByAuthority(null).connections().forEach(c -> ChunkedTransferTest.injectChannelHandler(c, (ChannelHandler)new BufferingDecoder()));
            return true;
        })).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test").headers().header((CharSequence)HttpHeaderNames.CACHE_CONTROL, (CharSequence)"no-cache").endHeaders().handler().rawBytes(new RawBytesHandler(){

            public void onRequest(Request request, ByteBuf buf, int offset, int length) {
            }

            public void onResponse(Request request, ByteBuf byteBuf, int offset, int length, boolean isLastPart) {
                ChunkedTransferTest.this.log.info("Received chunk {} bytes:\n{}", (Object)length, (Object)byteBuf.toString(offset, length, StandardCharsets.UTF_8));
                if (byteBuf.toString(StandardCharsets.UTF_8).contains(ChunkedTransferTest.SHIBBOLETH)) {
                    throw new IllegalStateException();
                }
                rawBytesSeen.set(true);
            }
        }).endHandler().sync(false).endStep().step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test2").sync(false).endStep().step(HttpStepCatalog.SC)).awaitAllResponses().endSequence();
        this.runScenario();
        Assertions.assertThat((AtomicBoolean)rawBytesSeen).isTrue();
    }

    @Test
    public void testRandomCutBuffers() {
        BaseSequenceBuilder sequence = this.scenario(64).initialSequence("test").step((Step & Serializable)s -> {
            HttpDestinationTable.get((Session)s).getConnectionPoolByAuthority(null).connections().forEach(c -> ChunkedTransferTest.injectChannelHandler(c, (ChannelHandler)new RandomLengthDecoder()));
            return true;
        });
        AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < 16; ++i) {
            ((HttpStepCatalog)sequence.step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test3").headers().header((CharSequence)"cache-control", (CharSequence)"no-cache").endHeaders().sync(false).handler().body(fragmented -> (Processor & Serializable)(session, data, offset, length, isLastPart) -> {
                String str = Util.toString((ByteBuf)data, (int)offset, (int)length);
                if (str.contains("\n")) {
                    session.fail((Throwable)((Object)new AssertionError((Object)str)));
                }
            }).onCompletion((Action & Serializable)s -> counter.incrementAndGet());
        }
        ((HttpStepCatalog)sequence.step(HttpStepCatalog.SC)).awaitAllResponses();
        this.runScenario();
        Assertions.assertThat((int)counter.get()).isEqualTo(1024);
    }

    private static void injectChannelHandler(HttpConnection c, ChannelHandler channelHandler) {
        try {
            Field f = c.getClass().getDeclaredField("ctx");
            f.setAccessible(true);
            ChannelHandlerContext ctx = (ChannelHandlerContext)f.get(c);
            if (ctx.pipeline().first().getClass() != channelHandler.getClass()) {
                ctx.pipeline().addFirst(new ChannelHandler[]{channelHandler});
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException();
        }
    }

    private static class RandomLengthDecoder
    extends ChannelInboundHandlerAdapter {
        private RandomLengthDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                ThreadLocalRandom rand = ThreadLocalRandom.current();
                int curr = 0;
                if (buf.readableBytes() == 0) {
                    ctx.fireChannelRead((Object)buf);
                    return;
                }
                while (curr + buf.readerIndex() < buf.writerIndex()) {
                    int len = rand.nextInt(buf.readableBytes() + 1);
                    ByteBuf slice = buf.retainedSlice(buf.readerIndex() + curr, Math.min(buf.writerIndex(), buf.readerIndex() + curr + len) - curr - buf.readerIndex());
                    ctx.fireChannelRead((Object)slice);
                    curr += len;
                }
                buf.release();
            } else {
                super.channelRead(ctx, msg);
            }
        }
    }

    private static class BufferingDecoder
    extends ChannelInboundHandlerAdapter {
        CompositeByteBuf composite = null;
        boolean buffering = true;

        private BufferingDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.buffering && msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                if (this.composite == null) {
                    this.composite = new CompositeByteBuf(buf.alloc(), buf.isDirect(), 2, new ByteBuf[]{buf});
                } else {
                    this.composite.addComponent(true, buf);
                }
                if (this.composite.toString(StandardCharsets.UTF_8).contains(ChunkedTransferTest.SHIBBOLETH)) {
                    this.buffering = false;
                    super.channelRead(ctx, (Object)this.composite);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (this.composite != null) {
                this.composite.release();
            }
        }
    }
}

