/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.CloseConnectionHandler;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.netty.buffer.ByteBuf;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CloseConnectionTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.get("/body").handler(ctx -> ctx.response().end("Hello"));
        this.router.get("/nobody").handler(ctx -> ctx.response().end());
    }

    private void test(String path) {
        AtomicBoolean closed = new AtomicBoolean(false);
        ((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.POST).path(path).handler().body((Processor.Builder)new CloseConnectionHandler.Builder()).body(f -> new TestProcessor(closed)).endHandler().endStep();
        this.runScenario();
        Assertions.assertThat((boolean)closed.get()).isTrue();
    }

    @Test
    public void testWithBody(TestContext ctx) {
        this.test("/body");
    }

    @Test
    public void testWithoutBody(TestContext ctx) {
        this.test("/nobody");
    }

    private static class TestProcessor
    implements Processor {
        private final AtomicBoolean closed;

        private TestProcessor(AtomicBoolean closed) {
            this.closed = closed;
        }

        public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        }

        public void after(Session session) {
            this.closed.set(session.currentRequest().connection().isClosed());
        }
    }
}

