/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.statistics.HttpStats;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CompressionTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.route("/short").handler(ctx -> {
            if (this.checkAcceptEncoding((RoutingContext)ctx)) {
                return;
            }
            ctx.response().end("Short message to be encoded.");
        });
        this.router.route("/long").handler(ctx -> {
            if (this.checkAcceptEncoding((RoutingContext)ctx)) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < 10000; ++i) {
                sb.append((char)random.nextInt(65, 91));
            }
            ctx.response().end(sb.toString());
        });
    }

    @Override
    protected boolean useCompression() {
        return true;
    }

    private boolean checkAcceptEncoding(RoutingContext ctx) {
        if (!"gzip".equalsIgnoreCase(ctx.request().getHeader(HttpHeaders.ACCEPT_ENCODING))) {
            ctx.response().setStatusCode(400).end("Expected accept-encoding header");
            return true;
        }
        return false;
    }

    @Test
    public void test() {
        Benchmark benchmark = this.loadScenario("scenarios/CompressionTest.hf.yaml");
        Map stats = this.runScenario(benchmark);
        this.validateStats((StatisticsSnapshot)stats.get("short"));
        this.validateStats((StatisticsSnapshot)stats.get("long"));
    }

    private void validateStats(StatisticsSnapshot snapshot) {
        Assertions.assertThat((int)snapshot.requestCount).isEqualTo(1);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)snapshot).status_2xx).isEqualTo(1);
        Assertions.assertThat((int)snapshot.invalid).isEqualTo(0);
    }
}

