/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.FollowRedirect;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class FollowRedirectTest
extends HttpScenarioTest {
    private final AtomicInteger redirects = new AtomicInteger();
    private final AtomicInteger notFound = new AtomicInteger();

    @Before
    public void resetRedirects() {
        this.redirects.set(0);
        this.notFound.set(0);
    }

    @Override
    protected void initRouter() {
        this.router.route().handler(ctx -> {
            ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
            ctx.next();
        });
        this.router.route("/redirectMeViaLocation").handler(this::redirectViaLocation);
        this.router.route("/redirectMeViaHtml").handler(this::redirectViaHtml);
        this.router.route("/redirectMeSomehow").handler(ctx -> {
            if (ThreadLocalRandom.current().nextBoolean()) {
                this.redirectViaLocation((RoutingContext)ctx);
            } else {
                this.redirectViaHtml((RoutingContext)ctx);
            }
        });
        this.router.route("/somewhereElse").handler(ctx -> {
            if (!this.ensureHeaders((RoutingContext)ctx)) {
                return;
            }
            ctx.response().end("this is the response");
        });
        this.router.route("/redirect/me/relatively").handler(ctx -> ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)"elsewhere").setStatusCode(302).end());
        this.router.route("/redirect/me/elsewhere").handler(ctx -> ctx.response().end("<html><head><meta http-equiv=\"refresh\" content=\"0; URL=../theEnd\" /></head></html>"));
        this.router.route("/redirect/theEnd").handler(ctx -> ctx.response().end("Final destination"));
    }

    private void redirectViaHtml(RoutingContext ctx) {
        if (!this.ensureHeaders(ctx)) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (random.nextBoolean()) {
            String refreshContent = random.nextInt(2) + "; url=" + this.target(ctx);
            ctx.response().end("<html><head><meta http-equiv=\"refresh\" content=\"" + refreshContent + "\" /></head></html>");
            this.redirects.incrementAndGet();
        } else if (random.nextBoolean()) {
            ctx.response().end("this is the response");
        } else {
            this.notFound.incrementAndGet();
            ctx.response().setStatusCode(404).end("Not Found (sort of)");
        }
    }

    private void redirectViaLocation(RoutingContext ctx) {
        if (!this.ensureHeaders(ctx)) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (random.nextBoolean()) {
            ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)this.target(ctx)).setStatusCode(303).end();
            this.redirects.incrementAndGet();
        } else if (random.nextBoolean()) {
            ctx.response().end("this is the response");
        } else {
            this.notFound.incrementAndGet();
            ctx.response().setStatusCode(404).end("Not Found (sort of)");
        }
    }

    private String target(RoutingContext ctx) {
        boolean allowRecursion = "yes".equals(ctx.request().getParam("allowRecurse"));
        return allowRecursion && ThreadLocalRandom.current().nextBoolean() ? ctx.request().path() + "?allowRecurse=yes" : "/somewhereElse";
    }

    private boolean ensureHeaders(RoutingContext ctx) {
        if (!ctx.request().getHeader("x-preserve").equals("repeat me with redirect")) {
            this.log.error("Missing header x-preserve");
            ctx.response().setStatusCode(500).end("Missing or incorrect x-preserve header");
            return false;
        }
        return true;
    }

    @Test
    public void testManual() {
        Benchmark benchmark = this.loadScenario("scenarios/FollowRedirectTest_manual.hf.yaml");
        int users = benchmark.phases().stream().filter(p -> "testPhase".equals(p.name())).mapToInt(p -> ((Model.AtOnce)p.model).users).findFirst().orElse(0);
        Map stats = this.runScenario(benchmark);
        HttpStats redirectMe = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get("redirectMe")));
        Assertions.assertThat((int)redirectMe.status_3xx).isEqualTo(this.redirects.get());
        Assertions.assertThat((int)redirectMe.status_2xx).isEqualTo(users - this.redirects.get() - this.notFound.get());
        Assertions.assertThat((int)redirectMe.status_4xx).isEqualTo(this.notFound.get());
        HttpStats redirectMe_redirect = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get("redirectMe_redirect")));
        Assertions.assertThat((int)redirectMe_redirect.status_2xx).isEqualTo(this.redirects.get());
    }

    @Test
    public void testLocation() {
        Benchmark benchmark = this.loadScenario("scenarios/FollowRedirectTest_location.hf.yaml");
        int users = benchmark.phases().stream().filter(p -> "testPhase".equals(p.name())).mapToInt(p -> ((Model.AtOnce)p.model).users).findFirst().orElse(0);
        Map stats = this.runScenario(benchmark);
        HttpStats redirectMe = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get("redirectMe")));
        String redirectMetric = stats.keySet().stream().filter(m -> !m.equals("redirectMe")).findFirst().orElse(null);
        if (redirectMetric == null) {
            Assertions.assertThat((int)redirectMe.status_2xx).isEqualTo(users - this.notFound.get());
            Assertions.assertThat((int)redirectMe.status_3xx).isEqualTo(0);
            Assertions.assertThat((int)redirectMe.status_4xx).isEqualTo(this.notFound.get());
            Assertions.assertThat((int)this.redirects.get()).isEqualTo(0);
        } else {
            HttpStats redirectStats = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get(redirectMetric)));
            Assertions.assertThat((int)(redirectMe.status_2xx + redirectStats.status_2xx)).isEqualTo(users - this.notFound.get());
            Assertions.assertThat((int)(redirectMe.status_3xx + redirectStats.status_3xx)).isEqualTo(this.redirects.get());
            Assertions.assertThat((int)(redirectMe.status_4xx + redirectStats.status_4xx)).isEqualTo(this.notFound.get());
        }
    }

    @Test
    public void testHtmlOnly() {
        Benchmark benchmark = this.loadScenario("scenarios/FollowRedirectTest_html.hf.yaml");
        int users = benchmark.phases().stream().filter(p -> "testPhase".equals(p.name())).mapToInt(p -> ((Model.AtOnce)p.model).users).findFirst().orElse(0);
        Map stats = this.runScenario(benchmark);
        HttpStats redirectMe = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get("redirectMe")));
        String redirectMetric = stats.keySet().stream().filter(m -> !m.equals("redirectMe")).findFirst().orElse(null);
        if (redirectMetric == null) {
            Assertions.assertThat((int)this.redirects.get()).isEqualTo(0);
            Assertions.assertThat((int)redirectMe.status_2xx).isEqualTo(users - this.notFound.get());
            Assertions.assertThat((int)redirectMe.status_4xx).isEqualTo(this.notFound.get());
        } else {
            HttpStats redirectStats = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get(redirectMetric)));
            Assertions.assertThat((int)(redirectStats.status_2xx + redirectMe.status_2xx)).isEqualTo(users + this.redirects.get() - this.notFound.get());
            Assertions.assertThat((int)redirectStats.status_3xx).isEqualTo(0);
            Assertions.assertThat((int)(redirectStats.status_4xx + redirectMe.status_4xx)).isEqualTo(this.notFound.get());
        }
        Assertions.assertThat((int)redirectMe.status_3xx).isEqualTo(0);
    }

    @Test
    public void testAlways() {
        Benchmark benchmark = this.loadScenario("scenarios/FollowRedirectTest_always.hf.yaml");
        int users = benchmark.phases().stream().filter(p -> "testPhase".equals(p.name())).mapToInt(p -> ((Model.AtOnce)p.model).users).findFirst().orElse(0);
        Map stats = this.runScenario(benchmark);
        HttpStats redirectMe = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get("redirectMe")));
        String redirectMetric = stats.keySet().stream().filter(m -> !m.equals("redirectMe")).findFirst().orElse(null);
        if (redirectMetric == null) {
            Assertions.assertThat((int)redirectMe.status_2xx).isEqualTo(users - this.notFound.get());
            Assertions.assertThat((int)redirectMe.status_3xx).isEqualTo(0);
            Assertions.assertThat((int)redirectMe.status_4xx).isEqualTo(this.notFound.get());
            Assertions.assertThat((int)this.redirects.get()).isEqualTo(0);
        } else {
            HttpStats redirectStats = HttpStats.get((StatisticsSnapshot)((StatisticsSnapshot)stats.get(redirectMetric)));
            Assertions.assertThat((int)(redirectMe.status_2xx + redirectMe.status_3xx)).isLessThanOrEqualTo(users).isGreaterThanOrEqualTo(users - this.notFound.get());
            Assertions.assertThat((int)(redirectStats.status_2xx + redirectStats.status_3xx)).isLessThanOrEqualTo(this.redirects.get()).isGreaterThanOrEqualTo(this.redirects.get() - this.notFound.get());
            Assertions.assertThat((int)(redirectStats.status_4xx + redirectMe.status_4xx)).isEqualTo(this.notFound.get());
        }
    }

    @Test
    public void testRelative() {
        ((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/redirect/me/relatively").handler().followRedirect(FollowRedirect.ALWAYS).endHandler();
        Map stats = this.runScenario();
        StatisticsSnapshot testStats = (StatisticsSnapshot)stats.get("test");
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)testStats).status_3xx).isEqualTo(1);
        Assertions.assertThat((int)testStats.responseCount).isEqualTo(1);
        StatisticsSnapshot otherStats = stats.entrySet().stream().filter(e -> !((String)e.getKey()).equals("test")).map(Map.Entry::getValue).findFirst().orElse(null);
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)otherStats).status_2xx).isEqualTo(2);
    }
}

