/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.core.VertxBaseTest;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.test.TestClock;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.time.Clock;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HttpCacheTest
extends VertxBaseTest {
    private static final Logger log = LogManager.getLogger(HttpCacheTest.class);
    private static final TestClock CLOCK = new TestClock();
    private static final Consumer<HttpRequest> GET_TEST = request -> {
        request.method = HttpMethod.GET;
        request.path = "/test";
    };
    private static final Consumer<HttpRequest> POST_TEST = request -> {
        request.method = HttpMethod.POST;
        request.path = "/test";
    };

    @Test
    public void testSimpleRequest(TestContext ctx) {
        Async async = ctx.async();
        Context context = new Context();
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.serverQueue.add(req -> req.response().end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
        });
        context.requests.add(() -> this.doRequest(context, POST_TEST, null));
        context.serverQueue.add(req -> req.response().end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            ctx.assertEquals((Object)HttpCache.get((Session)context.session).size(), (Object)0);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.serverQueue.add(req -> req.response().end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)3);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)3);
            ctx.assertEquals((Object)HttpCache.get((Session)context.session).size(), (Object)1);
            ctx.assertTrue(context.serverQueue.isEmpty());
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
            async.countDown();
        });
        this.test(ctx, context);
    }

    @Test
    public void testExpiration(TestContext ctx) {
        Async async = ctx.async();
        Context context = new Context();
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.serverQueue.add(req -> req.response().putHeader((CharSequence)HttpHeaderNames.EXPIRES, HttpUtil.formatDate((long)CLOCK.instant().plusSeconds(5L).toEpochMilli())).end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
            CLOCK.advance(6000L);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.serverQueue.add(req -> req.response().end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, (s, writer) -> writer.putHeader((CharSequence)HttpHeaderNames.CACHE_CONTROL, (CharSequence)"max-stale=10")));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            ctx.assertEquals((Object)HttpCache.get((Session)context.session).size(), (Object)1);
            ctx.assertTrue(context.serverQueue.isEmpty());
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
            async.countDown();
        });
        this.test(ctx, context);
    }

    @Test
    public void testEtag(TestContext ctx) {
        Async async = ctx.async();
        Context context = new Context();
        context.requests.add(() -> this.doRequest(context, GET_TEST, null));
        context.serverQueue.add(req -> req.response().putHeader((CharSequence)HttpHeaderNames.ETAG, (CharSequence)"\"foo\"").end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, (s, writer) -> writer.putHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (CharSequence)"\"bar\", \"foo\"")));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)1);
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, (s, writer) -> writer.putHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (CharSequence)"\"bar\"")));
        context.serverQueue.add(req -> req.response().putHeader((CharSequence)HttpHeaderNames.ETAG, (CharSequence)"\"bar\"").end());
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            ctx.assertEquals((Object)HttpCache.get((Session)context.session).size(), (Object)2);
            this.assertCacheHits(ctx, (HttpRequest)req, 0);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, (s, writer) -> writer.putHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (CharSequence)"\"foo\"")));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
        });
        context.requests.add(() -> this.doRequest(context, GET_TEST, (s, writer) -> writer.putHeader((CharSequence)HttpHeaderNames.IF_NONE_MATCH, (CharSequence)"\"bar\"")));
        context.handlers.add(req -> {
            ctx.assertEquals((Object)context.serverRequests.get(), (Object)2);
            this.assertCacheHits(ctx, (HttpRequest)req, 1);
            async.countDown();
        });
        this.test(ctx, context);
    }

    private void assertCacheHits(TestContext ctx, HttpRequest req, int hits) {
        this.assertStats(req, snapshot -> ctx.assertEquals((Object)HttpStats.get((StatisticsSnapshot)snapshot).cacheHits, (Object)hits));
    }

    private void assertStats(HttpRequest request, Consumer<StatisticsSnapshot> consumer) {
        Statistics statistics = request.statistics();
        statistics.end(System.currentTimeMillis());
        StatisticsSnapshot snapshot = new StatisticsSnapshot();
        statistics.visitSnapshots(arg_0 -> ((StatisticsSnapshot)snapshot).add(arg_0));
        consumer.accept(snapshot);
    }

    private void test(TestContext ctx, Context context) {
        assert (!context.requests.isEmpty());
        this.vertx.createHttpServer().requestHandler(req -> {
            Consumer<HttpServerRequest> handler = context.serverQueue.poll();
            if (handler == null) {
                ctx.fail("No handler for request.");
            }
            context.serverRequests.incrementAndGet();
            handler.accept((HttpServerRequest)req);
            if (!req.response().ended()) {
                ctx.fail("Response not sent");
            }
        }).listen(0, "localhost", event -> {
            if (event.failed()) {
                ctx.fail(event.cause());
            } else {
                HttpServer server = (HttpServer)event.result();
                this.cleanup.add(() -> ((HttpServer)server).close());
                try {
                    HttpBuilder builder = HttpBuilder.forTesting().host("localhost").port(server.actualPort());
                    HttpClientPoolImpl client = HttpClientPoolImpl.forTesting((Http)builder.build(true), (int)1);
                    client.start(arg_0 -> this.lambda$test$44(ctx, (HttpClientPool)client, context, arg_0));
                }
                catch (Exception e) {
                    ctx.fail((Throwable)e);
                }
            }
        });
    }

    private void doRequest(Context context, Consumer<HttpRequest> configurator, BiConsumer<Session, HttpRequestWriter> headerAppender) {
        BiConsumer[] biConsumerArray;
        HttpRequest request = (HttpRequest)HttpRequestPool.get((Session)context.session).acquire();
        HttpResponseHandlersImpl handlers = HttpResponseHandlersImpl.Builder.forTesting().onCompletion((Action & Serializable)s -> {
            Consumer<HttpRequest> handler = context.handlers.poll();
            if (handler != null) {
                handler.accept(request);
                Runnable command = context.requests.poll();
                if (command == null) {
                    return;
                }
                command.run();
            }
        }).build();
        configurator.accept(request);
        log.trace("Sending {} request to {}", (Object)request.method, (Object)request.path);
        HttpConnectionPool pool = context.pool.next();
        request.start(pool, (HttpResponseHandlers)handlers, new SequenceInstance(), new Statistics(System.currentTimeMillis()));
        if (headerAppender == null) {
            biConsumerArray = null;
        } else {
            BiConsumer[] biConsumerArray2 = new BiConsumer[1];
            biConsumerArray = biConsumerArray2;
            biConsumerArray2[0] = headerAppender;
        }
        BiConsumer[] headerAppenders = biConsumerArray;
        pool.acquire(false, connection -> request.send(connection, headerAppenders, true, null));
    }

    private /* synthetic */ void lambda$test$44(TestContext ctx, HttpClientPool client, Context context, AsyncResult result) {
        if (result.failed()) {
            ctx.fail(result.cause());
            return;
        }
        this.cleanup.add(() -> ((HttpClientPool)client).shutdown());
        context.session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
        HttpRunData.initForTesting((Session)context.session, (Clock)CLOCK);
        context.pool = client;
        context.requests.poll().run();
    }

    private class Context {
        Session session;
        HttpClientPool pool;
        Queue<Runnable> requests = new LinkedList<Runnable>();
        Queue<Consumer<HttpRequest>> handlers = new LinkedList<Consumer<HttpRequest>>();
        AtomicInteger serverRequests = new AtomicInteger();
        Queue<Consumer<HttpServerRequest>> serverQueue = new LinkedList<Consumer<HttpServerRequest>>();

        private Context() {
        }
    }
}

