/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class HttpClientPoolHandlerTest {
    protected volatile int count;
    private Vertx vertx = Vertx.vertx();
    private HttpServer httpServer;

    @Before
    public void before(TestContext ctx) {
        this.count = 0;
        this.httpServer = this.vertx.createHttpServer().requestHandler(req -> {
            ++this.count;
            req.response().putHeader("foo", "bar").end("hello from server");
        }).listen(0, "localhost", ctx.asyncAssertSuccess());
    }

    @After
    public void after(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void simpleHeaderRequest(TestContext ctx) throws Exception {
        Http http = HttpBuilder.forTesting().host("localhost").port(this.httpServer.actualPort()).build(true);
        HttpClientPoolImpl client = HttpClientPoolImpl.forTesting((Http)http, (int)1);
        CountDownLatch startLatch = new CountDownLatch(1);
        client.start(result -> {
            if (result.failed()) {
                ctx.fail(result.cause());
            } else {
                startLatch.countDown();
            }
        });
        Assertions.assertThat((boolean)startLatch.await(10L, TimeUnit.SECONDS)).isTrue();
        CountDownLatch latch = new CountDownLatch(4);
        HttpConnectionPool pool = client.next();
        pool.executor().execute(() -> {
            Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
            HttpRunData.initForTesting((Session)session);
            HttpRequest request = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
            HttpResponseHandlersImpl handlers = HttpResponseHandlersImpl.Builder.forTesting().status((StatusHandler & Serializable)(r, code) -> {
                Assertions.assertThat((int)code).isEqualTo(200);
                latch.countDown();
            }).header((HeaderHandler & Serializable)(req, header, value) -> {
                if ("foo".contentEquals(header)) {
                    Assertions.assertThat((String)"bar").asString().isEqualTo((Object)"bar");
                    latch.countDown();
                }
            }).body(f -> (Processor & Serializable)(s, input, offset, length, isLastPart) -> {
                byte[] bytes = new byte[length];
                input.getBytes(offset, bytes);
                Assertions.assertThat((String)new String(bytes)).isEqualTo((Object)"hello from server");
                latch.countDown();
            }).onCompletion((Action & Serializable)s -> latch.countDown()).build();
            request.method = HttpMethod.GET;
            request.path = "/";
            request.start(pool, (HttpResponseHandlers)handlers, new SequenceInstance(), new Statistics(System.currentTimeMillis()));
            pool.acquire(false, c -> request.send(c, null, true, null));
        });
        Assertions.assertThat((boolean)latch.await(3L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((int)this.count).isEqualTo(1);
        client.shutdown();
    }
}

