/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.session.BaseScenarioTest;
import io.hyperfoil.core.test.TestUtil;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.impl.Util;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public abstract class HttpScenarioTest
extends BaseScenarioTest {
    protected Router router;
    protected HttpServer server;

    @Before
    public void before(TestContext ctx) {
        super.before(ctx);
        this.router = Router.router((Vertx)this.vertx);
        this.initRouter();
        this.benchmarkBuilder.addPlugin(HttpPluginBuilder::new);
        this.startServer(ctx, this.useHttps(), this.useCompression());
    }

    protected Future<Void> startServer(TestContext ctx, boolean tls, boolean compression) {
        HttpServerOptions options = new HttpServerOptions();
        if (tls) {
            options.setSsl(true).setUseAlpn(true).setKeyStoreOptions(new JksOptions().setPath("keystore.jks").setPassword("test123"));
        }
        if (compression) {
            options.setCompressionSupported(true);
        }
        Promise promise = Promise.promise();
        this.server = this.vertx.createHttpServer(options).requestHandler((Handler)this.router).listen(0, "localhost", ctx.asyncAssertSuccess(srv -> {
            this.initWithServer(tls);
            promise.complete();
        }));
        return promise.future();
    }

    protected boolean useHttps() {
        return false;
    }

    protected boolean useCompression() {
        return false;
    }

    protected void initWithServer(boolean tls) {
        HttpPluginBuilder httpPlugin = (HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class);
        HttpBuilder http = httpPlugin.http();
        http.protocol(tls ? Protocol.HTTPS : Protocol.HTTP).name("myhost").host("localhost").port(this.server.actualPort());
        this.initHttp(http);
    }

    protected void initHttp(HttpBuilder http) {
    }

    protected abstract void initRouter();

    protected Benchmark loadBenchmark(InputStream config) throws IOException, ParserException {
        return BenchmarkParser.instance().buildBenchmark(config, TestUtil.benchmarkData(), Map.of("PORT", String.valueOf(this.server.actualPort())));
    }

    protected void serveResourceChunked(RoutingContext ctx, String resource) {
        try {
            InputStream index = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource);
            String html = Util.toString((InputStream)index);
            ctx.response().setChunked(true);
            int bodyStartIndex = html.indexOf("<body>");
            ctx.response().write(html.substring(0, bodyStartIndex), result -> this.vertx.setTimer(100L, ignores -> {
                ctx.response().write(html.substring(bodyStartIndex));
                ctx.response().end();
            }));
        }
        catch (IOException e) {
            ctx.response().setStatusCode(500).end();
        }
    }
}

