/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.VertxBaseTest;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.test.TestUtil;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpRunData;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.netty.buffer.ByteBuf;
import io.vertx.core.AsyncResult;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RawBytesHandlerTest
extends VertxBaseTest {
    @Test
    public void test(TestContext ctx) {
        Async async = ctx.async(1000);
        HttpServer httpServer = this.vertx.createHttpServer();
        httpServer.requestHandler(this::handler).listen(0, "localhost", event -> {
            if (event.failed()) {
                ctx.fail(event.cause());
            } else {
                HttpServer server = (HttpServer)event.result();
                this.cleanup.add(() -> ((HttpServer)server).close());
                try {
                    Http http = HttpBuilder.forTesting().protocol(Protocol.HTTP).host("localhost").port(server.actualPort()).allowHttp2(false).build(true);
                    HttpClientPoolImpl client = HttpClientPoolImpl.forTesting((Http)http, (int)1);
                    client.start(arg_0 -> this.lambda$test$1(ctx, (HttpClientPool)client, async, arg_0));
                }
                catch (Exception e) {
                    ctx.fail((Throwable)e);
                }
            }
        });
    }

    private void doRequest(TestContext ctx, Session session, AtomicReference<HttpResponseHandlers> handlersRef, HttpConnectionPool pool) {
        HttpRequest newRequest = (HttpRequest)HttpRequestPool.get((Session)session).acquire();
        newRequest.method = HttpMethod.GET;
        newRequest.path = "/ping";
        newRequest.cacheControl.noCache = true;
        SequenceInstance sequence = new SequenceInstance();
        sequence.reset(null, 0, new Step[0], null);
        newRequest.start(pool, handlersRef.get(), sequence, new Statistics(System.currentTimeMillis()));
        pool.acquire(false, c -> newRequest.send(c, null, true, null));
    }

    private void handler(HttpServerRequest request) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int headers = rand.nextInt(10);
        for (int i = 0; i < headers; ++i) {
            request.response().putHeader("x-foobar-" + i, TestUtil.randomString((ThreadLocalRandom)rand, (int)100));
        }
        request.response().setChunked(true);
        request.response().end(TestUtil.randomString((ThreadLocalRandom)rand, (int)2000));
    }

    private /* synthetic */ void lambda$test$1(TestContext ctx, HttpClientPool client, Async async, AsyncResult result) {
        if (result.failed()) {
            ctx.fail(result.cause());
            return;
        }
        this.cleanup.add(() -> ((HttpClientPool)client).shutdown());
        Session session = SessionFactory.forTesting((WriteAccess[])new WriteAccess[0]);
        HttpRunData.initForTesting((Session)session);
        AtomicReference<HttpResponseHandlers> handlersRef = new AtomicReference<HttpResponseHandlers>();
        handlersRef.set((HttpResponseHandlers)HttpResponseHandlersImpl.Builder.forTesting().rawBytes(new RawBytesHandler(){

            public void onRequest(Request request, ByteBuf buf, int offset, int length) {
            }

            public void onResponse(Request request, ByteBuf buf, int offset, int length, boolean isLastPart) {
            }
        }).onCompletion((Action & Serializable)s -> {
            async.countDown();
            if (!async.isCompleted()) {
                HttpConnectionPool pool = client.next();
                pool.executor().schedule(() -> this.doRequest(ctx, session, handlersRef, pool), 1L, TimeUnit.NANOSECONDS);
            }
        }).build());
        this.doRequest(ctx, session, handlersRef, client.next());
    }
}

