/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.ext.web.Router;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class TwoServersTest
extends HttpScenarioTest {
    CountDownLatch latch = new CountDownLatch(1);
    HttpServer secondServer;

    @Override
    protected void initRouter() {
        this.router.route("/test").handler(ctx -> {
            try {
                this.latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ctx.response().setStatusCode(200).end();
        });
    }

    @Override
    public void before(TestContext ctx) {
        super.before(ctx);
        Router secondRouter = Router.router((Vertx)this.vertx);
        secondRouter.route("/test").handler(context -> context.response().setStatusCode(300).end());
        this.secondServer = this.vertx.createHttpServer().requestHandler((Handler)secondRouter).listen(0, "localhost", ctx.asyncAssertSuccess(srv -> ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:" + this.secondServer.actualPort()).endHttp()));
    }

    @Test
    public void testTwoServers() {
        ((HttpStepCatalog)((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test").sync(false).metric("server1").endStep().step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).authority("localhost:" + this.secondServer.actualPort()).path("/test").sync(false).metric("server2").handler().onCompletion((Action & Serializable)s -> this.latch.countDown()).endHandler().endStep().step(HttpStepCatalog.SC)).awaitAllResponses();
        Map stats = this.runScenario();
        StatisticsSnapshot s1 = (StatisticsSnapshot)stats.get("server1");
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)s1).status_2xx).isEqualTo(1);
        StatisticsSnapshot s2 = (StatisticsSnapshot)stats.get("server2");
        Assertions.assertThat((int)HttpStats.get((StatisticsSnapshot)s2).status_3xx).isEqualTo(1);
    }

    @Test
    public void testServersWithSameHostAndPortAndDifferentName() {
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name("myhost1");
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name("myhost2");
        this.benchmarkBuilder.build();
    }

    @Test(expected=BenchmarkDefinitionException.class)
    public void testServersWithSameHostAndPortAndSameName() {
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name("myhost1");
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name("myhost1");
        this.benchmarkBuilder.build();
    }

    @Test(expected=BenchmarkDefinitionException.class)
    public void testServersWithSameHostAndPortAndNoName() {
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name(null);
        ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http("http://localhost:8080").name(null);
        this.benchmarkBuilder.build();
    }
}

