/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.core.generators.RandomItemStep;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.impl.LocalSimulationRunner;
import io.hyperfoil.core.impl.statistics.StatisticsCollector;
import io.hyperfoil.core.session.BaseScenarioTest;
import io.hyperfoil.core.util.LowHigh;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.connection.ConnectionPoolStats;
import io.hyperfoil.http.connection.SessionConnectionPool;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpRequestStepBuilder;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.core.Future;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ConnectionStatsTest
extends HttpScenarioTest {
    private static final String HTTP_1x = "HTTP 1.x";
    private static final String HTTP_2_TLS = "TLS + HTTP 2";
    private static final String BLOCKED_SESSIONS = "blocked sessions";
    private static final String IN_FLIGHT_REQUESTS = "in-flight requests";
    private static final String USED_CONNECTIONS = "used connections";

    @Override
    protected Future<Void> startServer(TestContext ctx, boolean tls, boolean compression) {
        return null;
    }

    private void startServer(TestContext ctx, boolean ssl) {
        Async async = ctx.async();
        super.startServer(ctx, ssl, false).onComplete(ctx.asyncAssertSuccess(nil -> async.complete()));
        async.await();
    }

    @Override
    protected void initRouter() {
        this.router.route("/ok").handler(ctx -> this.vertx.setTimer(5L, id -> ctx.response().end()));
        this.router.route("/error").handler(ctx -> this.vertx.setTimer(5L, id -> ctx.response().setStatusCode(400).end()));
        this.router.route("/close").handler(ctx -> ctx.response().close());
    }

    protected int threads() {
        return 1;
    }

    private HttpBuilder http() {
        return ((HttpPluginBuilder)this.benchmarkBuilder.plugin(HttpPluginBuilder.class)).http();
    }

    @Test
    public void testSingleOkSharedHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/ok", true);
    }

    @Test
    public void testSingleErrorSharedHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/error", true);
    }

    @Test
    public void testSingleCloseSharedHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/close", false);
    }

    @Test
    public void testSingleOkSessionPoolsHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(1);
        this.testSingle("/ok", true);
    }

    @Test
    public void testSingleErrorSessionPoolsHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(1);
        this.testSingle("/error", true);
    }

    @Test
    public void testSingleCloseSessionPoolsHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(1);
        this.testSingle("/close", false);
    }

    @Test
    public void testSingleOkSharedHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/ok", true);
    }

    @Test
    public void testSingleErrorSharedHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/error", true);
    }

    @Test
    public void testSingleCloseSharedHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(1);
        this.testSingle("/close", false);
    }

    @Test
    public void testSharedHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(3);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_1x).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isLessThanOrEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isLessThanOrEqualTo(3);
    }

    @Test
    public void testSharedHttp1xPipelining(TestContext ctx) {
        this.startServer(ctx, false);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(3).pipeliningLimit(5);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_1x).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isLessThanOrEqualTo(15);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isLessThanOrEqualTo(3);
    }

    @Test
    public void testSessionPoolsHttp1x(TestContext ctx) {
        this.startServer(ctx, false);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(3);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_1x).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isLessThanOrEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isLessThanOrEqualTo(3);
    }

    @Test
    public void testSessionPoolsHttp1xPipelining(TestContext ctx) {
        this.startServer(ctx, false);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(3).pipeliningLimit(5);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_1x).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isLessThanOrEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isLessThanOrEqualTo(3);
    }

    @Test
    public void testSharedHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(3);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_2_TLS).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isEqualTo(3);
    }

    @Test
    public void testSharedHttp2NoErrors(TestContext ctx) {
        this.startServer(ctx, true);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SHARED_POOL).sharedConnections(3);
        Map<String, LowHigh> stats = this.testConcurrent(false);
        Assertions.assertThat((int)stats.get((Object)HTTP_2_TLS).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)BLOCKED_SESSIONS).high).isEqualTo(0);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isEqualTo(3);
    }

    @Test
    public void testSessionPoolsHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        int connections = 3;
        this.http().connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(3);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)HTTP_2_TLS).high).isEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isLessThanOrEqualTo(3);
        Assertions.assertThat((int)stats.get((Object)USED_CONNECTIONS).high).isEqualTo(3);
    }

    @Test
    public void testNewHttp1x(TestContext ctx) {
        this.log.info("START testNewHttp1x");
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.ALWAYS_NEW);
        Map<String, LowHigh> stats = this.testConcurrent(true);
        Assertions.assertThat((int)stats.get((Object)IN_FLIGHT_REQUESTS).high).isEqualTo(stats.get((Object)USED_CONNECTIONS).high);
    }

    @Test
    public void testOnRequestHttp1x(TestContext ctx) {
        this.log.info("START testOnRequestHttp1x");
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.OPEN_ON_REQUEST);
        this.testConcurrent(true);
    }

    @Test
    public void testOnRequestHttp1xPipelining(TestContext ctx) {
        this.log.info("START testOnRequestHttp1xPipelining");
        this.startServer(ctx, false);
        this.http().connectionStrategy(ConnectionStrategy.OPEN_ON_REQUEST).pipeliningLimit(5);
        this.testConcurrent(true);
    }

    @Test
    public void testNewHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        this.http().connectionStrategy(ConnectionStrategy.ALWAYS_NEW);
        Map<String, LowHigh> stats = this.testConcurrent(true);
    }

    @Test
    public void testOnRequestHttp2(TestContext ctx) {
        this.startServer(ctx, true);
        this.http().connectionStrategy(ConnectionStrategy.OPEN_ON_REQUEST);
        Map<String, LowHigh> stats = this.testConcurrent(true);
    }

    private ConnectionPoolStats testSingle(String path, boolean response) {
        AtomicReference connectionPoolRef = new AtomicReference();
        ((HttpStepCatalog)((SequenceBuilder)((PhaseBuilder.AtOnce)this.benchmarkBuilder.addPhase("test").atOnce(1).duration(10L)).scenario().initialSequence("test").step((Step & Serializable)session -> {
            connectionPoolRef.set(HttpDestinationTable.get((Session)session).getConnectionPoolByAuthority(null));
            return true;
        })).step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path(path).endStep();
        BaseScenarioTest.TestStatistics requestStats = new BaseScenarioTest.TestStatistics((BaseScenarioTest)this);
        TestConnectionStats connectionStats = new TestConnectionStats();
        LocalSimulationRunner runner = new LocalSimulationRunner(this.benchmarkBuilder.build(), (StatisticsCollector.StatisticsConsumer)requestStats, null, (ConnectionStatsConsumer)connectionStats);
        runner.run();
        try {
            ((HttpConnectionPool)connectionPoolRef.get()).executor().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        ConnectionPoolStats connectionPool = connectionPoolRef.get() instanceof SessionConnectionPool ? (ConnectionPoolStats)((HttpConnectionPool)connectionPoolRef.get()).clientPool().next() : (ConnectionPoolStats)connectionPoolRef.get();
        Assertions.assertThat((int)connectionPool.usedConnections.current()).isEqualTo(0);
        Assertions.assertThat((int)connectionPool.inFlight.current()).isEqualTo(0);
        Assertions.assertThat((int)connectionPool.blockedSessions.current()).isEqualTo(0);
        StatisticsSnapshot snapshot = (StatisticsSnapshot)requestStats.stats().get("test");
        Assertions.assertThat((int)snapshot.requestCount).isEqualTo(1);
        Assertions.assertThat((int)snapshot.responseCount).isEqualTo(response ? 1 : 0);
        Assertions.assertThat((int)snapshot.connectionErrors).isEqualTo(response ? 0 : 1);
        connectionStats.stats.forEach((tag, lowHigh) -> ((AbstractIntegerAssert)Assertions.assertThat((int)lowHigh.low).describedAs(tag, new Object[0])).isLessThanOrEqualTo(lowHigh.high));
        connectionStats.stats.forEach((tag, lowHigh) -> ((AbstractIntegerAssert)Assertions.assertThat((int)lowHigh.low).describedAs(tag, new Object[0])).isGreaterThanOrEqualTo(0));
        return connectionPool;
    }

    private Map<String, LowHigh> testConcurrent(boolean errors) {
        ((HttpRequestStepBuilder)((HttpStepCatalog)((RandomItemStep.Builder)((HttpStepCatalog)((PhaseBuilder.ConstantRate)this.benchmarkBuilder.addPhase("test").constantRate(100).duration(2000L)).scenario().initialSequence("test").step(HttpStepCatalog.SC)).randomItem().toVar("path").list().add("/ok", 1.0).add("/error", errors ? 1.0 : 0.0).add("/close", errors ? 1.0 : 0.0).end()).endStep().step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path().fromVar((Object)"path").end()).endStep();
        BaseScenarioTest.TestStatistics requestStats = new BaseScenarioTest.TestStatistics((BaseScenarioTest)this);
        TestConnectionStats connectionStats = new TestConnectionStats();
        LocalSimulationRunner runner = new LocalSimulationRunner(this.benchmarkBuilder.build(), (StatisticsCollector.StatisticsConsumer)requestStats, null, (ConnectionStatsConsumer)connectionStats);
        runner.run();
        StatisticsSnapshot snapshot = (StatisticsSnapshot)requestStats.stats().get("test");
        HttpStats http = HttpStats.get((StatisticsSnapshot)snapshot);
        Assertions.assertThat((int)snapshot.requestCount).isGreaterThan(100);
        Assertions.assertThat((int)snapshot.responseCount).isEqualTo(snapshot.requestCount - snapshot.connectionErrors);
        Assertions.assertThat((int)snapshot.connectionErrors).isEqualTo(snapshot.requestCount - http.status_2xx - http.status_4xx);
        if (!errors) {
            Assertions.assertThat((int)http.status_4xx).isEqualTo(0);
        }
        connectionStats.stats.forEach((tag, lowHigh) -> ((AbstractIntegerAssert)Assertions.assertThat((int)lowHigh.low).describedAs(tag, new Object[0])).isLessThanOrEqualTo(lowHigh.high));
        connectionStats.stats.forEach((tag, lowHigh) -> ((AbstractIntegerAssert)Assertions.assertThat((int)lowHigh.low).describedAs(tag, new Object[0])).isGreaterThanOrEqualTo(0));
        return connectionStats.stats;
    }

    private static class TestConnectionStats
    implements ConnectionStatsConsumer {
        Map<String, LowHigh> stats = new HashMap<String, LowHigh>();

        private TestConnectionStats() {
        }

        public void accept(String authority, String tag, int min, int max) {
            LowHigh prev = this.stats.putIfAbsent(tag, new LowHigh(min, max));
            assert (prev == null);
        }
    }
}

