/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.ScheduleDelayStep;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class SessionPoolsTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.get("/").handler(ctx -> ctx.response().end());
    }

    @Override
    protected void initHttp(HttpBuilder http) {
        super.initHttp(http);
        http.connectionStrategy(ConnectionStrategy.SESSION_POOLS).sharedConnections(2);
    }

    protected int threads() {
        return 1;
    }

    @Test
    public void test(TestContext ctx) {
        HashSet runningSessions = new HashSet();
        ((HttpStepCatalog)((HttpStepCatalog)((HttpStepCatalog)((PhaseBuilder.Always)this.benchmarkBuilder.addPhase("test").always(10).duration(2000L)).scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/").handler().status(() -> {
            ObjectAccess connection = SessionFactory.objectAccess((Object)"connection");
            return (StatusHandler & Serializable)(request, status) -> connection.setObject(request.session, (Object)request.connection());
        }).endHandler().endStep().step(HttpStepCatalog.SC)).thinkTime().random(ScheduleDelayStep.RandomType.LINEAR).min(10L, TimeUnit.MILLISECONDS).max(100L, TimeUnit.MILLISECONDS).endStep().step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/").headers().header((CharSequence)HttpHeaderNames.CACHE_CONTROL, (CharSequence)"no-cache").endHeaders().handler().status(() -> {
            ReadAccess connection = SessionFactory.readAccess((Object)"connection");
            return (StatusHandler & Serializable)(request, status) -> {
                ctx.assertEquals(connection.getObject(request.session), (Object)request.connection());
                runningSessions.add(request.session);
            };
        });
        this.runScenario();
        Assertions.assertThat((int)runningSessions.size()).isEqualTo(10);
    }
}

