/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.cookie;

import io.hyperfoil.http.BaseMockConnection;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.cookie.CookieStore;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CookieStoreTest {
    @Test
    public void testSubdomainRequest() {
        CookieStore store = new CookieStore();
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; domain=hyperfoil.io;");
        MockWriter writer = new MockWriter("foo.hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
    }

    @Test
    public void testNoDomainRequest() {
        CookieStore store = new CookieStore();
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar;");
        MockWriter writer1 = new MockWriter("foo.hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer1);
        Assertions.assertThat((int)writer1.values.size()).isEqualTo(0);
        MockWriter writer2 = new MockWriter("hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer2);
        Assertions.assertThat((int)writer2.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer2.values.get(0)).isEqualTo((Object)"foo=bar");
    }

    @Test
    public void testSetSuperdomain() {
        CookieStore store1 = new CookieStore();
        store1.setCookie((CharSequence)"foo.hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; domain=hyperfoil.io;");
        MockWriter writer = new MockWriter("foo.hyperfoil.io", "/");
        store1.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
        CookieStore store2 = new CookieStore();
        store2.setCookie((CharSequence)"foo.hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; domain=bar.io;");
        MockWriter writer2 = new MockWriter("foo.hyperfoil.io", "/");
        store2.appendCookies((HttpRequestWriter)writer2);
        Assertions.assertThat((int)writer2.values.size()).isEqualTo(0);
        MockWriter writer3 = new MockWriter("bar.io", "/");
        store2.appendCookies((HttpRequestWriter)writer3);
        Assertions.assertThat((int)writer3.values.size()).isEqualTo(0);
    }

    @Test
    public void testSubpathRequest() {
        CookieStore store = new CookieStore();
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/foo/", (CharSequence)"foo=bar; path=/foo");
        MockWriter writer1 = new MockWriter("hyperfoil.io", "/foo/bar.php");
        store.appendCookies((HttpRequestWriter)writer1);
        Assertions.assertThat((int)writer1.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer1.values.get(0)).isEqualTo((Object)"foo=bar");
        MockWriter writer2 = new MockWriter("foo.hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer2);
        Assertions.assertThat((int)writer2.values.size()).isEqualTo(0);
    }

    @Test
    public void testRootPath() {
        CookieStore store = new CookieStore();
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/foo.php", (CharSequence)"foo=bar; path=/");
        MockWriter writer1 = new MockWriter("hyperfoil.io", "/foo/bar.php");
        store.appendCookies((HttpRequestWriter)writer1);
        Assertions.assertThat((int)writer1.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer1.values.get(0)).isEqualTo((Object)"foo=bar");
    }

    @Test
    public void testSetSuperpath() {
        CookieStore store1 = new CookieStore();
        store1.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/foo/bar.php", (CharSequence)"foo=bar; path=/");
        MockWriter writer = new MockWriter("hyperfoil.io", "/xxx/yyy");
        store1.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
        CookieStore store2 = new CookieStore();
        store2.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/foo/bar.php", (CharSequence)"foo=bar; path=/bar");
        MockWriter writer2 = new MockWriter("hyperfoil.io", "/bar/goo");
        store2.appendCookies((HttpRequestWriter)writer2);
        Assertions.assertThat((int)writer2.values.size()).isEqualTo(0);
        MockWriter writer3 = new MockWriter("hyperfoil.io", "/xxx");
        store2.appendCookies((HttpRequestWriter)writer3);
        Assertions.assertThat((int)writer3.values.size()).isEqualTo(0);
    }

    @Test
    public void testExpiration() {
        CookieStore store = new CookieStore();
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; expires=Mon, 12-Jul-2038 14:52:12 GMT");
        MockWriter writer = new MockWriter("hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; expires=Mon, 15-Sep-2012 16:11:45 GMT");
        writer = new MockWriter("foo.hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(0);
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; expires=Mon, 22-Jul-2038 14:52:12 GMT");
        writer = new MockWriter("hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; Max-Age=-1");
        writer = new MockWriter("foo.hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(0);
        store.setCookie((CharSequence)"hyperfoil.io", (CharSequence)"/", (CharSequence)"foo=bar; max-age=86400");
        writer = new MockWriter("hyperfoil.io", "/");
        store.appendCookies((HttpRequestWriter)writer);
        Assertions.assertThat((int)writer.values.size()).isEqualTo(1);
        Assertions.assertThat((CharSequence)writer.values.get(0)).isEqualTo((Object)"foo=bar");
    }

    private static class MockWriter
    implements HttpRequestWriter {
        final String host;
        final String path;
        final ArrayList<CharSequence> values = new ArrayList();

        private MockWriter(String host, String path) {
            this.host = host;
            this.path = path;
        }

        public HttpConnection connection() {
            return new BaseMockConnection(){

                @Override
                public String host() {
                    return host;
                }
            };
        }

        public HttpRequest request() {
            HttpRequest httpRequest = new HttpRequest(null);
            httpRequest.path = this.path;
            return httpRequest;
        }

        public void putHeader(CharSequence header, CharSequence value) {
            this.values.add(value);
        }
    }
}

