/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.cookie;

import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.http.HttpScenarioTest;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.statistics.HttpStats;
import io.hyperfoil.http.steps.HttpStepCatalog;
import io.vertx.core.http.Cookie;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class CookieTest
extends HttpScenarioTest {
    @Override
    protected void initRouter() {
        this.router.route("/test1").handler(ctx -> {
            ctx.addCookie(Cookie.cookie((String)"foo", (String)"bar"));
            ctx.response().end("Hello!");
        });
        this.router.route("/test2").handler(ctx -> {
            Cookie cookie = ctx.getCookie("foo");
            int status = cookie != null && cookie.getValue().equals("bar") ? 200 : 500;
            ctx.response().setStatusCode(status).end();
        });
    }

    @Test
    public void testRepeatCookie() {
        ((HttpStepCatalog)((HttpStepCatalog)this.scenario().initialSequence("test").step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test1").metric("test1").endStep().step(HttpStepCatalog.SC)).httpRequest(HttpMethod.GET).path("/test2").metric("test2").handler().status((StatusHandler & Serializable)(request, status) -> {
            if (status != 200) {
                request.markInvalid();
            }
        }).endHandler().endStep().endSequence();
        Map stats = this.runScenario();
        StatisticsSnapshot test1 = (StatisticsSnapshot)stats.get("test1");
        StatisticsSnapshot test2 = (StatisticsSnapshot)stats.get("test1");
        HttpStats http1 = HttpStats.get((StatisticsSnapshot)test1);
        HttpStats http2 = HttpStats.get((StatisticsSnapshot)test2);
        Assertions.assertThat((int)http1.status_5xx).isEqualTo(0);
        Assertions.assertThat((int)http1.status_2xx).isEqualTo(1);
        Assertions.assertThat((int)http2.status_5xx).isEqualTo(0);
        Assertions.assertThat((int)http2.status_2xx).isEqualTo(1);
    }
}

