/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.WriteAccess;
import io.hyperfoil.core.handlers.ExpectProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.test.TestUtil;
import io.hyperfoil.http.BaseMockConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.handlers.FilterHeaderHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.Test;

public class FilterHeaderHandlerTest {
    @Test
    public void testValue() {
        ExpectProcessor expect = new ExpectProcessor().expect(0, 6, true);
        FilterHeaderHandler handler = ((FilterHeaderHandler.Builder)new FilterHeaderHandler.Builder().processor(f -> expect).header().value((CharSequence)"foo").end()).build();
        HttpRequest request = this.requestMock(new WriteAccess[0]);
        TestUtil.resolveAccess((Session)request.session, (Object)handler);
        handler.beforeHeaders(request);
        handler.handleHeader(request, (CharSequence)"Foo", (CharSequence)"barxxx");
        handler.handleHeader(request, (CharSequence)"moo", (CharSequence)"xxx");
        handler.afterHeaders(request);
        expect.validate();
    }

    @Test
    public void testStartsWith() {
        ExpectProcessor expect = new ExpectProcessor().expect(0, 6, true);
        FilterHeaderHandler handler = ((FilterHeaderHandler.Builder)new FilterHeaderHandler.Builder().processor(f -> expect).header().startsWith((CharSequence)"foo").end()).build();
        HttpRequest request = this.requestMock(new WriteAccess[0]);
        TestUtil.resolveAccess((Session)request.session, (Object)handler);
        handler.beforeHeaders(request);
        handler.handleHeader(request, (CharSequence)"FooBar", (CharSequence)"barxxx");
        handler.handleHeader(request, (CharSequence)"fo", (CharSequence)"xxx");
        handler.handleHeader(request, (CharSequence)"moobar", (CharSequence)"xxx");
        handler.afterHeaders(request);
        expect.validate();
    }

    @Test
    public void testEndsWith() {
        ExpectProcessor expect = new ExpectProcessor().expect(0, 6, true);
        FilterHeaderHandler handler = ((FilterHeaderHandler.Builder)new FilterHeaderHandler.Builder().processor(f -> expect).header().endsWith((CharSequence)"bar").end()).build();
        HttpRequest request = this.requestMock(new WriteAccess[0]);
        TestUtil.resolveAccess((Session)request.session, (Object)handler);
        handler.beforeHeaders(request);
        handler.handleHeader(request, (CharSequence)"FooBar", (CharSequence)"barxxx");
        handler.handleHeader(request, (CharSequence)"ar", (CharSequence)"xxx");
        handler.handleHeader(request, (CharSequence)"moomar", (CharSequence)"xxx");
        handler.afterHeaders(request);
        expect.validate();
    }

    @Test
    public void testMatchVar() {
        ExpectProcessor expect = new ExpectProcessor().expect(0, 6, true);
        Locator.push((Locator)TestUtil.locator());
        FilterHeaderHandler handler = ((FilterHeaderHandler.Builder)new FilterHeaderHandler.Builder().processor(f -> expect).header().matchVar("myVar").end()).build();
        ObjectAccess access = SessionFactory.objectAccess((Object)"myVar");
        HttpRequest request = this.requestMock(new WriteAccess[]{access});
        TestUtil.resolveAccess((Session)request.session, (Object)handler);
        access.setObject(request.session, (Object)"Foo");
        Locator.pop();
        handler.beforeHeaders(request);
        handler.handleHeader(request, (CharSequence)"foo", (CharSequence)"barxxx");
        handler.handleHeader(request, (CharSequence)"moo", (CharSequence)"xxx");
        handler.afterHeaders(request);
        expect.validate();
    }

    private HttpRequest requestMock(WriteAccess ... accesses) {
        HttpRequest request = new HttpRequest(SessionFactory.forTesting((WriteAccess[])accesses));
        request.attach((Connection)new BaseMockConnection(){

            @Override
            public ChannelHandlerContext context() {
                return new EmbeddedChannel().pipeline().addFirst(new ChannelHandler[]{new ChannelHandlerAdapter(){}}).firstContext();
            }
        });
        return request;
    }
}

